package rearth.oritech.client.cablesurfer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_3417;

public class ZiplineFxHandler {
    
    private static final Map<UUID, ZiplineSoundInstance> ACTIVE_SOUNDS = new HashMap<>();
    
    public static void tick() {
        var level = class_310.method_1551().field_1687;
        if (level == null) {
            ACTIVE_SOUNDS.clear();
            return;
        }
        
        for (var player : level.method_18456()) {
            handlePlayerFX(player);
        }
        
        // cleanup sounds
        ACTIVE_SOUNDS.entrySet().removeIf(entry -> {
            var sound = entry.getValue();
            return sound.method_4793();
        });
    }
    
    private static void handlePlayerFX(class_1657 player) {
        
        if (!ClientZiplineHandler.isZiplining(player)) {
            return;
        }
        
        // add sound instance
        if (!ACTIVE_SOUNDS.containsKey(player.method_5667())) {
            var sound = new ZiplineSoundInstance(player);
            class_310.method_1551().method_1483().method_4873(sound);
            ACTIVE_SOUNDS.put(player.method_5667(), sound);
            
            player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(),
              class_3417.field_15082, player.method_5634(), 0.5f, 0.5f, false);
            player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(),
              class_3417.field_24063, player.method_5634(), 0.2f, 1f, false);
            
        }
        
        spawnParticles(player);
    }
    
    private static void spawnParticles(class_1657 player) {
        var random = player.method_37908().field_9229;
        var speed = player.method_18798().method_1033();
        
        if (speed < 0.1) return;
        
        // scale with speed
        if (random.method_43057() < (speed / 2.0f)) {
            
            double wireY = player.method_23318() + ClientZiplineHandler.HANG_OFFSET + 0.38;
            
            var vel = player.method_18798().method_1021(2.0);
            
            player.method_37908().method_8406(
              class_2398.field_29644,
              player.method_23317(), wireY, player.method_23321(),
              vel.field_1352 + (random.method_43057() - 0.5) * 0.2,
              vel.field_1351 + random.method_43057() * 0.2,
              vel.field_1350 + (random.method_43057() - 0.5) * 0.2
            );
            
            // scrape sound sometimes
            if (random.method_43057() > 0.85) {
                player.method_37908().method_8486(player.method_23317(), wireY, player.method_23321(),
                  class_3417.field_24062, player.method_5634(), 0.3f, 2.0f, false);
            }
        }
    }
    
}
