package rearth.oritech.client.cablesurfer;

import net.minecraft.class_1657;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5498;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.ServerZiplineHandler;

public class ClientZiplineHandler {
    
    private static boolean active = false;
    private static class_243 startPos;
    private static class_243 endPos;
    private static class_243 parallelStart;
    private static class_243 parallelEnd;
    
    private static float progress;          // 0.0 (Start) to 1.0 (End)
    private static float currentSpeed;      // Blocks per tick
    private static double totalDistance;
    
    // Config
    public static final float HANG_OFFSET = 1.65f;   // Distance below the wire (Eye height + arm length)
    private static final float DRAG = 0.97f;         // Air resistance (slows you down if you release W)
    private static final float GRAVITY_FORCE = 0.1f;
    
    private static class_5498 previousCamera;
    
    public static class_243 getStartPos() {
        return startPos;
    }
    
    public static class_243 getEndPos() {
        return endPos;
    }
    
    public static class_243 getParallelStart() {
        return parallelStart;
    }
    
    public static class_243 getParallelEnd() {
        return parallelEnd;
    }
    
    public static boolean isZiplining(class_1657 player) {
        return AttachmentApi.getAttachmentValue(player, ServerZiplineHandler.ZIPLINING_STATE);
    }
    
    public static void start(class_243 start, class_243 end, class_243 parStart, class_243 parEnd, float initialSpeed) {
        if (active) return; // Already riding
        
        var player = class_310.method_1551().field_1724;
        if (player == null) return;
        
        active = true;
        startPos = start;
        endPos = end;
        totalDistance = start.method_1022(end);
        parallelStart = parStart;
        parallelEnd = parEnd;
        
        var searchPos = player.method_19538().method_1031(0, HANG_OFFSET, 0);
        progress = calculateClosestProgress(start, end, searchPos);
        
        var cableDir = endPos.method_1020(startPos).method_1029();
        var lookDir = player.method_5720();
        
        currentSpeed = initialSpeed;
        
        // dot Product < 0 means looking opposite to cable direction
        if (cableDir.method_1026(lookDir) < 0) {
            currentSpeed = -initialSpeed;
        }
        if (currentSpeed == 0) currentSpeed = 0.15f;
        
        // force 3rd Person Camera
        previousCamera = class_310.method_1551().field_1690.method_31044();
        if (previousCamera == class_5498.field_26664 && Oritech.CONFIG.ziplineCameraSwitch()) {
            class_310.method_1551().field_1690.method_31043(class_5498.field_26665);
        }
        
        // Initial Snap
        var ropePos = CableMath.getAt(startPos, endPos, progress);
        var initialPos = ropePos.method_1031(0, -HANG_OFFSET, 0);
        player.method_5814(initialPos.field_1352, initialPos.field_1351, initialPos.field_1350);
        player.method_18799(player.method_5720().method_1021(currentSpeed));
    }
    
    private static float calculateClosestProgress(class_243 start, class_243 end, class_243 targetPos) {
        var bestDistSq = Double.MAX_VALUE;
        var bestT = 0.0f;
        
        var steps = (int) start.method_1022(end) + 1;
        
        for (int i = 0; i <= steps; i++) {
            float t = (float) i / steps;
            var pointOnWire = CableMath.getAt(start, end, t);
            
            double distSq = pointOnWire.method_1025(targetPos);
            if (distSq < bestDistSq) {
                bestDistSq = distSq;
                bestT = t;
            }
        }
        
        return bestT;
    }
    
    public static void onClientTick() {
        if (!active) return;
        
        var player = class_310.method_1551().field_1724;
        if (player == null || !player.method_5805() || !player.method_6047().method_31574(ItemContent.WRENCH)) {
            dismount(false);
            return;
        }
        
        NetworkManager.sendToServer(new ServerZiplineHandler.ZiplinePlayerUsePacket());
        
        // Shift -> Drop
        if (player.field_3913.field_3903) {
            dismount(false);
            return;
        }
        
        // Space -> Jump Off
        if (player.field_3913.field_3904) {
            dismount(true);
            return;
        }
        
        
        var directionMultiplier = 1;
        var cableDir = endPos.method_1020(startPos).method_1029();
        var lookDir = player.method_5720();
        
        // Dot Product < 0 means looking opposite to cable direction
        if (cableDir.method_1026(lookDir) < 0) {
            // Player is looking backwards. Swap start/end.
            directionMultiplier = -1;
        }
        
        var maxSpeed = Oritech.CONFIG.maxZiplineSpeed();
        var acceleration = Oritech.CONFIG.ziplineAcceleration();
        
        // W -> Accelerate
        if (player.field_3913.field_3910) {
            currentSpeed += acceleration * directionMultiplier;
        }
        // S -> Brake / Reverse
        else if (player.field_3913.field_3909) {
            currentSpeed -= acceleration * directionMultiplier;
        }
        
        // gravity calcs
        float t = progress;
        float tNext = class_3532.method_15363(t + 0.01f, 0.0f, 1.01f);
        var p1 = CableMath.getAt(startPos, endPos, t);
        var p2 = CableMath.getAt(startPos, endPos, tNext);
        class_243 tangent = p2.method_1020(p1).method_1029();
        double slopeY = tangent.field_1351; // -1 (Straight Down) to 1 (Straight Up)
        currentSpeed -= (float) (slopeY * GRAVITY_FORCE);
        
        // Apply Drag (Friction)
        currentSpeed *= DRAG;
        
        // Clamp Speed
        currentSpeed = class_3532.method_15363(currentSpeed, -maxSpeed, maxSpeed);
        
        // Convert speed (blocks/tick) to progress percentage (0.0-1.0)
        // distance = rate * time -> rate = distance / time (but here we step by speed)
        float progressDelta = (float) (currentSpeed / totalDistance);
        progress += progressDelta;
        
        // Check End of Line
        if (progress >= 1.0f) {
            progress = 1.0f;
            dismount(true); // Auto-jump at end
            return;
        } else if (progress <= 0.0f) {
            progress = 0.0f;
            currentSpeed = 0; // Hit the start, stop moving
            dismount(true);
        }
        
        // Calculate Position on Catenary Curve
        var ropePos = CableMath.getAt(startPos, endPos, progress);
        var nextPlayerPos = ropePos.method_1031(0, -HANG_OFFSET, 0);
        
        // auto dismount near end
        if (Math.abs(currentSpeed) > 0.6 && Oritech.CONFIG.ziplineAutoJump()) {
            var blocksRemaining = (1.0f - progress) * totalDistance;
            if (directionMultiplier < 0) blocksRemaining = progress * totalDistance;
            
            // Calculate ejection distance dynamically
            // Formula: Minimum Buffer + (Speed * Ticks_Ahead)
            var dynamicEjectDist = 1.5 + (Math.abs(currentSpeed) * 3);
            
            if (blocksRemaining < dynamicEjectDist) {
                dismount(false);
                var currentVel = player.method_18798();
                player.method_5814(nextPlayerPos.field_1352, nextPlayerPos.field_1351 + 1, nextPlayerPos.field_1350);
                player.method_18800(currentVel.field_1352 * 1.2, (currentVel.field_1351 > 0 ? currentVel.field_1351 * 1.2 : 0) + 0.7, currentVel.field_1350 * 1.2);
                playWooshSound(player);
                return;
            }
        }
        
        // We set the velocity to match the movement.
        // This ensures that if we dismount next tick, we carry the momentum.
        class_243 oldPos = player.method_19538();
        class_243 velocity = nextPlayerPos.method_1020(oldPos);
        
        var bounds = player.method_18377(class_4050.field_18076).method_30757(nextPlayerPos);
        bounds = bounds.method_1011(0.1);
        
        if (!player.method_37908().method_8587(player, bounds)) {
            dismount(false);
            return;
        }
        
        player.method_5814(nextPlayerPos.field_1352, nextPlayerPos.field_1351, nextPlayerPos.field_1350);
        player.method_18799(velocity);
        
        // Reset fall distance so we don't die on landing
        player.field_6017 = 0;
    }
    
    private static void dismount(boolean jump) {
        active = false;
        
        // Restore Camera
        if (previousCamera != null && Oritech.CONFIG.ziplineCameraSwitch()) {
            class_310.method_1551().field_1690.method_31043(previousCamera);
        }
        
        var player = class_310.method_1551().field_1724;
        if (player != null) {
            if (jump) {
                // Add a little hop upwards + carry forward momentum
                class_243 currentVel = player.method_18798();
                var playerPos = player.method_30950(0);
                player.method_5814(playerPos.field_1352, playerPos.field_1351 + 1, playerPos.field_1350);
                player.method_18800(currentVel.field_1352 * 1.5, currentVel.method_10214() * 1.2f + 0.6, currentVel.field_1350 * 1.5);
                playWooshSound(player);
            } else {
                // Just drop with current momentum
                player.method_5783(class_3417.field_15131, 0.5f, 1.5f);
            }
            
            var gustPos = player.method_30950(0);
            var random = player.method_37908().field_9229;
            var gustVel = player.method_18798();
            player.method_37908().method_8406(
              class_2398.field_47494,
              gustPos.field_1352, gustPos.field_1351 + 0.3, gustPos.field_1350,
              gustVel.field_1352 + random.method_43057() * 0.3, gustVel.field_1351 + random.method_43057() * 0.3, gustVel.field_1350 + random.method_43057() * 0.3
            );
        }
    }
    
    private static void playWooshSound(class_1657 player) {
        player.method_5783(class_3417.field_14610, 2f, 2.0f);
    }
}