package rearth.oritech.block.entity.processing;

import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.UpgradableMachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_9694;

public class PulverizerBlockEntity extends UpgradableMachineBlockEntity {
    
    public PulverizerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PULVERIZER_ENTITY, pos, state, Oritech.CONFIG.processingMachines.pulverizerData.energyPerTick());
    }
    
    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<class_1799> outputInventory, List<class_1799> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        combineSmallDusts(outputInventory, field_11863);
    }
    
    public static void combineSmallDusts(List<class_1799> outputInventory, class_1937 world) {
        // try compacting
        var smallDustStack = outputInventory.get(1);
        var baseResult = outputInventory.get(0);
        if (smallDustStack.method_7960() || smallDustStack.method_7947() < 9 || baseResult.method_7947() >= baseResult.method_7914())
            return;
        
        var recipeInputStacks = new ArrayList<class_1799>(9);
        for (int i = 0; i < 9; i++) {
            recipeInputStacks.add(i, smallDustStack.method_46651(1));
        }
        var craftingInv = class_9694.method_59986(3, 3, recipeInputStacks);
        
        var matches = world.method_8433().method_17877(class_3956.field_17545, craftingInv, world);
        
        if (matches.isEmpty()) return;
        
        // gets the result stack of each entry, then filters if the type matches, and then checks if there is a result
        var foundResult = !matches
                             .stream()
                             .map(elem -> elem.comp_1933().method_8110(null))
                             .filter(elem -> baseResult.method_7909().equals(elem.method_7909()))
                             .toList().isEmpty();
        
        if (foundResult) {
            smallDustStack.method_7934(9);
            baseResult.method_7933(1);
        }
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.pulverizerData.energyCapacity();
    }
    
    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.pulverizerData.maxEnergyInsertion();
    }
    
    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.PULVERIZER;
    }
    
    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 2);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 56, 38),
          new GuiSlot(1, 117, 38, true),
          new GuiSlot(2, 135, 38, true));
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.PULVERIZER_SCREEN;
    }
    
    @Override
    public int getInventorySize() {
        return 3;
    }
    
    @Override
    protected void useEnergy() {
        super.useEnergy();
        
        if (field_11863.field_9229.method_43057() > 0.7 && !inventory.method_5438(0).method_7960()) {
            var effect = new class_2392(class_2398.field_11218, inventory.method_5438(0).method_7972());
            var spawnAt = field_11867.method_46558().method_1031(0, 0.3, 0);
            var offsetX = (field_11863.field_9229.method_43057() - 0.5) * 0.1;
            var offsetY = (field_11863.field_9229.method_43057()) * 0.1;
            var offsetZ = (field_11863.field_9229.method_43057() - 0.5) * 0.1;
            ((class_3218) field_11863).method_14199(effect, spawnAt.method_10216(), spawnAt.method_10214(), spawnAt.method_10215(), 3, offsetX, offsetY, offsetZ, 0.08);
        }
        
        
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
          new class_2382(1, 0,0)
        );
    }
    
    @Override
    public float getCoreQuality() {
        return 2;
    }
}
