package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.AdditionalNetworkingProvider;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import rearth.oritech.util.FakeMachinePlayer;

public class PlacerBlockEntity extends ItemEnergyFrameInteractionBlockEntity implements AdditionalNetworkingProvider {
    
    private class_3222 placerPlayerEntity = null;
    
    public PlacerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PLACER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    protected boolean hasWorkAvailable(class_2338 toolPosition) {
        
        var firstBlock = getFirstInInventory();
        if (firstBlock == null) return false;
        var block = class_2248.method_9503(firstBlock.method_7909());
        if (block == null) return false;
        
        var targetPosition = toolPosition.method_10074();
        return Objects.requireNonNull(field_11863).method_8320(targetPosition).method_26204().equals(class_2246.field_10124) && block.method_9564().method_26184(field_11863, targetPosition);
    }
    
    @Override
    public void finishBlockWork(class_2338 processed) {
        
        var firstBlock = getFirstInInventory();
        if (firstBlock == null) return;
        var block = class_2248.method_9503(firstBlock.method_7909());
        if (block == null) return;
        
        var targetPosition = processed.method_10074();
        var direction = class_2350.field_11033;
        
        var hitResult = new class_3965(
          new class_243(
            (double)targetPosition.method_10263() + 0.5 + (double)direction.method_10148() * 0.5,
            (double)targetPosition.method_10264() + 0.5 + (double)direction.method_10164() * 0.5,
            (double)targetPosition.method_10260() + 0.5 + (double)direction.method_10165() * 0.5
          ),
          direction,
          targetPosition,
          false
        );
        
        var placementState = block.method_9605(new class_1750(getPlacerPlayerEntity(), class_1268.field_5808, firstBlock, hitResult));
        
        if (Objects.requireNonNull(field_11863).method_8320(targetPosition).method_26215() && placementState != null && placementState.method_26184(field_11863, targetPosition)) {
            field_11863.method_8501(targetPosition, placementState);
            firstBlock.method_7934(1);
            field_11863.method_8396(null, targetPosition, placementState.method_26231().method_10598(), class_3419.field_15245, 1f, 1f);
            super.finishBlockWork(processed);
        }
    }
    
    private class_1799 getFirstInInventory() {
        for (var stack : inventory.heldStacks) {
            if (stack != null && !stack.method_7960() && stack.method_7909() instanceof class_1747) {
                return stack;
            }
        }
        
        return null;
    }
    
    @Override
    public float getCoreQuality() {
        return 3f;
    }
    
    @Override
    public class_2680 getMachineHead() {
        return BlockContent.BLOCK_PLACER_HEAD.method_9564();
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
          new class_2382(0, -1, 0)
        );
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 56, 38));
    }
    
    @Override
    public class_1799 getToolheadAdditionalRender() {
        return getFirstInInventory();
    }
    
    @Override
    public float getMoveTime() {
        return Oritech.CONFIG.placerConfig.moveDuration() * this.getSpeedMultiplier();
    }
    
    @Override
    public float getWorkTime() {
        return Oritech.CONFIG.placerConfig.workDuration() * this.getSpeedMultiplier();
    }
    
    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.placerConfig.moveEnergyUsage();
    }
    
    @Override
    public int getOperationEnergyUsage() {
        return Oritech.CONFIG.placerConfig.workEnergyUsage();
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.PLACER_SCREEN;
    }
    
    @Override
    public List<Field> additionalSyncedFields(SyncType type) {
        if (type.equals(SyncType.TICK)) {
            try {
                return List.of(ItemEnergyFrameInteractionBlockEntity.class.getDeclaredField("inventory"));
            } catch (NoSuchFieldException e) {
                Oritech.LOGGER.error("unable to register inventory as extra synced field for placed block.");
            }
        }
        return List.of();
    }
    
    private class_1657 getPlacerPlayerEntity() {
        if (placerPlayerEntity == null && field_11863 instanceof class_3218 serverWorld) {
            placerPlayerEntity = FakeMachinePlayer.create(serverWorld, new GameProfile(UUID.randomUUID(), "oritech_placer"), inventory);
        }
        
        return placerPlayerEntity;
    }
}
