package rearth.oritech.block.entity.interaction;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.init.TagContent;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3917;
import net.minecraft.class_7225;

public class FertilizerBlockEntity extends ItemEnergyFrameInteractionBlockEntity implements FluidApi.BlockProvider {
    
    public static final long FLUID_USAGE = (long) (Oritech.CONFIG.fertilizerConfig.liquidPerBlockUsage() * FluidStackHooks.bucketAmount());   // per block, tick usage is this divided by work time
    
    @SyncField(SyncType.GUI_TICK)
    private final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(4 * FluidStackHooks.bucketAmount(), this::method_5431) {
        
        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            var fluid = toInsert.getFluid();
            if (fluid.equals(FluidContent.STILL_MINERAL_SLURRY.get()) || fluid.equals(class_3612.field_15910))
                return super.insert(toInsert, simulate);
            
            return 0;
        }
    };
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        fluidStorage.writeNbt(nbt, "");
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        fluidStorage.readNbt(nbt, "");
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 56, 38));
    }
    
    public FertilizerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.FERTILIZER_BLOCK_ENTITY, pos, state);
    }
    
    private long getWaterUsagePerTick() {
        return (long) (FLUID_USAGE / getWorkTime());
    }
    
    private boolean hasEnoughWater() {
        return fluidStorage.getAmount() >= getWaterUsagePerTick();
    }
    
    @Override
    protected boolean canProgress() {
        return hasEnoughWater() && super.canProgress();
    }
    
    @Override
    protected boolean hasWorkAvailable(class_2338 toolPosition) {
        
        var targetPosition = toolPosition.method_10074();
        var targetState = Objects.requireNonNull(field_11863).method_8320(targetPosition);
        
        // skip not grown crops
        if (canFertilizeFarmland(toolPosition)) return true;
        return targetState.method_26204() instanceof class_2256 fertilizable && fertilizable.method_9651(field_11863, targetPosition, targetState);
    }
    
    private boolean canFertilizeFarmland(class_2338 toolPosition) {
        var targetPosition = toolPosition.method_10087(2);
        var targetState = Objects.requireNonNull(field_11863).method_8320(targetPosition);
        
        if (targetState.method_26204() instanceof class_2344) {
            var moistureStatus = targetState.method_11654(class_2741.field_12510);
            return moistureStatus != 7;
        }
        
        return false;
    }
    
    @Override
    public void finishBlockWork(class_2338 processed) {
        
        var inventoryStack = inventory.method_5438(0);
        var fertilizerInInventory = !inventoryStack.method_7960() && inventoryStack.method_31573(TagContent.CONVENTIONAL_FERTILIZER);
        var mineralSlurried = fluidStorage.getFluid().equals(FluidContent.STILL_MINERAL_SLURRY.get());
        var fertilizerStrength = fertilizerInInventory ? 2 : 1;
        fertilizerStrength *= mineralSlurried ? 2 : 1;
        var fertilized = false;
        
        var targetPosition = processed.method_10074();
        var targetState = Objects.requireNonNull(field_11863).method_8320(targetPosition);
        
        if (!hasWorkAvailable(processed)) return;

        if (targetState.method_26204() instanceof class_2302 cropBlock) {
            var newAge = cropBlock.method_9829(targetState) + fertilizerStrength;
            newAge = Math.min(newAge, cropBlock.method_9827());
            field_11863.method_8652(targetPosition, cropBlock.method_9828(newAge), class_2248.field_31028);
            fertilized = true;
        } else if (targetState.method_26204() instanceof class_2256 fertilizable) {
            fertilizable.method_9652((class_3218) field_11863, field_11863.field_9229, targetPosition, targetState);
            if (fertilizerInInventory) {
                fertilizable.method_9652((class_3218) field_11863, field_11863.field_9229, targetPosition, targetState);
                fertilized = true;
            }
        }

        var farmlandPosition = processed.method_10087(2);
        var farmlandState = field_11863.method_8320(farmlandPosition);

        if (farmlandState.method_26204() instanceof class_2344 && farmlandState.method_11654(class_2741.field_12510) != 7) {
            field_11863.method_8501(farmlandPosition, farmlandState.method_11657(class_2741.field_12510, 7));
        }
        
        if (fertilized) {
            if (fertilizerInInventory) {
                inventoryStack.method_7934(1);
                inventory.method_5447(0, inventoryStack);
            }
            super.finishBlockWork(processed);
            ParticleContent.FERTILIZER_EFFECT.spawn(field_11863, class_243.method_24954(targetPosition), fertilizerStrength * 3 + 2);
            field_11863.method_8396(null, targetPosition, class_3417.field_33433, class_3419.field_15245, 1f, 1f);
        }
    }
    
    @Override
    public class_2680 getMachineHead() {
        return BlockContent.BLOCK_FERTILIZER_HEAD.method_9564();
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
          new class_2382(0, -1, 0)
        );
    }
    
    @Override
    protected void doProgress(boolean moving) {
        super.doProgress(moving);
        if (!moving && hasWorkAvailable(getCurrentTarget())) {
            fluidStorage.setAmount(fluidStorage.getAmount() - getWaterUsagePerTick());
            ParticleContent.WATERING_EFFECT.spawn(field_11863, class_243.method_24954(getCurrentTarget().method_10074()), 2);
        }
    }
    
    @Override
    public float getMoveTime() {
        return Oritech.CONFIG.fertilizerConfig.moveDuration() * this.getSpeedMultiplier();
    }
    
    @Override
    public float getWorkTime() {
        return Oritech.CONFIG.fertilizerConfig.workDuration() * this.getSpeedMultiplier();
    }
    
    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.fertilizerConfig.moveEnergyUsage();
    }
    
    @Override
    public int getOperationEnergyUsage() {
        return Oritech.CONFIG.fertilizerConfig.workEnergyUsage();
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.DESTROYER_SCREEN;
    }
    
    @Override
    public FluidApi.FluidStorage getFluidStorage(class_2350 direction) {
        return fluidStorage;
    }
}
