package rearth.oritech.block.entity.generators;

import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.PassiveGeneratorBlockEntity;
import rearth.oritech.block.blocks.generators.BigSolarPanelBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MultiblockMachineController;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_7225;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;


public class BigSolarPanelEntity extends PassiveGeneratorBlockEntity implements MultiblockMachineController, GeoBlockEntity {
    
    public static final RawAnimation FOLD = RawAnimation.begin().thenPlayAndHold("fold");
    public static final RawAnimation UNFOLD = RawAnimation.begin().thenPlayAndHold("unfold");
    
    // animation
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    private final AnimationController<BigSolarPanelEntity> animationController = getAnimationController();
    
    // multiblock
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList<>();
    private float coreQuality = 1f;
    
    // self
    private boolean isFolded;
    
    public BigSolarPanelEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.BIG_SOLAR_ENTITY, pos, state);
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        addMultiblockToNbt(nbt);
        nbt.method_10556("folded", isFolded);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        loadMultiblockNbtData(nbt);
        isFolded = nbt.method_10577("folded");
    }
    
    @Override
    public int getProductionRate() {
        var baseRate = ((BigSolarPanelBlock) this.method_11010().method_26204()).productionRate;
        var skyLightLevel = field_11863.method_8314(class_1944.field_9284, this.method_11016());
        isFolded = field_11863.method_23886() && skyLightLevel < 12;
        return (int) (coreQuality * baseRate);
    }
    
    @Override
    public boolean isProducing() {
        var skyLightLevel = field_11863.method_8314(class_1944.field_9284, this.method_11016());
        return !field_11863.method_23886() && skyLightLevel >= 12 && isActive(method_11010());
    }
    
    public void sendInfoMessageToPlayer(class_1657 player) {
        player.method_43496(class_2561.method_43469("message.oritech.generator.production_rate", getProductionRate(), getCoreQuality()));
    }
    
    // output only to north, down and south
    @Override
    protected Set<class_3545<class_2338, class_2350>> getOutputTargets(class_2338 pos, class_1937 world) {
        
        var res = new HashSet<class_3545<class_2338, class_2350>>();
        res.add(new class_3545<>(pos.method_10074(), class_2350.field_11033));
        res.add(new class_3545<>(pos.method_10072(), class_2350.field_11043));
        res.add(new class_3545<>(pos.method_10095(), class_2350.field_11035));
        
        return res;
        
    }
    
    //region multiblock
    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return coreBlocksConnected;
    }
    
    @Override
    public class_2350 getFacingForMultiblock() {
        return class_2350.field_11043;
    }
    
    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }
    
    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return null;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          // top
          new class_2382(1, 1, 1),
          new class_2382(0, 1, 1),
          new class_2382(-1, 1, 1),
          new class_2382(1, 1, 0),
          new class_2382(0, 1, 0),
          new class_2382(-1, 1, 0),
          new class_2382(1, 1, -1),
          new class_2382(0, 1, -1),
          new class_2382(-1, 1, -1),
          // bottom
          new class_2382(1, 0, 1),
          new class_2382(0, 0, 1),
          new class_2382(-1, 0, 1),
          new class_2382(1, 0, -1),
          new class_2382(0, 0, -1),
          new class_2382(-1, 0, -1)
        );
    }
    //endregion
    
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(animationController);
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    private AnimationController<BigSolarPanelEntity> getAnimationController() {
        return new AnimationController<>(this, state -> {
            
            if (!isActive(method_11010()))
                return state.setAndContinue(MachineBlockEntity.PACKAGED);
            
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    return state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            
            // update correct state on client
            var timeOfDay = getAdjustedTimeOfDay();
            var skyLightLevel = field_11863.method_8314(class_1944.field_9284, this.method_11016());
            var isDay = timeOfDay > 0 && timeOfDay < 12500;
            isFolded = !isDay || skyLightLevel < 12;
            
            if (isFolded) {
                return state.setAndContinue(FOLD);
            } else {
                if (state.isCurrentAnimation(MachineBlockEntity.IDLE)) {
                    return state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(UNFOLD);
                }
            }
        });
    }
    
    @Override
    public class_2338 getPosForMultiblock() {
        return method_11016();
    }
    
    @Override
    public class_1937 getWorldForMultiblock() {
        return method_10997();
    }
    
    public long getAdjustedTimeOfDay() {
        return (field_11863.method_8532() + getTimeOffset()) % 24000;
    }
    
    public int getTimeOffset() {
        var base = field_11867.method_10263() + field_11867.method_10260();
        return (int) (Math.sin((double) base / 60) * 100);
    }
    
    public boolean isActive(class_2680 state) {
        return state.method_11654(ASSEMBLED);
    }
    
    @Override
    public void triggerSetupAnimation() {
        // todo
    }
}
