package rearth.oritech.block.entity.arcane;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.wispforest.owo.util.VectorRandomUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.EnchanterScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;

import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public class EnchanterBlockEntity extends NetworkedBlockEntity
  implements ItemApi.BlockProvider, EnergyApi.BlockProvider, GeoBlockEntity, ScreenProvider, ExtendedMenuProvider {
    
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation UNPOWERED = RawAnimation.begin().thenPlayAndHold("unpowered");
    public static final RawAnimation WORKING = RawAnimation.begin().thenPlay("working");
    
    public record EnchanterStatistics(int requiredCatalysts, int availableCatalysts){
        public static EnchanterStatistics EMPTY = new EnchanterStatistics(-1, -1);
    }
    
    @SyncField({SyncType.GUI_OPEN, SyncType.TICK})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000, 1000, 0, this::method_5431);
    
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(2, this::method_5431, new InventorySlotAssignment(0, 1, 1, 1));
    
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    
    public static final class_2960 NONE_SELECTED = class_2960.method_60654("o:empty");
    
    @SyncField({SyncType.GUI_OPEN, SyncType.TICK})
    @NotNull
    public class_2960 selectedEnchantment = NONE_SELECTED;
    @SyncField({SyncType.GUI_OPEN, SyncType.TICK})
    public int progress;
    @SyncField({SyncType.GUI_OPEN, SyncType.TICK})
    public int maxProgress = 10;
    @SyncField({SyncType.GUI_OPEN, SyncType.TICK})
    public EnchanterStatistics statistics = EnchanterStatistics.EMPTY; // used for client display
    
    private final List<EnchantmentCatalystBlockEntity> cachedCatalysts = new ArrayList<>();
    private String activeAnimation = "idle";
    
    public EnchanterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ENCHANTER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        
        activeAnimation = "idle";
        
        if (world.method_8510() % 80 == 0)
            triggerAnim("machine", activeAnimation);
        
        // return early if there is no work to do
        statistics = EnchanterStatistics.EMPTY;
        var content = inventory.heldStacks.get(0);
        if (content.method_7960()
              || !inventory.method_5438(1).method_7960()
              || !content.method_7909().method_7870(content)
              || selectedEnchantment.equals(NONE_SELECTED)
              || !getSelectedEnchantment().method_40227()
              || !getSelectedEnchantment().comp_349().method_8192(content)) {
            progress = 0;
            return;
        }
        
        var existingLevel = content.method_58657().method_57536(getSelectedEnchantment());
        var maxLevel = getSelectedEnchantment().comp_349().method_8183();
        
        if (existingLevel >= maxLevel) return;
        
        maxProgress = getEnchantmentCost(getSelectedEnchantment().comp_349(), existingLevel + 1);
        
        if (canProgress(existingLevel + 1)) {
            this.method_5431();
            energyStorage.amount -= (long) getDisplayedEnergyUsage();
            progress++;
            activeAnimation = "working";
            
            var center = pos.method_46558();
            var offset = VectorRandomUtils.getRandomOffset(world, center, 4f);
            ParticleContent.WEED_KILLER.spawn(world, center, new ParticleContent.LineData(center, offset));
            
            if (progress >= maxProgress) {
                progress = 0;
                finishEnchanting();
                ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.method_46558(), maxProgress + 10);
                activeAnimation = "idle";
            }
        }
        
    }
    
    @Override
    public void sendUpdate(SyncType type) {
        super.sendUpdate(type);
        triggerAnim("machine", activeAnimation);
    }
    
    public class_6880<class_1887> getSelectedEnchantment() {
        if (selectedEnchantment.equals(NONE_SELECTED)) return null;
        var registry = field_11863.method_30349().method_30530(class_7924.field_41265);
        return registry.method_47983(registry.method_10223(selectedEnchantment));
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        nbt.method_10544("energy", energyStorage.amount);
        nbt.method_10582("selected", selectedEnchantment.toString());
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        energyStorage.amount = nbt.method_10537("energy");
        
        if (nbt.method_10545("selected")) {
            selectedEnchantment = class_2960.method_60654(nbt.method_10558("selected"));
        }
    }
    
    private void finishEnchanting() {
        var content = inventory.heldStacks.get(0);
        var existingLevel = content.method_58657().method_57536(getSelectedEnchantment());
        content.method_7978(getSelectedEnchantment(), existingLevel + 1);
        
        inventory.heldStacks.set(0, class_1799.field_8037);
        inventory.heldStacks.set(1, content);
        statistics = new EnchanterStatistics(0, cachedCatalysts.size());
    }
    
    private int getRequiredCatalystCount(int targetLevel) {
        return getSelectedEnchantment().comp_349().method_58446() + targetLevel;
    }
    
    private boolean canProgress(int targetLevel) {
        
        if (energyStorage.amount <= getDisplayedEnergyUsage()) {
            activeAnimation = "unpowered";
            return false;
        }
        
        if (field_11863.method_8510() % 15 == 0) updateNearbyCatalysts();
        var requiredCatalysts = getRequiredCatalystCount(targetLevel);
        
        statistics = new EnchanterStatistics(requiredCatalysts, cachedCatalysts.size());
        
        for (var catalyst : cachedCatalysts) {
            ParticleContent.CATALYST_CONNECTION.spawn(field_11863, field_11867.method_46558(), new ParticleContent.LineData(catalyst.method_11016().method_46558(), field_11867.method_10084().method_46558()));
        }
        
        if (cachedCatalysts.size() < requiredCatalysts) return false;
        
        // get a random entry where souls > 0
        Collections.shuffle(cachedCatalysts);
        var usedOne = cachedCatalysts.stream().filter(elem -> elem.collectedSouls > 0).findFirst();
        if (usedOne.isEmpty()) return false;
        
        usedOne.get().collectedSouls--;
        method_5431();
        
        return true;
    }
    
    private int getEnchantmentCost(class_1887 enchantment, int targetLevel) {
        return enchantment.method_58446() * targetLevel * Oritech.CONFIG.enchanterCostMultiplier() + 1;
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, "machine", 4, state -> PlayState.CONTINUE)
                          .triggerableAnim("working", WORKING)
                          .triggerableAnim("idle", IDLE)
                          .triggerableAnim("unpowered", UNPOWERED)
                          .setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()));
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    private void updateNearbyCatalysts() {
        var chunkRadius = 1;
        
        var startX = (field_11867.method_10263() >> 4) - chunkRadius;
        var startZ = (field_11867.method_10260() >> 4) - chunkRadius;
        var endX = (field_11867.method_10263() >> 4) + chunkRadius;
        var endZ = (field_11867.method_10260() >> 4) + chunkRadius;
        
        cachedCatalysts.clear();
        
        for (int chunkX = startX; chunkX <= endX; chunkX++) {
            for (int chunkZ = startZ; chunkZ <= endZ; chunkZ++) {
                var chunk = field_11863.method_8402(chunkX, chunkZ, class_2806.field_12803, false);
                if (chunk == null) continue;
                
                var entities = chunk.field_34543;
                // select all non-empty catalysts within range (16)
                var catalysts = entities.values()
                                  .stream()
                                  .filter(elem -> elem instanceof EnchantmentCatalystBlockEntity catalyst && catalyst.collectedSouls > 0 && elem.method_11016().method_19455(field_11867) < 16)
                                  .map(elem -> (EnchantmentCatalystBlockEntity) elem)
                                  .toList();
                cachedCatalysts.addAll(catalysts);
            }
        }
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new EnchanterScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 52, 58),
          new GuiSlot(1, 108, 58, true));
    }
    
    @Override
    public ArrowConfiguration getIndicatorConfiguration() {
        return new ArrowConfiguration(
          Oritech.id("textures/gui/modular/arrow_empty.png"),
          Oritech.id("textures/gui/modular/arrow_full.png"),
          73, 58, 29, 16, true);
    }
    
    @Override
    public BarConfiguration getEnergyConfiguration() {
        return new BarConfiguration(7, 7, 18, 71);
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 512; // todo config parameter
    }
    
    @Override
    public float getProgress() {
        return (float) progress / maxProgress;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.ENCHANTER_SCREEN;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    public static void receiveEnchantmentSelection(SelectEnchantingPacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        var blockEntity = player.method_37908().method_8321(packet.self);
        if (blockEntity instanceof EnchanterBlockEntity enchanterBlock) {
            enchanterBlock.selectedEnchantment = packet.enchantmentId;
        }
    }
    
    public record SelectEnchantingPacket(class_2338 self, class_2960 enchantmentId) implements class_8710 {
        
        public static final class_8710.class_9154<SelectEnchantingPacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("selected_enchant"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
    
}
