package rearth.oritech.block.entity.addons;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.DelegatingInventoryStorage;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.client.ui.InventoryProxyScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MachineAddonController;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;

public class InventoryProxyAddonBlockEntity extends AddonBlockEntity implements ItemApi.BlockProvider, ExtendedMenuProvider {
    
    private MachineAddonController cachedController;
    private int targetSlot = 0;
    
    private final DelegatingInventoryStorage inventory = new DelegatingInventoryStorage(this::getTargetItemStorage, this::isConnected) {
        
        @Override
        public int insert(class_1799 inserted, boolean simulate) {
            return insertToSlot(inserted, targetSlot, simulate);
        }
        
        @Override
        public int extract(class_1799 extracted, boolean simulate) {
            return extractFromSlot(extracted, targetSlot, simulate);
        }
        
        @Override
        public int insertToSlot(class_1799 inserted, int slot, boolean simulate) {
            if (slot != targetSlot) return 0;
            return super.insertToSlot(inserted, slot, simulate);
        }
        
        @Override
        public int extractFromSlot(class_1799 extracted, int slot, boolean simulate) {
            if (slot != targetSlot) return 0;
            return super.extractFromSlot(extracted, slot, simulate);
        }
    };
    
    public InventoryProxyAddonBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.INVENTORY_PROXY_ADDON_ENTITY, pos, state);
    }
    
    private ItemApi.InventoryStorage getTargetItemStorage() {
        
        var isUsed = this.method_11010().method_11654(MachineAddonBlock.ADDON_USED);
        if (!isUsed) return null;
        
        var controllerEntity = getCachedController();
        if (!(controllerEntity instanceof ItemApi.BlockProvider itemProvider)) return null;
        return itemProvider.getInventoryStorage(null);
    }
    
    private boolean isConnected() {
        var isUsed = this.method_11010().method_11654(MachineAddonBlock.ADDON_USED);
        return isUsed && getCachedController() != null;
    }
    
    private MachineAddonController getCachedController() {
        
        if (cachedController != null)
            return cachedController;
        
        cachedController = (MachineAddonController) Objects.requireNonNull(field_11863).method_8321(getControllerPos());
        return cachedController;
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        var data = new InventoryProxyScreenHandler.InvProxyData(field_11867, getControllerPos(), targetSlot);
        InventoryProxyScreenHandler.InvProxyData.PACKET_CODEC.encode(buf, data);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("title.oritech.inventory_proxy");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new InventoryProxyScreenHandler(syncId, playerInventory, this, getCachedController().getScreenProvider(), targetSlot);
    }
    
    public void setTargetSlot(int targetSlot) {
        this.targetSlot = targetSlot;
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("target_slot", targetSlot);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        targetSlot = nbt.method_10550("target_slot");
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    public static void receiveSlotSelection(InventoryProxySlotSelectorPacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        if (player.method_37908().method_8321(packet.position) instanceof InventoryProxyAddonBlockEntity addonBlock)
            addonBlock.setTargetSlot(packet.slot);
    }
    
    public record InventoryProxySlotSelectorPacket(class_2338 position, int slot) implements class_8710 {
        
        public static final class_8710.class_9154<InventoryProxySlotSelectorPacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("proxy_slot_sel"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}
