package rearth.oritech.block.entity.accelerator;

import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.NetworkedEventHandler;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.block.blocks.accelerator.AcceleratorPassthroughBlock;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class BlackHoleBlockEntity extends NetworkedBlockEntity implements NetworkedEventHandler {
    
    public class_2680 currentlyPulling;
    
    @SyncField
    public class_2338 currentlyPullingFrom;
    @SyncField
    public long pullingStartedAt;
    @SyncField
    public long pullTime;
    
    // if nothing is in influence, don't search so often
    private int waitTicks;
    
    // cache for outgoing hits
    private final Map<class_2338, ParticleCollectorBlockEntity> cachedCollectors = new HashMap<>();
    
    public BlackHoleBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.BLACK_HOLE_ENTITY, pos, state);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (waitTicks-- > 0) return;
        
        if (currentlyPullingFrom != null && pullingStartedAt + pullTime - 5 < world.method_8510()) {
            onPullingFinished();
            currentlyPullingFrom = null;
        }
        
        if (currentlyPullingFrom != null) return;
        
        int pullRange = Oritech.CONFIG.pullRange();
        
        for (var candidate : class_2338.method_25996(pos, pullRange, pullRange, pullRange)) {
            var candidateState = world.method_8320(candidate);
            if (candidate.equals(pos) || candidateState.method_26215() || candidateState.method_26164(TagContent.BLACK_HOLE_BLACKLIST) || !candidateState.method_26227().method_15769() || candidateState.method_26204().equals(class_2246.field_10008) || candidateState.method_26204().equals(BlockContent.BLACK_HOLE_BLOCK))
                continue;
            
            currentlyPullingFrom = candidate;
            currentlyPulling = candidateState;
            pullingStartedAt = world.method_8510();
            pullTime = (long) candidate.method_19455(pos) * Oritech.CONFIG.pullTimeMultiplier();
            world.method_8501(candidate, class_2246.field_10124.method_9564());
            method_5431();
            
            return;
        }
        
        if (currentlyPullingFrom == null) {
            waitTicks = Oritech.CONFIG.idleWaitTicks();
        }
    }
    
    private void onPullingFinished() {
        var from = currentlyPullingFrom;
        var pulledDir = class_243.method_24954(field_11867.method_10059(from));
        pulledDir = pulledDir.method_1029();
        
        for (int i = 0; i < 5; i++) {
            var shootDir = pulledDir.method_49272(field_11863.method_8409(), 0.5f);
            
            var cacheKey = getRayEnd(field_11867.method_46558(), shootDir.method_1029());
            var cachedHit = tryGetCachedCollector(cacheKey);
            if (cachedHit != null) {
                // re-use existing result
                ParticleContent.BLACK_HOLE_EMISSION.spawn(field_11863, field_11867.method_46558(), cachedHit.method_11016().method_46558());
                cachedHit.onParticleCollided();
            } else {
                // find target along exit line, and add it to cache
                var impactPos = basicRaycast(field_11867.method_46558().method_1019(pulledDir.method_1021(1.2)), shootDir, 12, field_11863);
                if (impactPos != null) {
                    ParticleContent.BLACK_HOLE_EMISSION.spawn(field_11863, field_11867.method_46558(), impactPos.method_46558());
                    
                    var candidate = field_11863.method_8321(impactPos);
                    if (candidate instanceof ParticleCollectorBlockEntity collectorEntity) {
                        collectorEntity.onParticleCollided();
                        cachedCollectors.put(cacheKey, collectorEntity);
                    } else {
                        // only cast one particle if no collector has been found (for performance sake to avoid all those searches)
                        break;
                    }
                    
                } else {
                    // only cast one particle if no block has been found (for performance sake to avoid all those searches)
                    ParticleContent.BLACK_HOLE_EMISSION.spawn(field_11863, field_11867.method_46558(), field_11867.method_46558().method_1019(shootDir.method_1021(15)));
                    break;
                }
            }
        }
        
    }
    
    private static class_2338 getRayEnd(class_243 shotFrom, class_243 shotDirection) {
        return class_2338.method_49638(shotFrom.method_1019(shotDirection.method_1021(12)));
    }
    
    private ParticleCollectorBlockEntity tryGetCachedCollector(class_2338 key) {
        
        var cachedResult = cachedCollectors.get(key);
        if (cachedResult == null) {
            // no cache
            return null;
        } else if (cachedResult.method_11015()) {
            cachedCollectors.remove(key);
            return null;
        }
        
        return cachedResult;
    }
    
    public static class_2338 basicRaycast(class_243 from, class_243 direction, int range, class_1937 world) {
        
        var checkedPositions = new HashSet<class_2338>();
        
        for (float i = 0; i < range; i += 0.3f) {
            var to = from.method_1019(direction.method_1021(i));
            var targetBlockPos = class_2338.method_49638(to);
            
            // avoid double checks
            if (checkedPositions.contains(targetBlockPos)) continue;
            checkedPositions.add(targetBlockPos);
            
            var targetState = world.method_8320(targetBlockPos);
            if (!canPassThrough(targetState, targetBlockPos)) return targetBlockPos;
        }
        
        return null;
    }
    
    
    private static boolean canPassThrough(class_2680 state, class_2338 blockPos) {
        // When targetting entities, don't let grass, vines, small mushrooms, pressure plates, etc. get in the way of the laser
        return state.method_26215() || !state.method_26227().method_15769() || state.method_26164(TagContent.LASER_PASSTHROUGH) || state.method_26204() instanceof AcceleratorPassthroughBlock;
    }
    
    @Override
    public void onNetworkUpdated() {
        if (currentlyPullingFrom != null)
            this.currentlyPulling = field_11863.method_8320(currentlyPullingFrom);
    }
}
