package rearth.oritech.block.blocks.pipes.fluid;

import org.apache.commons.lang3.function.TriFunction;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;

import java.util.HashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3726;

public class FluidPipeBlock extends GenericPipeBlock {
    
    public static HashMap<class_2960, GenericPipeInterfaceEntity.PipeNetworkData> FLUID_PIPE_DATA = new HashMap<>();

    public FluidPipeBlock(class_2251 settings) {
        super(settings);
    }
    
    @Override
    public TriFunction<class_1937, class_2338, class_2350, Boolean> apiValidationFunction() {
        return ((world, pos, direction) -> FluidApi.BLOCK.find(world, pos, direction) != null);
    }
    
    @Override
    public class_2680 getConnectionBlock() {
        return BlockContent.FLUID_PIPE_CONNECTION.method_9564();
    }
    
    @Override
    public class_2680 getNormalBlock() {
        return BlockContent.FLUID_PIPE.method_9564();
    }
    
    @Override
    public String getPipeTypeName() {
        return "fluid";
    }
    
    // to connect when a neighboring block emits a block update (e.g. the centrifuge getting a fluid addon)
    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);

        world.method_30092(pos, method_9559(state, class_2350.method_58251(class_243.method_24954(sourcePos.method_10059(pos))), world.method_8320(sourcePos), world, pos, sourcePos), class_2248.field_31028, 0);
    }
    
    @Override
    public boolean connectToOwnBlockType(class_2248 block) {
        return block instanceof FluidPipeBlock || block instanceof FluidPipeConnectionBlock || block instanceof FluidPipeDuctBlock;
    }
    
    @Override
    public GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(class_1937 world) {
        return FLUID_PIPE_DATA.computeIfAbsent(world.method_27983().method_29177(), data -> new GenericPipeInterfaceEntity.PipeNetworkData());
    }

	public static class FramedFluidPipeBlock extends FluidPipeBlock {

		public FramedFluidPipeBlock(class_2251 settings) {
			super(settings);
		}

		@Override
		public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
			return class_259.method_1077();
		}

		@Override
		public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
			return state.method_26218(world, pos);
		}

		@Override
		public class_2680 getNormalBlock() {
			return BlockContent.FRAMED_FLUID_PIPE.method_9564();
		}

		@Override
		public class_2680 getConnectionBlock() {
			return BlockContent.FRAMED_FLUID_PIPE_CONNECTION.method_9564();
		}
    }
}
