package rearth.oritech.api.item.containers;

import io.netty.buffer.ByteBuf;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;

import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9139;

public class SimpleInventoryStorage implements class_1263, ItemApi.InventoryStorage, UpdatableField<Void, List<class_1799>> {
    
    private final int size;
    public final class_2371<class_1799> heldStacks;
    
    private final Runnable onUpdate;
    
    public SimpleInventoryStorage(int size, Runnable onUpdate) {
        this.size = size;
        this.onUpdate = onUpdate;
        this.heldStacks = class_2371.method_10213(size, class_1799.field_8037);
    }
    
    @Override
    public int insert(class_1799 toInsert, boolean simulate) {
        var remaining = toInsert.method_7947();
        for (var slot = 0; slot < method_5439() && remaining > 0; slot++) {
            remaining -= insertToSlot(toInsert.method_46651(remaining), slot, simulate);
        }
        
        return toInsert.method_7947() - remaining;
    }
    
    @Override
    public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
        var slotStack = method_5438(slot);
        var slotLimit = Math.min(getSlotLimit(slot), addedStack.method_7914());
        
        if (slotStack.method_7960()) {
            var toInsert = Math.min(slotLimit, addedStack.method_7947());
            if (!simulate) method_5447(slot, addedStack.method_46651(toInsert));
            return toInsert;
        }
        
        if (class_1799.method_31577(slotStack, addedStack)) {
            var available = slotLimit - slotStack.method_7947();
            var toInsert = Math.min(available, addedStack.method_7947());
            if (toInsert > 0) {
                if (!simulate) slotStack.method_7933(toInsert);
                return toInsert;
            }
        }
        
        return 0;
    }
    
    @Override
    public int extract(class_1799 toExtract, boolean simulate) {
        var remaining = toExtract.method_7947();
        for (var slot = 0; slot < method_5439() && remaining > 0; slot++) {
            remaining -= extractFromSlot(toExtract.method_46651(remaining), slot, simulate);
        }
        return toExtract.method_7947() - remaining;
    }
    
    @Override
    public int extractFromSlot(class_1799 extracted, int slot, boolean simulate) {
        var slotStack = method_5438(slot);
        if (slotStack.method_7960() || !class_1799.method_31577(slotStack, extracted))
            return 0;
        
        var toExtract = Math.min(slotStack.method_7947(), extracted.method_7947());
        if (!simulate) slotStack.method_7934(toExtract);
        return toExtract;
    }
    
    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        this.method_5447(slot, stack);
    }
    
    @Override
    public class_1799 getStackInSlot(int slot) {
        return this.method_5438(slot);
    }
    
    @Override
    public int getSlotCount() {
        return this.method_5439();
    }
    
    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }
    
    @Override
    public void update() {
        onUpdate.run();
    }
    
    
    // these are mostly a copy of SimpleInventory, with minor changes and only essential things included to avoid confusion
    @Override
    public int method_5439() {
        return size;
    }
    
    @Override
    public boolean method_5442() {
        for (var itemStack : this.heldStacks) {
            if (!itemStack.method_7960()) {
                return false;
            }
        }
        
        return true;
    }
    
    @Override
    public class_1799 method_5438(int slot) {
        return heldStacks.get(slot);
    }
    
    @Override
    public class_1799 method_5434(int slot, int amount) {
        var itemStack = class_1262.method_5430(this.heldStacks, slot, amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        
        return itemStack;
    }
    
    @Override
    public class_1799 method_5441(int slot) {
        var itemStack = this.heldStacks.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        } else {
            this.heldStacks.set(slot, class_1799.field_8037);
            return itemStack;
        }
    }
    
    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.heldStacks.set(slot, stack);
        stack.method_58408(this.method_58350(stack));
        this.method_5431();
    }
    
    @Override
    public void method_5431() {
        this.update();
    }
    
    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }
    
    @Override
    public void method_5448() {
        this.heldStacks.clear();
        this.method_5431();
    }
    
    public class_2371<class_1799> getHeldStacks() {
        return heldStacks;
    }
    
    @Override
    public List<class_1799> getDeltaData() {
        return heldStacks;
    }
    
    @Override
    public Void getFullData() {
        return null;
    }
    
    @Override
    public class_9139<? extends ByteBuf, List<class_1799>> getDeltaCodec() {
        return class_1799.field_49269;
    }
    
    @Override
    public class_9139<? extends ByteBuf, Void> getFullCodec() {
        return null;
    }
    
    @Override
    public boolean useDeltaOnly(SyncType type) {
        return true;
    }
    
    @Override
    public void handleFullUpdate(Void updatedData) {
    
    }
    
    @Override
    public void handleDeltaUpdate(List<class_1799> updatedData) {
        this.heldStacks.clear();
        
        for (int i = 0; i < updatedData.size(); i++) {
            var added = updatedData.get(i);
            this.heldStacks.set(i, added);
        }
        
    }
}
