package rearth.oritech.api.fluid;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import rearth.oritech.Oritech;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.StackContext;

import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_9331;

public interface ItemFluidApi {
    
    void registerForItem(Supplier<class_1792> itemSupplier);
    
    FluidApi.FluidStorage find(StackContext stack);
    
    default class_9331<FluidStack> getFluidComponent() {
        return ComponentContent.STORED_FLUID.get();
    }
    
    static boolean tryFluidBlockItemInteraction(class_1799 stack, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        var blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof FluidApi.BlockProvider tankEntity)) {
            return false;
        }
        
        var usedStack = stack;
        if (stack.method_7947() > 1) {
            usedStack = stack.method_46651(1);
        }
        
        var stackRef = new StackContext(usedStack, updated -> {
            if (stack.method_7947() > 1) {
                stack.method_7934(1);
                if (!player.method_31548().method_7394(updated)) {
                    player.method_7328(updated, true);
                }
            } else {
                player.method_6122(hand, updated);
            }
        });
        
        var candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null) {
            return false;
        }
        
        var fluidStorage = tankEntity.getFluidStorage(null);
        
        if (!world.field_9236) {
            if (candidate.getContent().getFirst().isEmpty()) { // from tank to item
                var moved = FluidApi.transferLastIncludingInputs(fluidStorage, candidate, FluidStackHooks.bucketAmount() * 8, false);
                Oritech.LOGGER.debug("moved to item {} {}", moved, stackRef.getValue());
            } else {    // from item to tank
                var moved = FluidApi.transferFirst(candidate, fluidStorage, FluidStackHooks.bucketAmount() * 8, false);
                Oritech.LOGGER.debug("moved from item {} {}", moved, stackRef.getValue());
            }
        }
        
        return true;
    }
}
