/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record FluidIngredient(Either<class_6862<class_3611>, class_2960> fluidContent, long amount) implements Predicate<FluidStack>
{
    public static final Endec<FluidIngredient> FLUID_INGREDIENT_ENDEC = StructEndecBuilder.of((StructField)CodecUtils.eitherEndec((Endec)Endec.STRING.xmap(s -> {
        if (s.charAt(0) != '#') {
            throw new IllegalStateException("tag must start with #");
        }
        return class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)class_2960.method_60654((String)s.substring(1)));
    }, tag -> "#" + String.valueOf(tag.comp_327())), (Endec)MinecraftEndecs.IDENTIFIER).fieldOf("fluid", FluidIngredient::fluidContent), (StructField)Endec.LONG.optionalFieldOf("amount", FluidIngredient::amount, (Object)FluidStack.bucketAmount()), FluidIngredient::new);
    public static final class_9139<ByteBuf, class_6862<class_3611>> FLUID_TAG_KEY_CODEC = class_2960.field_48267.method_56432(id -> class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)id), class_6862::comp_327);
    public static final class_9139<class_9129, Either<class_6862<class_3611>, class_2960>> FLUID_CONTENT_CODEC = class_9135.method_57995(FLUID_TAG_KEY_CODEC, (class_9139)class_2960.field_48267);
    public static final class_9139<class_9129, FluidIngredient> PACKET_CODEC = class_9139.method_56435(FLUID_CONTENT_CODEC, FluidIngredient::fluidContent, (class_9139)class_9135.field_48551, FluidIngredient::amount, FluidIngredient::new);
    public static final FluidIngredient EMPTY = new FluidIngredient();

    public FluidIngredient() {
        this((Either<class_6862<class_3611>, class_2960>)Either.right((Object)class_7923.field_41173.method_10221((Object)class_3612.field_15906)), 0L);
    }

    public FluidIngredient withContent(class_2960 fluidId) {
        return new FluidIngredient((Either<class_6862<class_3611>, class_2960>)Either.right((Object)fluidId), this.amount == 0L && class_7923.field_41173.method_10223(fluidId) != class_3612.field_15906 ? FluidStack.bucketAmount() : this.amount);
    }

    public FluidIngredient withContent(class_5321<class_3611> fluidKey) {
        return this.withContent(fluidKey.method_29177());
    }

    public FluidIngredient withContent(class_3611 fluid) {
        return this.withContent(class_7923.field_41173.method_10221((Object)fluid));
    }

    public FluidIngredient withContent(class_6862<class_3611> fluidTag) {
        return new FluidIngredient((Either<class_6862<class_3611>, class_2960>)Either.left(fluidTag), this.amount == 0L ? FluidStack.bucketAmount() : this.amount);
    }

    public FluidIngredient withAmount(long withAmount) {
        return new FluidIngredient(this.fluidContent, withAmount);
    }

    public FluidIngredient withAmount(float withAmountInBuckets) {
        return new FluidIngredient(this.fluidContent, (long)(withAmountInBuckets * (float)FluidStack.bucketAmount()));
    }

    public FluidIngredient withSpecificAmount(long amountInMillis) {
        return new FluidIngredient(this.fluidContent, amountInMillis);
    }

    public static FluidIngredient ofStack(FluidStack fluidStack) {
        return new FluidIngredient((Either<class_6862<class_3611>, class_2960>)Either.right((Object)class_7923.field_41173.method_10221((Object)fluidStack.getFluid())), fluidStack.getAmount());
    }

    public class_2561 name() {
        class_2960 fluidId = (class_2960)this.fluidContent.map(tag -> tag.comp_327(), id -> id);
        return this.hasTag() ? class_2561.method_30163((String)("#" + fluidId.method_12836() + ":" + fluidId.method_12832())) : class_2561.method_43471((String)("fluid." + ((class_2960)this.fluidContent.map(tag -> tag.comp_327(), id -> id)).method_42094()));
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStack) {
        return this.matchesFluid(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public boolean matchesFluid(class_3611 fluid) {
        ((class_3611)class_7923.field_41173.method_10223(class_2960.method_60654((String)""))).method_15780(fluid);
        return (Boolean)this.fluidContent.map(tag -> class_7923.field_41173.method_47983((Object)fluid).method_40220(tag), id -> ((class_3611)class_7923.field_41173.method_10223(id)).method_15780(fluid));
    }

    public boolean matchesFluid(@Nullable FluidStack fluidStack) {
        return fluidStack != null && this.matchesFluid(fluidStack.getFluid());
    }

    public List<FluidStack> getFluidStacks() {
        return (List)this.fluidContent.map(tag -> class_7923.field_41173.method_40270().filter(fluidEntry -> fluidEntry.method_40220(tag)).map(fluidEntry -> FluidStack.create((class_3611)((class_3611)fluidEntry.comp_349()), (long)this.amount)).collect(Collectors.toList()), id -> List.of(FluidStack.create((class_3611)((class_3611)class_7923.field_41173.method_10223((class_2960)this.fluidContent.right().get())), (long)this.amount)));
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean hasTag() {
        return this.fluidContent.left().isPresent();
    }

    public class_6862<class_3611> getTag() {
        return (class_6862)this.fluidContent.left().get();
    }

    public class_3611 getFluid() {
        return (class_3611)class_7923.field_41173.method_10223((class_2960)this.fluidContent.right().get());
    }

    @Override
    public String toString() {
        return "FluidIngredient{fluidContent={tag=" + String.valueOf(this.fluidContent.left()) + ", id=" + String.valueOf(this.fluidContent.right()) + "}, amount=" + this.amount + "}";
    }
}

