/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.harvesting;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_6862;
import net.minecraft.class_756;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.TreefellerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.PromethiumToolRenderer;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PromethiumAxeItem
extends class_1743
implements GeoItem {
    public static final Deque<class_3545<class_1937, class_2338>> pendingBlocks = new ArrayDeque<class_3545<class_1937, class_2338>>();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PromethiumAxeItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
        class_9424 toolComponent = new class_9424(List.of(class_9424.class_9425.method_58427((class_6862)toolMaterial.method_58419()), class_9424.class_9425.method_58428((class_6862)class_3481.field_33713, (float)toolMaterial.method_8027()), class_9424.class_9425.method_58433((class_6862)class_3481.field_44469, (float)1.5f), class_9424.class_9425.method_58431(List.of(class_2246.field_10343), (float)15.0f)), 1.0f, 1);
        this.field_49263 = settings.method_57349(class_9334.field_50077, (Object)toolComponent).method_58406();
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        class_2338 startPos;
        class_2680 startState;
        if (!world.field_9236 && miner.method_5715() && (startState = world.method_8320(startPos = pos.method_10084())).method_26164(class_3481.field_15475)) {
            Deque<class_2338> treeBlocks = TreefellerBlockEntity.getTreeBlocks(startPos, world);
            pendingBlocks.addAll(treeBlocks.stream().map(elem -> new class_3545((Object)world, elem)).toList());
        }
        return true;
    }

    public static void processPendingBlocks(class_1937 world) {
        if (pendingBlocks.isEmpty()) {
            return;
        }
        class_1937 topWorld = (class_1937)pendingBlocks.getFirst().method_15442();
        if (topWorld != world) {
            return;
        }
        for (int i = 0; i < 8 && !pendingBlocks.isEmpty(); ++i) {
            class_2338 candidate = (class_2338)pendingBlocks.pollFirst().method_15441();
            class_2680 candidateState = world.method_8320(candidate);
            if (!candidateState.method_26164(class_3481.field_15475) && !candidateState.method_26164(class_3481.field_15503)) {
                return;
            }
            List dropped = class_2248.method_9562((class_2680)candidateState, (class_3218)((class_3218)world), (class_2338)candidate, null);
            world.method_8501(candidate, class_2246.field_10124.method_9564());
            dropped.forEach(elem -> world.method_8649((class_1297)new class_1542(world, (double)candidate.method_10263(), (double)candidate.method_10264(), (double)candidate.method_10260(), elem)));
            world.method_8396(null, candidate, candidateState.method_26231().method_10595(), class_3419.field_15245, 0.5f, 1.0f);
            world.method_31595(candidate, candidateState);
            ParticleContent.BLOCK_DESTROY_EFFECT.spawn(world, class_243.method_24954((class_2382)candidate), (Object)4);
            if (candidateState.method_26164(class_3481.field_15475)) break;
        }
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PromethiumToolRenderer renderer;

            @Nullable
            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PromethiumToolRenderer("promethium_axe");
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void onTick(class_3218 serverWorld) {
        PromethiumAxeItem.processPendingBlocks((class_1937)serverWorld);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.promethium_axe").method_27692(class_124.field_1063));
    }
}

