/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import rearth.oritech.block.blocks.reactor.ReactorAbsorberBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatPipeBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatVentBlock;
import rearth.oritech.block.blocks.reactor.ReactorRodBlock;
import rearth.oritech.block.entity.reactor.ReactorAbsorberPortEntity;
import rearth.oritech.block.entity.reactor.ReactorControllerBlockEntity;
import rearth.oritech.block.entity.reactor.ReactorFuelPortEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.ReactorScreenHandler;
import rearth.oritech.client.ui.components.ReactorBlockRenderComponent;
import rearth.oritech.client.ui.components.ReactorPreviewContainer;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.TooltipHelper;

public class ReactorScreen
extends BaseOwoHandledScreen<FlowLayout, ReactorScreenHandler> {
    private ArrayList<class_3545<Integer, ReactorBlockRenderComponent>> activeComponents;
    private HashSet<ReactorBlockRenderComponent> activeOverlays;
    private LabelComponent tooltipTitle;
    private FlowLayout tooltipContainer;
    private ReactorBlockRenderComponent selectedBlockOverlay;
    private TextureComponent energyIndicator;
    private LabelComponent productionLabel;
    private LabelComponent hottestLabel;
    private LabelComponent sumHeatLabel;
    private LabelComponent statusLabel;

    public ReactorScreen(ReactorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.tooltipContainer = Containers.verticalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
        this.tooltipContainer.surface(Surface.VANILLA_TRANSLUCENT);
        this.tooltipTitle = Components.label((class_2561)class_2561.method_43470((String)"My title!"));
        this.tooltipContainer.child((Component)this.tooltipTitle.margins(Insets.of((int)6)));
        this.tooltipContainer.zIndex(3000);
        this.tooltipContainer.padding(Insets.of((int)3));
        this.tooltipTitle.zIndex(3001);
        FlowLayout overlay = Containers.horizontalFlow((Sizing)Sizing.fixed((int)340), (Sizing)Sizing.fixed((int)200));
        rootComponent.child((Component)overlay.surface(BasicMachineScreen.ORITECH_PANEL));
        this.addReactorComponentPreview(overlay);
        this.addReactorStats(overlay);
        this.addEnergyBar(overlay);
        this.addReactorStatus(overlay);
        this.addTitle(overlay);
        rootComponent.child((Component)this.tooltipContainer.positioning(Positioning.absolute((int)0, (int)0)));
    }

    private void addReactorStats(FlowLayout overlay) {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fixed((int)141), (Sizing)Sizing.content((int)0));
        this.productionLabel = Components.label((class_2561)class_2561.method_43469((String)"RF Production: %s RF/t", (Object[])new Object[]{"50"}).method_27692(class_124.field_1068));
        this.sumHeatLabel = Components.label((class_2561)class_2561.method_43469((String)"Heat Production: %s RF/t", (Object[])new Object[]{"50"}).method_27692(class_124.field_1068));
        this.hottestLabel = Components.label((class_2561)class_2561.method_43469((String)"Hottest Part: %s RF/t", (Object[])new Object[]{"50"}).method_27692(class_124.field_1068));
        container.child((Component)this.productionLabel.margins(Insets.of((int)4)));
        container.child((Component)this.hottestLabel.margins(Insets.of((int)4)));
        container.child((Component)this.sumHeatLabel.margins(Insets.of((int)4)));
        overlay.child(container.margins(Insets.of((int)8)).surface(Surface.PANEL_INSET).positioning(Positioning.absolute((int)183, (int)16)));
    }

    private void addReactorStatus(FlowLayout overlay) {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fixed((int)95), (Sizing)Sizing.content((int)1));
        this.statusLabel = Components.label((class_2561)class_2561.method_43471((String)"Stable").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}));
        container.child(this.statusLabel.horizontalTextAlignment(HorizontalAlignment.CENTER).horizontalSizing(Sizing.fill()).margins(Insets.of((int)4)));
        overlay.child(container.margins(Insets.of((int)4)).surface(Surface.PANEL_INSET).positioning(Positioning.absolute((int)187, (int)75)));
    }

    private class_2338 getPreviewMax() {
        return ((ReactorScreenHandler)this.field_2797).reactorEntity.areaMax.method_33096(((ReactorScreenHandler)this.field_2797).reactorEntity.areaMin.method_10264() + 1);
    }

    private void addReactorComponentPreview(FlowLayout overlay) {
        ReactorPreviewContainer holoPreviewContainer = new ReactorPreviewContainer(Sizing.fixed((int)180), Sizing.fixed((int)164), FlowLayout.Algorithm.HORIZONTAL, this::onContainerMouseMove);
        holoPreviewContainer.surface(Surface.PANEL_INSET);
        holoPreviewContainer.margins(Insets.of((int)8));
        class_2338 totalSize = this.getPreviewMax().method_10059((class_2382)((ReactorScreenHandler)this.field_2797).reactorEntity.areaMin);
        int leftCount = totalSize.method_10260();
        int rightCount = totalSize.method_10263();
        int totalWidth = leftCount + rightCount + 3;
        float middlePercentage = (float)leftCount / (float)totalWidth;
        float xOffset = middlePercentage * 170.0f + 10.0f;
        int size = (int)(170.0f / (float)totalWidth * 2.2f);
        this.activeComponents = new ArrayList();
        this.activeOverlays = new HashSet();
        class_2338.method_20437((class_2338)((ReactorScreenHandler)this.field_2797).reactorEntity.areaMin, (class_2338)this.getPreviewMax()).forEach(pos -> {
            class_2680 state = ((ReactorScreenHandler)this.field_2797).world.method_8320(pos);
            if (state.method_26215()) {
                return;
            }
            class_2338 offset = pos.method_10059((class_2382)((ReactorScreenHandler)this.field_2797).reactorEntity.areaMin);
            float projectedPosX = (float)offset.method_10263() * 0.43f - (float)offset.method_10260() * 0.43f;
            float projectedPosY = (float)offset.method_10263() * 0.224f + (float)offset.method_10260() * 0.224f + (float)offset.method_10264() * 0.5f;
            int zIndex = offset.method_10264() - offset.method_10263() - offset.method_10260();
            Component preview = new ReactorBlockRenderComponent(null, ((ReactorScreenHandler)this.field_2797).world.method_8321(pos), zIndex, pos.method_10062()).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)((int)(projectedPosX * (float)size + xOffset)), (int)((int)(-projectedPosY * (float)size) + 100)));
            if (offset.method_10264() == 1) {
                this.activeComponents.add((class_3545<Integer, ReactorBlockRenderComponent>)new class_3545((Object)(-zIndex), (Object)((ReactorBlockRenderComponent)preview)));
            }
            holoPreviewContainer.child(preview);
            if (state.method_26204() instanceof ReactorRodBlock || state.method_26204() instanceof ReactorHeatPipeBlock) {
                Component heatOverlay = new ReactorBlockRenderComponent(class_2246.field_10124.method_9564(), null, (float)zIndex + 0.5f, pos.method_10062()).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)((int)(projectedPosX * (float)size + xOffset)), (int)((int)(-projectedPosY * (float)size) + 100)));
                holoPreviewContainer.child(heatOverlay);
                this.activeOverlays.add((ReactorBlockRenderComponent)heatOverlay);
            }
        });
        this.selectedBlockOverlay = (ReactorBlockRenderComponent)new ReactorBlockRenderComponent(class_2246.field_10124.method_9564(), null, 10.5f, class_2338.field_10980).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)0, (int)0));
        holoPreviewContainer.child((Component)this.selectedBlockOverlay);
        this.activeComponents.sort(Comparator.comparingInt(class_3545::method_15442));
        overlay.child((Component)holoPreviewContainer.positioning(Positioning.absolute((int)0, (int)16)));
    }

    protected void method_37432() {
        super.method_37432();
        if (((ReactorScreenHandler)this.field_2797).reactorEntity.componentStats.isEmpty()) {
            return;
        }
        for (ReactorBlockRenderComponent overlay : this.activeOverlays) {
            boolean isEmpty;
            ReactorControllerBlockEntity.ComponentStatistics data2 = this.getStatsAtPosition(overlay.pos);
            boolean bl = isEmpty = data2.storedHeat() <= 10;
            if (isEmpty) {
                overlay.state = class_2246.field_10124.method_9564();
                continue;
            }
            class_2680 res = BlockContent.REACTOR_COLD_INDICATOR_BLOCK.method_9564();
            if (data2.storedHeat() > 1000) {
                res = BlockContent.REACTOR_HOT_INDICATOR_BLOCK.method_9564();
            } else if (data2.storedHeat() > 200) {
                res = BlockContent.REACTOR_MEDIUM_INDICATOR_BLOCK.method_9564();
            }
            overlay.state = res;
        }
        int stackHeight = ((ReactorScreenHandler)this.field_2797).reactorEntity.areaMax.method_10264() - ((ReactorScreenHandler)this.field_2797).reactorEntity.areaMin.method_10264() - 1;
        int sumProducedEnergy = ((ReactorScreenHandler)this.field_2797).reactorEntity.componentStats.values().stream().mapToInt(data -> data.receivedPulses() * ReactorControllerBlockEntity.RF_PER_PULSE * stackHeight).sum();
        int sumProducedHeat = ((ReactorScreenHandler)this.field_2797).reactorEntity.componentStats.values().stream().filter(elem -> elem.receivedPulses() > 0).mapToInt(ReactorControllerBlockEntity.ComponentStatistics::heatChanged).sum();
        int hottestComponent = ((ReactorScreenHandler)this.field_2797).reactorEntity.componentStats.values().stream().mapToInt(ReactorControllerBlockEntity.ComponentStatistics::storedHeat).max().orElse(0);
        this.productionLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.reactor.rf_production", (Object[])new Object[]{TooltipHelper.getEnergyText(sumProducedEnergy)}));
        this.hottestLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.reactor.hottest_part", (Object[])new Object[]{hottestComponent}));
        this.sumHeatLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.reactor.heat_production", (Object[])new Object[]{sumProducedHeat}));
        boolean isActive = sumProducedEnergy + sumProducedHeat > 0;
        String activeLabel = "idle";
        class_124 color = class_124.field_1068;
        if (isActive) {
            if (hottestComponent < 100) {
                activeLabel = "stable";
            } else if (hottestComponent < 1200) {
                activeLabel = "heating_up";
                color = class_124.field_1054;
            } else if (hottestComponent < 1700) {
                activeLabel = "unstable";
                color = class_124.field_1061;
            } else {
                activeLabel = "explosion_imminent";
                color = class_124.field_1079;
            }
        }
        this.statusLabel.text((class_2561)class_2561.method_43471((String)("text.oritech.reactor." + activeLabel)).method_27692(class_124.field_1067).method_27692(color));
        this.updateEnergyBar();
    }

    private void onContainerMouseMove(int mouseX, int mouseY) {
        int posX = mouseX;
        int posY = mouseY;
        for (class_3545<Integer, ReactorBlockRenderComponent> component : this.activeComponents) {
            boolean hit = ((ReactorBlockRenderComponent)((Object)component.method_15441())).isInBoundingBox(mouseX, mouseY);
            if (!hit) continue;
            class_2338 pos = ((ReactorBlockRenderComponent)((Object)component.method_15441())).pos;
            this.addStatsToTooltip(pos, ((ReactorScreenHandler)this.field_2797).world.method_8320(pos), this.tooltipContainer);
            posX = ((ReactorBlockRenderComponent)((Object)component.method_15441())).x();
            posY = ((ReactorBlockRenderComponent)((Object)component.method_15441())).y();
            this.selectedBlockOverlay.state = BlockContent.ADDON_INDICATOR_BLOCK.method_9564();
            this.selectedBlockOverlay.pos = pos;
            this.selectedBlockOverlay.zIndex = ((ReactorBlockRenderComponent)((Object)component.method_15441())).zIndex + 0.6f;
            this.selectedBlockOverlay.positioning((Positioning)((ReactorBlockRenderComponent)((Object)component.method_15441())).positioning().get());
            break;
        }
        if (posX == mouseX) {
            this.tooltipContainer.positioning(Positioning.absolute((int)-100, (int)-500));
            this.selectedBlockOverlay.state = class_2246.field_10124.method_9564();
            return;
        }
        int containerHeight = this.tooltipContainer.height();
        this.tooltipContainer.positioning(Positioning.absolute((int)(posX - 30), (int)(posY - 5 - containerHeight)));
    }

    public void addStatsToTooltip(class_2338 pos, class_2680 state, FlowLayout container) {
        container.clearChildren();
        class_5250 blockname = state.method_26204().method_9518();
        container.child((Component)Components.label((class_2561)blockname.method_27695(new class_124[]{class_124.field_1068, class_124.field_1067})).margins(Insets.of((int)0, (int)3, (int)0, (int)0)));
        ReactorControllerBlockEntity.ComponentStatistics stats = this.getStatsAtPosition(pos);
        if (stats.storedHeat() == -1) {
            return;
        }
        int stackHeight = ((ReactorScreenHandler)this.field_2797).reactorEntity.areaMax.method_10264() - ((ReactorScreenHandler)this.field_2797).reactorEntity.areaMin.method_10264() - 1;
        class_2338 portPosition = pos.method_10069(0, stackHeight, 0);
        class_2586 portEntity = ((ReactorScreenHandler)this.field_2797).world.method_8321(portPosition);
        if (portEntity != null && portEntity.method_11015()) {
            return;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ReactorRodBlock) {
            ReactorRodBlock rodBlock = (ReactorRodBlock)class_22482;
            int rodCount = rodBlock.getRodCount();
            short totalPulses = stats.receivedPulses();
            int createdPulses = rodBlock.getInternalPulseCount();
            int externalPulses = totalPulses - createdPulses;
            int generatedEnergy = ReactorControllerBlockEntity.RF_PER_PULSE * totalPulses;
            short generatedHeat = stats.heatChanged();
            int heat = stats.storedHeat();
            if (totalPulses == 0) {
                createdPulses = 0;
                externalPulses = 0;
            }
            if (!(portEntity instanceof ReactorFuelPortEntity)) {
                return;
            }
            ReactorFuelPortEntity fuelPortEntity = (ReactorFuelPortEntity)portEntity;
            int availableFuel = fuelPortEntity.availableFuel;
            int maxFuel = fuelPortEntity.currentFuelOriginalCapacity;
            container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.rod_count", (Object[])new Object[]{rodCount}).method_27692(class_124.field_1068)));
            container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.generated_pulses", (Object[])new Object[]{createdPulses}).method_27692(class_124.field_1068)));
            container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.received_pulses", (Object[])new Object[]{externalPulses}).method_27692(class_124.field_1068)));
            container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.generated_heat", (Object[])new Object[]{generatedHeat}).method_27692(class_124.field_1068)));
            container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.generated_energy", (Object[])new Object[]{generatedEnergy}).method_27692(class_124.field_1068)));
            container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.heat", (Object[])new Object[]{heat}).method_27692(class_124.field_1068)));
            container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.fuel", (Object[])new Object[]{availableFuel, maxFuel}).method_27692(class_124.field_1068)));
        } else {
            class_2248 rodCount = state.method_26204();
            if (rodCount instanceof ReactorHeatPipeBlock) {
                ReactorHeatPipeBlock pipeBlock = (ReactorHeatPipeBlock)rodCount;
                container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.collected_heat", (Object[])new Object[]{stats.heatChanged()}).method_27692(class_124.field_1068)));
                container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.heat", (Object[])new Object[]{stats.storedHeat()}).method_27692(class_124.field_1068)));
            } else {
                rodCount = state.method_26204();
                if (rodCount instanceof ReactorHeatVentBlock) {
                    ReactorHeatVentBlock pipeBlock = (ReactorHeatVentBlock)rodCount;
                    container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.removed_heat", (Object[])new Object[]{stats.heatChanged()}).method_27692(class_124.field_1068)));
                } else {
                    rodCount = state.method_26204();
                    if (rodCount instanceof ReactorAbsorberBlock) {
                        ReactorAbsorberBlock absorberBlock = (ReactorAbsorberBlock)rodCount;
                        if (!(portEntity instanceof ReactorAbsorberPortEntity)) {
                            return;
                        }
                        ReactorAbsorberPortEntity absorberPortEntity = (ReactorAbsorberPortEntity)portEntity;
                        int availableFuel = absorberPortEntity.availableFuel;
                        int maxFuel = absorberPortEntity.currentFuelOriginalCapacity;
                        container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.absorbed_heat", (Object[])new Object[]{stats.heatChanged()}).method_27692(class_124.field_1068)));
                        container.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.reactor.absorbant", (Object[])new Object[]{availableFuel, maxFuel}).method_27692(class_124.field_1068)));
                    }
                }
            }
        }
    }

    public ReactorControllerBlockEntity.ComponentStatistics getStatsAtPosition(class_2338 pos) {
        if (((ReactorScreenHandler)this.field_2797).reactorEntity.componentStats.isEmpty()) {
            return ReactorControllerBlockEntity.ComponentStatistics.EMPTY;
        }
        class_2338 reactorMin = ((ReactorScreenHandler)this.field_2797).reactorEntity.areaMin;
        for (Map.Entry<Vector2i, ReactorControllerBlockEntity.ComponentStatistics> entry : ((ReactorScreenHandler)this.field_2797).reactorEntity.componentStats.entrySet()) {
            Vector2i localPos = entry.getKey();
            class_2338 worldPos = reactorMin.method_10069(localPos.x + 1, 1, localPos.y + 1);
            if (!worldPos.equals((Object)pos)) continue;
            return entry.getValue();
        }
        return ReactorControllerBlockEntity.ComponentStatistics.EMPTY;
    }

    private void addTitle(FlowLayout overlay) {
        class_5250 blockTitle = ((ReactorScreenHandler)this.field_2797).reactorEntity.method_11010().method_26204().method_9518();
        LabelComponent label = Components.label((class_2561)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child((Component)label.positioning(Positioning.relative((int)50, (int)3)));
    }

    private void addEnergyBar(FlowLayout panel) {
        ScreenProvider.BarConfiguration config = new ScreenProvider.BarConfiguration(295, 80, 36, 108);
        int insetSize = 1;
        class_5250 tooltipText = class_2561.method_43469((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{10, 50});
        FlowLayout frame = Containers.horizontalFlow((Sizing)Sizing.fixed((int)(config.width() + insetSize * 2)), (Sizing)Sizing.fixed((int)(config.height() + insetSize * 2)));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of((int)insetSize));
        frame.positioning(Positioning.absolute((int)(config.x() - insetSize), (int)(config.y() - insetSize)));
        panel.child((Component)frame);
        TextureComponent indicator_background = Components.texture((class_2960)BasicMachineScreen.GUI_COMPONENTS, (int)24, (int)0, (int)24, (int)96, (int)98, (int)96);
        indicator_background.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator = Components.texture((class_2960)BasicMachineScreen.GUI_COMPONENTS, (int)0, (int)0, (int)24, (int)96, (int)98, (int)96);
        this.energyIndicator.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator.positioning(Positioning.absolute((int)0, (int)0));
        this.energyIndicator.tooltip((class_2561)tooltipText);
        frame.child((Component)indicator_background).child((Component)this.energyIndicator);
    }

    protected void updateEnergyBar() {
        long capacity = ((ReactorScreenHandler)this.field_2797).reactorEntity.energyStorage.getCapacity();
        long amount = ((ReactorScreenHandler)this.field_2797).reactorEntity.energyStorage.getAmount();
        float fillAmount = (float)amount / (float)capacity;
        class_2561 tooltipText = BasicMachineScreen.getEnergyTooltip(amount, capacity, 0L, 0L);
        this.energyIndicator.tooltip(tooltipText);
        this.energyIndicator.visibleArea(PositionedRectangle.of((int)0, (int)(96 - (int)(96.0f * fillAmount)), (int)24, (int)((int)(96.0f * fillAmount))));
    }
}

