/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.cablesurfer;

import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5498;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.cablesurfer.CableMath;
import rearth.oritech.client.cablesurfer.ZiplineSoundInstance;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.ServerZiplineHandler;

public class ClientZiplineHandler {
    private static boolean active = false;
    private static class_243 startPos;
    private static class_243 endPos;
    private static class_243 parallelStart;
    private static class_243 parallelEnd;
    private static float progress;
    private static float currentSpeed;
    private static double totalDistance;
    private static final float DRAG = 0.97f;
    private static final float HANG_OFFSET = 1.65f;
    private static final float GRAVITY_FORCE = 0.1f;
    private static class_5498 previousCamera;

    public static boolean isActive() {
        return active;
    }

    public static float getCurrentSpeed() {
        return Math.abs(currentSpeed);
    }

    public static class_243 getStartPos() {
        return startPos;
    }

    public static class_243 getEndPos() {
        return endPos;
    }

    public static class_243 getParallelStart() {
        return parallelStart;
    }

    public static class_243 getParallelEnd() {
        return parallelEnd;
    }

    public static void start(class_243 start, class_243 end, class_243 parStart, class_243 parEnd, float initialSpeed) {
        if (active) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        active = true;
        startPos = start;
        endPos = end;
        totalDistance = start.method_1022(end);
        parallelStart = parStart;
        parallelEnd = parEnd;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15082, (float)0.8f, (float)0.5f));
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_24063, (float)1.0f, (float)0.2f));
        class_310.method_1551().method_1483().method_4873((class_1113)new ZiplineSoundInstance((class_1657)player));
        class_243 searchPos = player.method_19538().method_1031(0.0, (double)1.65f, 0.0);
        progress = ClientZiplineHandler.calculateClosestProgress(start, end, searchPos);
        class_243 cableDir = endPos.method_1020(startPos).method_1029();
        class_243 lookDir = player.method_5720();
        currentSpeed = initialSpeed;
        if (cableDir.method_1026(lookDir) < 0.0) {
            currentSpeed = -initialSpeed;
        }
        if (currentSpeed == 0.0f) {
            currentSpeed = 0.15f;
        }
        if ((previousCamera = class_310.method_1551().field_1690.method_31044()) == class_5498.field_26664 && Oritech.CONFIG.ziplineCameraSwitch()) {
            class_310.method_1551().field_1690.method_31043(class_5498.field_26665);
        }
        class_243 ropePos = CableMath.getAt(startPos, endPos, progress);
        class_243 initialPos = ropePos.method_1031(0.0, (double)-1.65f, 0.0);
        player.method_5814(initialPos.field_1352, initialPos.field_1351, initialPos.field_1350);
        player.method_18799(player.method_5720().method_1021((double)currentSpeed));
    }

    private static float calculateClosestProgress(class_243 start, class_243 end, class_243 targetPos) {
        double bestDistSq = Double.MAX_VALUE;
        float bestT = 0.0f;
        int steps = (int)start.method_1022(end) + 1;
        for (int i = 0; i <= steps; ++i) {
            float t = (float)i / (float)steps;
            class_243 pointOnWire = CableMath.getAt(start, end, t);
            double distSq = pointOnWire.method_1025(targetPos);
            if (!(distSq < bestDistSq)) continue;
            bestDistSq = distSq;
            bestT = t;
        }
        return bestT;
    }

    public static void onClientTick() {
        class_243 lookDir;
        if (!active) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !player.method_5805() || !player.method_6047().method_31574(ItemContent.WRENCH)) {
            ClientZiplineHandler.dismount(false);
            return;
        }
        NetworkManager.sendToServer(new ServerZiplineHandler.ZiplinePlayerUsePacket());
        if (player.field_3913.field_3903) {
            ClientZiplineHandler.dismount(false);
            return;
        }
        if (player.field_3913.field_3904) {
            ClientZiplineHandler.dismount(true);
            return;
        }
        int directionMultiplier = 1;
        class_243 cableDir = endPos.method_1020(startPos).method_1029();
        if (cableDir.method_1026(lookDir = player.method_5720()) < 0.0) {
            directionMultiplier = -1;
        }
        float maxSpeed = Oritech.CONFIG.maxZiplineSpeed();
        float acceleration = Oritech.CONFIG.ziplineAcceleration();
        if (player.field_3913.field_3910) {
            currentSpeed += acceleration * (float)directionMultiplier;
        } else if (player.field_3913.field_3909) {
            currentSpeed -= acceleration * (float)directionMultiplier;
        }
        float t = progress;
        float tNext = class_3532.method_15363((float)(t + 0.01f), (float)0.0f, (float)1.01f);
        class_243 p1 = CableMath.getAt(startPos, endPos, t);
        class_243 p2 = CableMath.getAt(startPos, endPos, tNext);
        class_243 tangent = p2.method_1020(p1).method_1029();
        double slopeY = tangent.field_1351;
        currentSpeed -= (float)(slopeY * (double)0.1f);
        currentSpeed *= 0.97f;
        currentSpeed = class_3532.method_15363((float)currentSpeed, (float)(-maxSpeed), (float)maxSpeed);
        float progressDelta = (float)((double)currentSpeed / totalDistance);
        progress += progressDelta;
        if (progress >= 1.0f) {
            progress = 1.0f;
            ClientZiplineHandler.dismount(true);
            return;
        }
        if (progress <= 0.0f) {
            progress = 0.0f;
            currentSpeed = 0.0f;
            ClientZiplineHandler.dismount(true);
        }
        class_243 ropePos = CableMath.getAt(startPos, endPos, progress);
        class_243 nextPlayerPos = ropePos.method_1031(0.0, (double)-1.65f, 0.0);
        if ((double)Math.abs(currentSpeed) > 0.6 && Oritech.CONFIG.ziplineAutoJump()) {
            double dynamicEjectDist;
            double blocksRemaining = (double)(1.0f - progress) * totalDistance;
            if (directionMultiplier < 0) {
                blocksRemaining = (double)progress * totalDistance;
            }
            if (blocksRemaining < (dynamicEjectDist = 1.5 + (double)(Math.abs(currentSpeed) * 3.0f))) {
                ClientZiplineHandler.dismount(false);
                class_243 currentVel = player.method_18798();
                player.method_5814(nextPlayerPos.field_1352, nextPlayerPos.field_1351 + 1.0, nextPlayerPos.field_1350);
                player.method_18800(currentVel.field_1352 * 1.2, (currentVel.field_1351 > 0.0 ? currentVel.field_1351 * 1.2 : 0.0) + 0.7, currentVel.field_1350 * 1.2);
                ClientZiplineHandler.playWooshSound((class_1657)player);
                return;
            }
        }
        class_243 oldPos = player.method_19538();
        class_243 velocity = nextPlayerPos.method_1020(oldPos);
        class_238 bounds = player.method_18377(class_4050.field_18076).method_30757(nextPlayerPos);
        bounds = bounds.method_1011(0.1);
        if (!player.method_37908().method_8587((class_1297)player, bounds)) {
            ClientZiplineHandler.dismount(false);
            return;
        }
        player.method_5814(nextPlayerPos.field_1352, nextPlayerPos.field_1351, nextPlayerPos.field_1350);
        player.method_18799(velocity);
        player.field_6017 = 0.0f;
        class_5819 random = player.method_37908().field_9229;
        if (random.method_43057() < Math.abs(currentSpeed) / 2.0f) {
            if ((double)random.method_43057() > 0.8) {
                player.method_37908().method_8486(ropePos.field_1352, ropePos.field_1351, ropePos.field_1350, class_3417.field_24062, player.method_5634(), 0.3f, 2.0f, false);
            }
            class_243 particleVel = player.method_18798().method_18805(2.0, 2.0, 2.0);
            player.method_37908().method_8406((class_2394)class_2398.field_29644, ropePos.field_1352, ropePos.field_1351 + 0.3, ropePos.field_1350, particleVel.field_1352 + (double)random.method_43057() * 0.3, particleVel.field_1351 + (double)random.method_43057() * 0.3, particleVel.field_1350 + (double)random.method_43057() * 0.3);
        }
    }

    private static void dismount(boolean jump) {
        class_746 player;
        active = false;
        if (previousCamera != null && Oritech.CONFIG.ziplineCameraSwitch()) {
            class_310.method_1551().field_1690.method_31043(previousCamera);
        }
        if ((player = class_310.method_1551().field_1724) != null) {
            if (jump) {
                class_243 currentVel = player.method_18798();
                class_243 playerPos = player.method_30950(0.0f);
                player.method_5814(playerPos.field_1352, playerPos.field_1351 + 1.0, playerPos.field_1350);
                player.method_18800(currentVel.field_1352 * 1.5, currentVel.method_10214() * (double)1.2f + 0.6, currentVel.field_1350 * 1.5);
                ClientZiplineHandler.playWooshSound((class_1657)player);
            } else {
                player.method_5783(class_3417.field_15131, 0.5f, 1.5f);
            }
            class_243 gustPos = player.method_30950(0.0f);
            class_5819 random = player.method_37908().field_9229;
            class_243 gustVel = player.method_18798();
            player.method_37908().method_8406((class_2394)class_2398.field_47494, gustPos.field_1352, gustPos.field_1351 + 0.3, gustPos.field_1350, gustVel.field_1352 + (double)random.method_43057() * 0.3, gustVel.field_1351 + (double)random.method_43057() * 0.3, gustVel.field_1350 + (double)random.method_43057() * 0.3);
        }
    }

    private static void playWooshSound(class_1657 player) {
        player.method_5783(class_3417.field_14610, 2.0f, 2.0f);
    }
}

