/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import com.google.common.collect.Streams;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.blocks.pipes.ExtractablePipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockEntitiesContent;

public class FluidPipeInterfaceEntity
extends ExtractablePipeInterfaceEntity {
    public static final int MAX_TRANSFER_RATE = (int)((float)FluidStackHooks.bucketAmount() * Oritech.CONFIG.fluidPipeExtractAmountBuckets());
    private static final int TRANSFER_PERIOD = Oritech.CONFIG.fluidPipeExtractIntervalDuration();
    private List<FluidApi.FluidStorage> filteredFluidTargetsCached;

    public FluidPipeInterfaceEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.FLUID_PIPE_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, GenericPipeInterfaceEntity blockEntity) {
        long moved;
        ExtractablePipeConnectionBlock block = (ExtractablePipeConnectionBlock)state.method_26204();
        if (world.field_9236 || !block.isExtractable(state)) {
            return;
        }
        boolean boosted = this.isBoostAvailable();
        if (world.method_8510() % (long)TRANSFER_PERIOD != 0L && !boosted) {
            return;
        }
        GenericPipeInterfaceEntity.PipeNetworkData data = FluidPipeBlock.FLUID_PIPE_DATA.getOrDefault(world.method_27983().method_29177(), new GenericPipeInterfaceEntity.PipeNetworkData());
        int transferAmount = boosted ? MAX_TRANSFER_RATE * 100 : MAX_TRANSFER_RATE;
        FluidStack stackToMove = FluidStack.empty();
        FluidApi.FluidStorage takenFrom = null;
        Set sources = data.machineInterfaces.getOrDefault(pos, new HashSet());
        for (class_2338 sourcePos : sources) {
            List<FluidStack> contents;
            Optional<FluidStack> extractionCandidate;
            FluidApi.FluidStorage sourceContainer;
            class_2338 offset = pos.method_10059((class_2382)sourcePos);
            class_2350 direction = class_2350.method_50026((int)offset.method_10263(), (int)offset.method_10264(), (int)offset.method_10260());
            if (!block.isSideExtractable(state, direction.method_10153())) continue;
            class_2680 sourceBlock = world.method_8320(sourcePos);
            if (sourceBlock.method_26164(class_3481.field_26985)) {
                transferAmount = (int)FluidStackHooks.bucketAmount();
            }
            if ((sourceContainer = FluidApi.BLOCK.find(world, sourcePos, sourceBlock, null, direction)) == null || !sourceContainer.supportsExtraction() || !(extractionCandidate = Streams.stream(contents = sourceContainer.getContent()).filter(candidate -> !candidate.isEmpty()).filter(candidate -> sourceContainer.extract((FluidStack)candidate, true) > 0L).findFirst()).isPresent()) continue;
            FluidStack extractionTest = extractionCandidate.get().copyWithAmount((long)transferAmount);
            long movedAmount = sourceContainer.extract(extractionTest, true);
            stackToMove = extractionTest;
            stackToMove.setAmount(movedAmount);
            takenFrom = sourceContainer;
            break;
        }
        if (stackToMove.isEmpty() || takenFrom == null) {
            return;
        }
        Set<class_3545<class_2338, class_2350>> targets = FluidPipeInterfaceEntity.findNetworkTargets(pos, data);
        if (targets == null) {
            System.err.println("Yeah your pipe network likely is too long. At: " + String.valueOf(this.method_11016()));
            return;
        }
        int netHash = targets.hashCode();
        if (netHash != this.filteredTargetsNetHash || this.filteredFluidTargetsCached == null) {
            this.filteredFluidTargetsCached = targets.stream().filter(target -> {
                class_2350 direction = (class_2350)target.method_15441();
                class_2338 pipePos = ((class_2338)target.method_15442()).method_10081(direction.method_10163());
                class_2680 pipeState = world.method_8320(pipePos);
                class_2248 patt0$temp = pipeState.method_26204();
                if (!(patt0$temp instanceof FluidPipeConnectionBlock)) {
                    return true;
                }
                FluidPipeConnectionBlock fluidBlock = (FluidPipeConnectionBlock)patt0$temp;
                boolean extracting = fluidBlock.isSideExtractable(pipeState, ((class_2350)target.method_15441()).method_10153());
                return !extracting;
            }).map(target -> FluidApi.BLOCK.find(world, (class_2338)target.method_15442(), (class_2350)target.method_15441())).filter(obj -> Objects.nonNull(obj) && obj.supportsInsertion()).collect(Collectors.toList());
            this.filteredTargetsNetHash = netHash;
        }
        Collections.shuffle(this.filteredFluidTargetsCached);
        long availableFluid = stackToMove.getAmount();
        for (FluidApi.FluidStorage targetStorage : this.filteredFluidTargetsCached) {
            long maxInsert = targetStorage.insert(stackToMove, true);
            long taken = takenFrom.extract(stackToMove.copyWithAmount(maxInsert), false);
            long inserted = targetStorage.insert(stackToMove.copyWithAmount(taken), false);
            stackToMove.shrink(inserted);
            targetStorage.update();
            if (stackToMove.getAmount() > 0L) continue;
            break;
        }
        if ((moved = availableFluid - stackToMove.getAmount()) > 0L) {
            stackToMove.setAmount(moved);
            this.onBoostUsed();
            takenFrom.update();
        }
    }
}

