/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShrinkerBlockEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
ExtendedMenuProvider,
ScreenProvider,
MultiblockMachineController,
MachineAddonController,
ColorableMachine {
    public static final RawAnimation SHRINK = RawAnimation.begin().thenPlay("work");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    private final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, this::method_5431);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(1, this::method_5431);
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = this.getDefaultColor();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> connectedAddons = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> openSlots = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_OPEN})
    public ShrunkAddonData currentCandidate = new ShrunkAddonData(MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA, false, 0, 0, false, false);
    private boolean wasRedstoneActive = false;

    public ShrinkerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.SHRINKER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        boolean currentRedstone = world.method_49803(pos);
        if (currentRedstone && !this.wasRedstoneActive) {
            System.out.println("triggered redstone shrink");
            this.doShrink();
        }
        this.wasRedstoneActive = currentRedstone;
    }

    public void doShrink() {
        if (this.energyStorage.getAmount() < this.getDefaultCapacity()) {
            return;
        }
        this.initAddons();
        if (this.currentCandidate == null || this.connectedAddons.isEmpty() || !this.inventory.method_5442()) {
            return;
        }
        this.energyStorage.setAmount(this.energyStorage.getAmount() - this.getDefaultCapacity());
        this.energyStorage.update();
        class_1799 createdStack = new class_1799((class_1935)BlockContent.MACHINE_COMBI_ADDON.method_8389());
        createdStack.method_57379((class_9331)ComponentContent.ADDON_DATA.get(), (Object)this.currentCandidate);
        this.inventory.setStackInSlot(0, createdStack);
        for (class_2338 addonPos : this.connectedAddons.reversed()) {
            this.field_11863.method_8652(addonPos, class_2246.field_10124.method_9564(), 2);
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 spawnAt = addonPos.method_46558();
            serverWorld.method_14199((class_2394)class_2398.field_47494, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, 1, 0.0, (double)0.1f, 0.0, 0.5);
            serverWorld.method_8396(null, this.field_11867, class_3417.field_26971, class_3419.field_15245, 2.0f, 0.5f);
        }
        this.triggerAnim("machine", "work");
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        MachineAddonController.super.gatherAddonStats(addons);
        if (addons.isEmpty()) {
            this.currentCandidate = new ShrunkAddonData(MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA, false, 0, 0, false, false);
            return;
        }
        MachineAddonController.BaseAddonData data = this.getBaseAddonData();
        boolean fluid = false;
        int quarryCount = 0;
        int yieldCount = 0;
        boolean cropFilter = false;
        boolean silk = false;
        for (MachineAddonController.AddonBlock addon : addons) {
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.MACHINE_FLUID_ADDON)) {
                fluid = true;
            }
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.QUARRY_ADDON)) {
                ++quarryCount;
            }
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.MACHINE_YIELD_ADDON)) {
                ++yieldCount;
            }
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.CROP_FILTER_ADDON)) {
                cropFilter = true;
            }
            if (!((Object)((Object)addon.addonBlock())).equals(BlockContent.MACHINE_SILK_TOUCH_ADDON)) continue;
            silk = true;
        }
        this.currentCandidate = new ShrunkAddonData(data, fluid, quarryCount, yieldCount, cropFilter, silk);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        this.addColorToNbt(nbt);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
        nbt.method_10556("redstone", this.wasRedstoneActive);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        this.loadColorFromNbt(nbt);
        this.energyStorage.amount = nbt.method_10537("energy_stored");
        this.wasRedstoneActive = nbt.method_10577("redstone");
        this.updateEnergyContainer();
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 0, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.method_11010())) {
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).triggerableAnim("work", SHRINK).triggerableAnim("deploy", MachineBlockEntity.SETUP).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private boolean isActive(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED);
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(i, inventory, this);
    }

    @Override
    public List<class_2338> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<class_2338> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public class_2338 getPosForAddon() {
        return this.method_11016();
    }

    @Override
    public class_1937 getWorldForAddon() {
        return this.method_10997();
    }

    @Override
    public class_2350 getFacingForAddon() {
        return (class_2350)Objects.requireNonNull(this.field_11863).method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12481);
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(1, 0, 0));
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.addonConfig.addonShrinkerRF();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.addonConfig.addonShrinkerRF() / 60L;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(1, 0, -1), new class_2382(0, 0, -1), new class_2382(1, 0, 1), new class_2382(0, 0, 1));
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        return (class_2350)Objects.requireNonNull(this.field_11863).method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12481);
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.method_11016();
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.method_10997();
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("machine", "deploy");
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 40, 40, true));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.getDefaultCapacity();
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.SHRINKER_SCREEN;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    public static void onPlayerUse(ShrinkerPlayerUsePacket packet, class_1657 player, class_5455 registryAccess) {
        class_1937 world = player.method_37908();
        Optional candidate = world.method_35230(packet.pos(), BlockEntitiesContent.SHRINKER_BLOCK_ENTITY);
        candidate.ifPresent(ShrinkerBlockEntity::doShrink);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    public record ShrunkAddonData(MachineAddonController.BaseAddonData data, boolean fluid, int quarryCount, int yieldCount, boolean cropFilter, boolean silk) {
        public static final Codec<ShrunkAddonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MachineAddonController.BaseAddonData.CODEC.fieldOf("data").forGetter(ShrunkAddonData::data), (App)Codec.BOOL.fieldOf("fluid").forGetter(ShrunkAddonData::fluid), (App)Codec.INT.fieldOf("quarry_count").forGetter(ShrunkAddonData::quarryCount), (App)Codec.INT.fieldOf("yield_count").forGetter(ShrunkAddonData::yieldCount), (App)Codec.BOOL.fieldOf("crop_filter").forGetter(ShrunkAddonData::cropFilter), (App)Codec.BOOL.fieldOf("silk").forGetter(ShrunkAddonData::silk)).apply((Applicative)instance, ShrunkAddonData::new));
        public static final class_9139<class_9129, ShrunkAddonData> STREAM_CODEC = NetworkManager.getAutoCodec(ShrunkAddonData.class);

        @Override
        @NotNull
        public String toString() {
            return "ShrunkAddonData{data=" + String.valueOf(this.data) + ", fluid=" + this.fluid + ", quarryCount=" + this.quarryCount + ", yieldCount=" + this.yieldCount + ", cropFilter=" + this.cropFilter + "}";
        }
    }

    public record ShrinkerPlayerUsePacket(class_2338 pos) implements class_8710
    {
        public static final class_8710.class_9154<ShrinkerPlayerUsePacket> PACKET_ID = new class_8710.class_9154(Oritech.id("shrink"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

