/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.decorative;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import rearth.oritech.block.blocks.decorative.TechDoorBlock;
import rearth.oritech.init.BlockEntitiesContent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TechDoorBlockEntity
extends class_2586
implements GeoBlockEntity {
    public static final RawAnimation OPEN = RawAnimation.begin().thenPlayAndHold("door_open");
    public static final RawAnimation CLOSE = RawAnimation.begin().thenPlayAndHold("door_close");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<TechDoorBlockEntity> animationController = this.getAnimationController();
    private long lastSoundEventAt = 0L;

    public TechDoorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.TECH_DOOR_ENTITY, pos, state);
    }

    public boolean shouldPlaySoundAgain() {
        long age = this.field_11863.method_8510() - this.lastSoundEventAt;
        this.lastSoundEventAt = this.field_11863.method_8510();
        return age > 40L;
    }

    private AnimationController<TechDoorBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            Boolean opened;
            if (state.getController().getCurrentAnimation() == null) {
                state.getController().setAnimationSpeed(100.0);
                TechDoorBlockEntity.delayedTimerReset((AnimationState<TechDoorBlockEntity>)state);
            }
            if ((opened = (Boolean)this.method_11010().method_11654((class_2769)TechDoorBlock.OPENED)).booleanValue()) {
                return state.setAndContinue(OPEN);
            }
            return state.setAndContinue(CLOSE);
        });
    }

    private static void delayedTimerReset(final AnimationState<TechDoorBlockEntity> state) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                state.getController().setAnimationSpeed(1.0);
            }
        }, 1000L);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

