/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.arcane;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.wispforest.owo.util.VectorRandomUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.entity.arcane.EnchantmentCatalystBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.EnchanterScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnchanterBlockEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
ScreenProvider,
ExtendedMenuProvider {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation UNPOWERED = RawAnimation.begin().thenPlayAndHold("unpowered");
    public static final RawAnimation WORKING = RawAnimation.begin().thenPlay("working");
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000L, 1000L, 0L, this::method_5431);
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(2, this::method_5431, new InventorySlotAssignment(0, 1, 1, 1));
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final class_2960 NONE_SELECTED = class_2960.method_60654((String)"o:empty");
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    @NotNull
    public class_2960 selectedEnchantment = NONE_SELECTED;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    public int progress;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    public int maxProgress = 10;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    public EnchanterStatistics statistics = EnchanterStatistics.EMPTY;
    private final List<EnchantmentCatalystBlockEntity> cachedCatalysts = new ArrayList<EnchantmentCatalystBlockEntity>();
    private String activeAnimation = "idle";

    public EnchanterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ENCHANTER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        int maxLevel;
        this.activeAnimation = "idle";
        if (world.method_8510() % 80L == 0L) {
            this.triggerAnim("machine", this.activeAnimation);
        }
        this.statistics = EnchanterStatistics.EMPTY;
        class_1799 content = (class_1799)this.inventory.heldStacks.get(0);
        if (content.method_7960() || !this.inventory.method_5438(1).method_7960() || !content.method_7909().method_7870(content) || this.selectedEnchantment.equals((Object)NONE_SELECTED) || !this.getSelectedEnchantment().method_40227() || !((class_1887)this.getSelectedEnchantment().comp_349()).method_8192(content)) {
            this.progress = 0;
            return;
        }
        int existingLevel = content.method_58657().method_57536(this.getSelectedEnchantment());
        if (existingLevel >= (maxLevel = ((class_1887)this.getSelectedEnchantment().comp_349()).method_8183())) {
            return;
        }
        this.maxProgress = this.getEnchantmentCost((class_1887)this.getSelectedEnchantment().comp_349(), existingLevel + 1);
        if (this.canProgress(existingLevel + 1)) {
            this.method_5431();
            this.energyStorage.amount -= (long)this.getDisplayedEnergyUsage();
            ++this.progress;
            this.activeAnimation = "working";
            class_243 center = pos.method_46558();
            class_243 offset = VectorRandomUtils.getRandomOffset((class_1937)world, (class_243)center, (double)4.0);
            ParticleContent.WEED_KILLER.spawn(world, center, (Object)new ParticleContent.LineData(center, offset));
            if (this.progress >= this.maxProgress) {
                this.progress = 0;
                this.finishEnchanting();
                ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.method_46558(), (Object)(this.maxProgress + 10));
                this.activeAnimation = "idle";
            }
        }
    }

    @Override
    public void sendUpdate(SyncType type) {
        super.sendUpdate(type);
        this.triggerAnim("machine", this.activeAnimation);
    }

    public class_6880<class_1887> getSelectedEnchantment() {
        if (this.selectedEnchantment.equals((Object)NONE_SELECTED)) {
            return null;
        }
        class_2378 registry = this.field_11863.method_30349().method_30530(class_7924.field_41265);
        return registry.method_47983((Object)((class_1887)registry.method_10223(this.selectedEnchantment)));
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10544("energy", this.energyStorage.amount);
        nbt.method_10582("selected", this.selectedEnchantment.toString());
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.energyStorage.amount = nbt.method_10537("energy");
        if (nbt.method_10545("selected")) {
            this.selectedEnchantment = class_2960.method_60654((String)nbt.method_10558("selected"));
        }
    }

    private void finishEnchanting() {
        class_1799 content = (class_1799)this.inventory.heldStacks.get(0);
        int existingLevel = content.method_58657().method_57536(this.getSelectedEnchantment());
        content.method_7978(this.getSelectedEnchantment(), existingLevel + 1);
        this.inventory.heldStacks.set(0, (Object)class_1799.field_8037);
        this.inventory.heldStacks.set(1, (Object)content);
        this.statistics = new EnchanterStatistics(0, this.cachedCatalysts.size());
    }

    private int getRequiredCatalystCount(int targetLevel) {
        return ((class_1887)this.getSelectedEnchantment().comp_349()).method_58446() + targetLevel;
    }

    private boolean canProgress(int targetLevel) {
        if ((float)this.energyStorage.amount <= this.getDisplayedEnergyUsage()) {
            this.activeAnimation = "unpowered";
            return false;
        }
        if (this.field_11863.method_8510() % 15L == 0L) {
            this.updateNearbyCatalysts();
        }
        int requiredCatalysts = this.getRequiredCatalystCount(targetLevel);
        this.statistics = new EnchanterStatistics(requiredCatalysts, this.cachedCatalysts.size());
        for (EnchantmentCatalystBlockEntity catalyst : this.cachedCatalysts) {
            ParticleContent.CATALYST_CONNECTION.spawn(this.field_11863, this.field_11867.method_46558(), (Object)new ParticleContent.LineData(catalyst.method_11016().method_46558(), this.field_11867.method_10084().method_46558()));
        }
        if (this.cachedCatalysts.size() < requiredCatalysts) {
            return false;
        }
        Collections.shuffle(this.cachedCatalysts);
        Optional<EnchantmentCatalystBlockEntity> usedOne = this.cachedCatalysts.stream().filter(elem -> elem.collectedSouls > 0).findFirst();
        if (usedOne.isEmpty()) {
            return false;
        }
        --usedOne.get().collectedSouls;
        this.method_5431();
        return true;
    }

    private int getEnchantmentCost(class_1887 enchantment, int targetLevel) {
        return enchantment.method_58446() * targetLevel * Oritech.CONFIG.enchanterCostMultiplier() + 1;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 4, state -> PlayState.CONTINUE).triggerableAnim("working", WORKING).triggerableAnim("idle", IDLE).triggerableAnim("unpowered", UNPOWERED).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private void updateNearbyCatalysts() {
        int chunkRadius = 1;
        int startX = (this.field_11867.method_10263() >> 4) - chunkRadius;
        int startZ = (this.field_11867.method_10260() >> 4) - chunkRadius;
        int endX = (this.field_11867.method_10263() >> 4) + chunkRadius;
        int endZ = (this.field_11867.method_10260() >> 4) + chunkRadius;
        this.cachedCatalysts.clear();
        for (int chunkX = startX; chunkX <= endX; ++chunkX) {
            for (int chunkZ = startZ; chunkZ <= endZ; ++chunkZ) {
                class_2791 chunk = this.field_11863.method_8402(chunkX, chunkZ, class_2806.field_12803, false);
                if (chunk == null) continue;
                Map entities = chunk.field_34543;
                List<EnchantmentCatalystBlockEntity> catalysts = entities.values().stream().filter(elem -> {
                    if (!(elem instanceof EnchantmentCatalystBlockEntity)) return false;
                    EnchantmentCatalystBlockEntity catalyst = (EnchantmentCatalystBlockEntity)elem;
                    if (catalyst.collectedSouls <= 0) return false;
                    if (elem.method_11016().method_19455((class_2382)this.field_11867) >= 16) return false;
                    return true;
                }).map(elem -> (EnchantmentCatalystBlockEntity)elem).toList();
                this.cachedCatalysts.addAll(catalysts);
            }
        }
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new EnchanterScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 52, 58), new ScreenProvider.GuiSlot(1, 108, 58, true));
    }

    @Override
    public ScreenProvider.ArrowConfiguration getIndicatorConfiguration() {
        return new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 73, 58, 29, 16, true);
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 7, 18, 71);
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 512.0f;
    }

    @Override
    public float getProgress() {
        return (float)this.progress / (float)this.maxProgress;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.ENCHANTER_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    public static void receiveEnchantmentSelection(SelectEnchantingPacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        class_2586 blockEntity = player.method_37908().method_8321(packet.self);
        if (blockEntity instanceof EnchanterBlockEntity) {
            EnchanterBlockEntity enchanterBlock = (EnchanterBlockEntity)blockEntity;
            enchanterBlock.selectedEnchantment = packet.enchantmentId;
        }
    }

    public record EnchanterStatistics(int requiredCatalysts, int availableCatalysts) {
        public static EnchanterStatistics EMPTY = new EnchanterStatistics(-1, -1);
    }

    public record SelectEnchantingPacket(class_2338 self, class_2960 enchantmentId) implements class_8710
    {
        public static final class_8710.class_9154<SelectEnchantingPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("selected_enchant"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

