package rearth.oritech.util;

import rearth.oritech.Oritech;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8710;

public class ServerZiplineHandler {
    
    private static final Map<UUID, Long> LAST_ZIPLINED_AT = new HashMap<>();
    
    public static void onZipLineTickUseEvent(ZiplinePlayerUsePacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        LAST_ZIPLINED_AT.put(player.method_5667(), player.method_37908().method_8510());
    }
    
    // prevent fall damage / flying kick
    public static void onPlayerTick(class_1657 player) {
        if (player.method_37908().method_8608()) return;
        
        var id = player.method_5667();
        
        var startTime = LAST_ZIPLINED_AT.getOrDefault(id, 0L);
        var age = player.method_37908().method_8510() - startTime;
        
        if (age > 20) {
            LAST_ZIPLINED_AT.remove(id);
            return;
        }
        
        player.method_38785();
        if (player instanceof class_3222 serverPlayer)
            serverPlayer.field_13987.field_14138 = 0;
    }
    
    public record ZiplinePlayerUsePacket() implements class_8710 {
        
        public static final class_8710.class_9154<ZiplinePlayerUsePacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("zipline_use"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
    
}
