package rearth.oritech.item.tools.util;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;

public interface OritechEnergyItem extends EnergyApi.ItemProvider {
    
    default long getEnergyCapacity(class_1799 stack) {return 10_000;}
    
    default long getEnergyMaxInput(class_1799 stack) {
        return 500;
    }
    
    default long getEnergyMaxOutput(class_1799 stack) {
        return 0;
    }
    
    default boolean tryUseEnergy(class_1799 stack, long amount, class_1657 player){
        class_5819 random = class_5819.method_43047();
        
        int unbreakingLevel = getUnbreakingLevel(stack);
        if (unbreakingLevel > 0) {
            amount = amount / (random.method_43048(unbreakingLevel) + 1);
        }
        
        var storage = getEnergyStorage(stack);
        if (storage instanceof SimpleEnergyItemStorage itemStorage) {
            var extracted = itemStorage.extractIgnoringLimit(amount, false);
            if (extracted > 0) {
                itemStorage.update();
            }
            
            return extracted == amount;
        }
        
        return false;
        
    }
    
    // A hack to do this without context of the DRM
    private int getUnbreakingLevel(class_1799 stack) {
        class_9304 enchantments = stack.method_57825(class_9334.field_49633, class_9304.field_49385);
        for (class_6880<class_1887> entry : enchantments.method_57534()) {
            if (entry.method_40230().isPresent() && entry.method_40230().get().equals(class_1893.field_9119)) {
                return enchantments.method_57536(entry);
            }
        }
        return 0;
    }
    
    default long getStoredEnergy(class_1799 stack) {
        return getEnergyStorage(stack).getAmount();
    }
    
    @Override
    default EnergyApi.EnergyStorage getEnergyStorage(class_1799 stack) {
        return new SimpleEnergyItemStorage(getEnergyMaxInput(stack), getEnergyMaxOutput(stack), getEnergyCapacity(stack), stack);
    }
}