package rearth.oritech.item.tools.harvesting;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.TreefellerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.PromethiumToolRenderer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_756;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9424.class_9425;

public class PromethiumAxeItem extends class_1743 implements GeoItem {
    
    public static final Deque<class_3545<class_1937, class_2338>> pendingBlocks = new ArrayDeque<>();
    
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    
    public PromethiumAxeItem(class_1832 toolMaterial, class_1793 settings) {
        super(toolMaterial, settings);
        // a bit of a hack, but set tool components again after super()
        // this lets PromethiumAxeItem extend AxeItem (for the right-click actions) and still ignore
        // the default tool components set up by AxeItem
        var toolComponent = new class_9424(List.of(
            class_9425.method_58427(toolMaterial.method_58419()),
            class_9425.method_58428(class_3481.field_33713, toolMaterial.method_8027()),
            class_9425.method_58433(class_3481.field_44469, 1.5F),
            class_9425.method_58431(List.of(class_2246.field_10343), 15.0F)),
            1.0F, 1);
        this.field_49263 = settings.method_57349(class_9334.field_50077, toolComponent).method_58406();
    }
    
    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        
        if (!world.field_9236 && miner.method_5715()) {
            var startPos = pos.method_10084();
            var startState = world.method_8320(startPos);
            if (startState.method_26164(class_3481.field_15475)) {
                var treeBlocks = TreefellerBlockEntity.getTreeBlocks(startPos, world);
                pendingBlocks.addAll(treeBlocks.stream().map(elem -> new class_3545<>(world, elem)).toList());
            }
        }
        
        return true;
    }
    
    public static void processPendingBlocks(class_1937 world) {
        if (pendingBlocks.isEmpty()) return;
        
        var topWorld = pendingBlocks.getFirst().method_15442();
        if (topWorld != world) return;
        
        for (int i = 0; i < 8 && !pendingBlocks.isEmpty(); i++) {
            var candidate = pendingBlocks.pollFirst().method_15441();
            var candidateState = world.method_8320(candidate);
            if (!candidateState.method_26164(class_3481.field_15475) && !candidateState.method_26164(class_3481.field_15503)) return;
            
            var dropped = class_2248.method_9562(candidateState, (class_3218) world, candidate, null);
            world.method_8501(candidate, class_2246.field_10124.method_9564());
            
            dropped.forEach(elem -> world.method_8649(new class_1542(world, candidate.method_10263(), candidate.method_10264(), candidate.method_10260(), elem)));
            
            world.method_8396(null, candidate, candidateState.method_26231().method_10595(), class_3419.field_15245, 0.5f, 1f);
            world.method_31595(candidate, candidateState);
            
            ParticleContent.BLOCK_DESTROY_EFFECT.spawn(world, class_243.method_24954(candidate), 4);
            
            if (candidateState.method_26164(class_3481.field_15475)) break;
        }
        
    }
    
    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }
    
    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }
    
    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider() {
            private PromethiumToolRenderer renderer;
            
            @Override
            public @Nullable class_756 getGeoItemRenderer() {
                if (this.renderer == null)
                    this.renderer = new PromethiumToolRenderer("promethium_axe");
                return renderer;
            }
        });
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }
    
    public static void onTick(class_3218 serverWorld) {
        processPendingBlocks(serverWorld);
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add(class_2561.method_43471("tooltip.oritech.promethium_axe").method_27692(class_124.field_1063));
    }
}
