package rearth.oritech.item.tools;

import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.init.SoundContent;
import rearth.oritech.item.tools.harvesting.ChainsawItem;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.TooltipHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9362;

public class ElectricMaceItem extends class_9362 implements OritechEnergyItem {
    
    private static final int BASE_ATTACK_DAMAGE = Oritech.CONFIG.electricMace.baseDamage();
    private static final int RF_USAGE = Oritech.CONFIG.electricMace.energyUsage();
    
    public static final Map<Long, Runnable> PENDING_LIGHTNING_HITS = new HashMap<>();
    
    public ElectricMaceItem(class_1793 settings) {
        super(settings);
    }
    
    public static class_9285 method_59532() {
        return class_9285
                 .method_57480()
                 .method_57487(class_5134.field_23721, new class_1322(field_8006, BASE_ATTACK_DAMAGE, class_1322.class_1323.field_6328), class_9274.field_49217)
                 .method_57487(class_5134.field_23723, new class_1322(field_8001, -3.4F, class_1322.class_1323.field_6328), class_9274.field_49217)
                 .method_57487(class_5134.field_49079, new class_1322(Oritech.id("mace_fall_protection"), 10, class_1322.class_1323.field_6328), class_9274.field_49217)
                 .method_57487(class_5134.field_47759, new class_1322(Oritech.id("mace_reach"), 3, class_1322.class_1323.field_6328), class_9274.field_49217)
                 .method_57486();
    }
    
    @Override
    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        
        var bonus = 0f;
        
        var usedEnergy = tryUseEnergy(stack, RF_USAGE, null);
        if (usedEnergy && method_58659(attacker)) {
            attacker.method_37908().method_45447(null, target.method_24515(), SoundContent.ELECTRIC_SHOCK, class_3419.field_15248);
            attacker.method_38785();
            bonus = method_58403(target, BASE_ATTACK_DAMAGE, new class_1282(attacker.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), attacker));
        }
        
        
        if (attacker instanceof class_1657 player && attacker.method_37908() instanceof class_3218 serverWorld) {
            if (player.method_7357().method_7904(this))
                return;
            
            player.method_7357().method_7906(this, 40);
            createLightningAttack(serverWorld, player, target, stack, (int) (BASE_ATTACK_DAMAGE / 2f + bonus / 2f));
        }
    }
    
    private void createLightningAttack(class_3218 world, class_1657 attacker, class_1309 target, class_1799 stack, int damage) {
        
        var usedEnergy = tryUseEnergy(stack, RF_USAGE * Oritech.CONFIG.electricMace.lightningCostMultiplier(), null);
        if (usedEnergy && attacker.method_37908() instanceof class_3218 serverWorld) {
            
            var playerPos = attacker.method_33571();
            var targetPos = target.method_33571();
            var offset = targetPos.method_1020(playerPos);
            var up = new class_243(0, 1, 0);
            var cross = offset.method_1036(up).method_1029();
            var pos = targetPos.method_1019(cross.method_1021(14)).method_49272(serverWorld.field_9229, 3).method_1031(0, 7, 0);
            
            createLightningBolt(serverWorld, pos, target.method_33571().method_49272(serverWorld.field_9229, 0.1f), 10, 0.8f, 4, class_2398.field_11208, 0.35f, 2, 0);
            
            for (int i = 1; i <= 5; i++) {
                final var ownPos = targetPos.method_1019(cross.method_1024(i * 90).method_1021(14)).method_49272(serverWorld.field_9229, 5).method_1031(0, 7, 0);
                PENDING_LIGHTNING_HITS.put(serverWorld.method_8510() + 10 * i, () -> {
                    createLightningBolt(serverWorld, ownPos, target.method_33571().method_49272(serverWorld.field_9229, 0.1f), 10, 0.8f, 4, class_2398.field_11208, 0.35f, 2, 0);
                    target.field_6235 = 0;
                    target.method_5643(new class_1282(serverWorld.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), attacker), damage);
                });
            }
        }
    }
    
    public static void processLightningEvents(class_1937 world) {
        var toRemove = new ArrayList<Long>();
        for (var entry : PENDING_LIGHTNING_HITS.entrySet()) {
            var key = entry.getKey();
            if (world.method_8510() > key) {
                var event = entry.getValue();
                event.run();
                toRemove.add(key);
            }
        }
        
        toRemove.forEach(PENDING_LIGHTNING_HITS::remove);
    }
    
    @Override
    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        
        var attacker = damageSource.method_5526();
        if (attacker instanceof class_1309 livingEntity) {
            if (!method_58659(livingEntity)) {
                return 0.0F;
            } else {
                float fallDist = livingEntity.field_6017;
                float damage;
                if (fallDist <= 3.0F) {
                    damage = BASE_ATTACK_DAMAGE * fallDist;
                } else if (fallDist <= 8.0F) {
                    damage = BASE_ATTACK_DAMAGE * 4 + 4.0F * (fallDist - 3.0F);
                } else {
                    damage = BASE_ATTACK_DAMAGE * 6 + fallDist - 8.0F;
                }
                
                var world = livingEntity.method_37908();
                if (world instanceof class_3218 serverWorld) {
                    return damage + class_1890.method_60160(serverWorld, livingEntity.method_59958(), target, damageSource, 2.0F) * fallDist;
                } else {
                    return damage;
                }
            }
        } else {
            return 0.0F;
        }
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var text = class_2561.method_43469("tooltip.oritech.energy_indicator", TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack)));
        tooltip.add(text.method_27692(class_124.field_1065));
        
        var showExtra = class_437.method_25441();
        
        if (showExtra) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.electric_mace").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
            tooltip.add(class_2561.method_43471("tooltip.oritech.electric_mace.1").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
    }
    
    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }
    
    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_31569(class_1799 stack) {
        return Math.round((getStoredEnergy(stack) * 100f / this.getEnergyCapacity(stack)) * ChainsawItem.BAR_STEP_COUNT) / 100;
    }
    
    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        return 0xff7007;
    }
    
    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.electricMace.energyCapacity();
    }
    
    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return getEnergyCapacity(stack) / 10;
    }
    
    // this overrides the fabric specific extensions
    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }
    
    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }
    
    // this overrides the neoforge specific extensions
    public boolean shouldCauseReequipAnimation(@NotNull class_1799 oldStack, @NotNull class_1799 newStack, boolean slotChanged) {
        return false;
    }
    
    public boolean shouldCauseBlockBreakReset(@NotNull class_1799 oldStack, @NotNull class_1799 newStack) {
        return false;
    }
    
    /**
     * Creates a lightning effect between two points.
     *
     * @param level              The ServerLevel to spawn the effect in.
     * @param startPos           The starting position of the lightning.
     * @param endPos             The ending position of the lightning.
     * @param mainSegments       Number of main segments for the lightning path (more = more jagged).
     * @param jitterAmount       Maximum random offset for each segment point.
     * @param particlesPerMeter  How many particles to spawn per meter of segment length.
     * @param particleEffect     The particle type to use (e.g., ParticleTypes.ELECTRIC_SPARK).
     * @param branchChance       Chance (0.0 to 1.0) for a branch to occur at a segment point.
     * @param maxBranchDepth     Maximum recursion depth for branches.
     * @param currentBranchDepth Current depth (used internally for recursion).
     */
    public static void createLightningBolt(class_3218 level, class_243 startPos, class_243 endPos,
                                           int mainSegments, double jitterAmount,
                                           double particlesPerMeter, class_2394 particleEffect,
                                           float branchChance, int maxBranchDepth, int currentBranchDepth) {
        var random = level.method_8409();
        var direction = endPos.method_1020(startPos);
        double totalDistance = direction.method_1033();
        
        if (totalDistance < 0.1) { // Too short to draw
            // Optional: just spawn a particle at the point or do nothing
            level.method_14199(particleEffect, startPos.field_1352, startPos.field_1351, startPos.field_1350, 5, 0.1, 0.1, 0.1, 0.05);
            return;
        }
        
        var segmentVector = direction.method_1029().method_1021(totalDistance / mainSegments);
        var previousPoint = startPos;
        
        // Sound for the main bolt (only if not a branch or first branch)
        if (currentBranchDepth == 0) {
            level.method_43128(null, endPos.field_1352, endPos.field_1351, endPos.field_1350, SoundContent.ELECTRIC_SHOCK, class_3419.field_15248, 0.8f, 0.5f + level.field_9229.method_43057() * 0.8f);
        }
        
        
        for (int i = 0; i < mainSegments; i++) {
            class_243 currentTargetPoint;
            if (i < mainSegments - 1) {
                currentTargetPoint = startPos.method_1019(segmentVector.method_1021(i + 1));
                // Add jitter
                currentTargetPoint = currentTargetPoint.method_1031(
                  (random.method_43058() - 0.5) * 2 * jitterAmount,
                  (random.method_43058() - 0.5) * 2 * jitterAmount,
                  (random.method_43058() - 0.5) * 2 * jitterAmount
                );
            } else {
                currentTargetPoint = endPos; // Ensure the last segment goes exactly to the end point
            }
            
            // Spawn particles along the segment from previousPoint to currentTargetPoint
            spawnParticlesAlongSegment(level, previousPoint, currentTargetPoint, particlesPerMeter, particleEffect);
            
            // Branching logic
            if (currentBranchDepth < maxBranchDepth && random.method_43057() < branchChance && i < mainSegments - 1) { // Don't branch from the very last segment point
                var branchEndOffset = new class_243(
                  (random.method_43058() - 0.5) * totalDistance * 0.3, // Branch length relative to main bolt
                  (random.method_43058() - 0.5) * totalDistance * 0.3,
                  (random.method_43058() - 0.5) * totalDistance * 0.3
                );
                var branchEnd = currentTargetPoint.method_1019(branchEndOffset);
                // Make branches shorter and less detailed
                createLightningBolt(level, currentTargetPoint, branchEnd,
                  Math.max(1, mainSegments / 2), jitterAmount * 0.7,
                  particlesPerMeter * 0.7, particleEffect,
                  branchChance * 0.5f, maxBranchDepth, currentBranchDepth + 1);
            }
            previousPoint = currentTargetPoint;
        }
    }
    
    private static void spawnParticlesAlongSegment(class_3218 level, class_243 p1, class_243 p2, double particlesPerMeter, class_2394 particleEffect) {
        var segment = p2.method_1020(p1);
        var length = segment.method_1033();
        if (length < 0.01) return; // Avoid division by zero or tiny segments
        
        var unit = segment.method_1029();
        var numParticles = Math.max(1, (int) (length * particlesPerMeter));
        
        for (int i = 0; i < numParticles; i++) {
            double progress = (double) i / (double) numParticles;
            var particlePos = p1.method_1019(unit.method_1021(length * progress));
            level.method_14199(particleEffect, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350,
              1, 0, 0, 0, 0.0D); // count, dx, dy, dz, speed
        }
    }
}
