package rearth.oritech.init.recipes;

import dev.architectury.fluid.FluidStack;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.SimpleCraftingInventory;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9695;

public class OritechRecipe implements class_1860<class_9695> {
    
    protected final OritechRecipeType type;
    protected final List<class_1856> inputs;
    protected final List<class_1799> results;
    protected final FluidIngredient fluidInput;
    protected final List<FluidStack> fluidOutputs;
    protected final int time;

    public static final OritechRecipe DUMMY = new OritechRecipe(-1, class_2371.method_10213(1, class_1856.method_8101(class_1802.field_8620.method_7854())), class_2371.method_10213(1, class_1802.field_8773.method_7854()), RecipeContent.PULVERIZER, FluidIngredient.EMPTY, FluidStack.empty());
    
    public OritechRecipe(int time, List<class_1856> inputs, List<class_1799> results, OritechRecipeType type, @Nullable FluidIngredient fluidInput, @Nullable FluidStack fluidOutput) {
        this(time, inputs, results, type, fluidInput, (fluidOutput == null || fluidOutput.isEmpty()) ? List.of() : List.of(fluidOutput));
    }
    public OritechRecipe(int time, List<class_1856> inputs, List<class_1799> results, OritechRecipeType type, @Nullable FluidIngredient fluidInput, List<FluidStack> fluidOutputs) {
        this.type = type;
        this.results = results;
        this.inputs = inputs;
        this.time = time;
        if (fluidInput == null) fluidInput = FluidIngredient.EMPTY;
        this.fluidInput = fluidInput.withAmount(fluidInput.amount());
        this.fluidOutputs = fluidOutputs;
    }

    public OritechRecipe(int time, List<class_1856> inputs, List<class_1799> results, OritechRecipeType type, @Nullable FluidIngredient fluidInput, class_3611 outVariant, long outAmount) {
        this(time, inputs, results, type, fluidInput, FluidStack.create(outVariant, outAmount));
    }
    
    public OritechRecipe(int time, List<class_1856> inputs, List<class_1799> results, OritechRecipeType type, class_3611 inVariant, long inAmount, class_3611 outVariant, long outAmount) {
        this(time, inputs, results, type, new FluidIngredient().withContent(inVariant).withAmount(inAmount), FluidStack.create(outVariant, outAmount));
    }
    
    
    @Override
    public boolean method_8115(class_9695 input, class_1937 world) {
        
        if (world.field_9236) return false;
        
        if (inputs.size() > 1) {
            return complexMatch(input);
        }
        
        if (input.method_59983() < inputs.size()) return false;
        
        var ingredients = getInputs();
        for (int i = 0; i < ingredients.size(); i++) {
            var entry = ingredients.get(i);
            if (!entry.method_8093(input.method_59984(i))) {
                return false;
            }
        }
        
        return true;
    }
    
    private boolean complexMatch(class_9695 input) {
        
        if (!(input instanceof SimpleCraftingInventory simpleInventory)) return false;
        
        // Input does not need to be in the correct slots / split into different slots.
        // We just check if we can remove all ingredients from the inventory, and fail is any input is not able to be removed.
        var copiedInv = simpleInventory.getItems().stream().map(class_1799::method_7972).toArray(class_1799[]::new);
        
        for (var ingredient : getInputs()) {
            
            var found = false;
            
            for (var heldStack : copiedInv) {
                if (ingredient.method_8093(heldStack)) {
                    heldStack.method_7934(1);
                    found = true;
                    break;
                }
            }
            
            if (!found) return false;
        }
        
        return true;
    }
    
    @Override
    public class_1799 method_8116(class_9695 input, class_7225.class_7874 lookup) {
        return null;
    }
    
    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }
    
    @Override
    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return class_1799.field_8037;
    }

    @Override
    public class_1865<?> method_8119() {
        return type;
    }
    
    @Override
    public boolean method_8118() {
        return true;
    }
    
    @Override
    public class_3956<?> method_17716() {
        return type;
    }
    
    @Override
    public String toString() {
        return "OritechRecipe{" +
                 "type=" + type +
                 ", inputs=" + inputs +
                 ", results=" + results +
                 ", fluidInput=" + fluidInput +
                 ", time=" + time +
                 '}';
    }
    
    public int getTime() {
        return time;
    }
    
    public List<class_1856> getInputs() {
        return inputs;
    }

    // do not use this one, use getInputs if applicable to avoid unnecessary copy
    @Override
    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212(class_1856.field_9017, inputs.toArray(class_1856[]::new));
    }

    public List<class_1799> getResults() {
        return results;
    }

    public OritechRecipeType getOriType() {
        return type;
    }
    
    public @Nullable FluidIngredient getFluidInput() {
        return fluidInput;
    }
    
    public List<FluidStack> getFluidOutputs() {
        return fluidOutputs;
    }
}
