package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import net.minecraft.class_1661;
import net.minecraft.class_2401;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.client.ui.components.CustomBlockComponent;
import rearth.oritech.init.BlockContent;

public class PowerPoleScreen extends EnergyStorageScreen {
    
    public PowerPoleScreen(UpgradableMachineScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        var powerPoleEntity = (PowerPoleEntity) this.field_2797.blockEntity;
        var connectionCount = powerPoleEntity.getConnections().size();
        var isConnected = connectionCount > 0;
        
        // show connection status
        var connectedIcon = new CustomBlockComponent(BlockContent.TECH_LEVER.method_9564().method_11657(class_2401.field_11265, isConnected), null);
        var connectedLabel = Components.label(class_2561.method_43469("title.oritech.power_pole_connection_" + (isConnected ? "enabled" : "disabled"), connectionCount).method_54663(BasicMachineScreen.GRAY_TEXT_COLOR));
        var containedTooltipText = class_2561.method_43471("tooltip.oritech.power_pole_connection_" + (isConnected ? "enabled" : "disabled"));
        connectedIcon.tooltip(containedTooltipText);
        connectedLabel.tooltip(containedTooltipText);
        
        connectedIcon.sizing(Sizing.fixed(40), Sizing.fixed(40));
        
        var connectedContainer = Containers.verticalFlow(Sizing.fixed(44), Sizing.content());
        connectedContainer.child(connectedIcon.margins(Insets.of(4, 2, 4, 4)));
        connectedContainer.child(connectedLabel.margins(Insets.of(4, 2, 4, 4)));
        connectedContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        
        overlay.child(connectedContainer.positioning(Positioning.absolute(27, 5)));
        
    }
    
    @Override
    public DynamicStatisticEnergyStorage.EnergyStatistics getStatistics(class_2586 entity) {
        return ((PowerPoleEntity) entity).currentStats;
    }
}
