package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.*;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.arcane.EnchanterBlockEntity;


public class EnchanterScreen extends BasicMachineScreen<EnchanterScreenHandler> {
    
    private class_1799 currentItem = null;
    private FlowLayout detailsScrollPane;
    private ButtonComponent openEnchantmentSelection;
    private LabelComponent statisticsLabel;
    
    public EnchanterScreen(EnchanterScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    public boolean showExtensionPanel() {
        return false;
    }
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        openEnchantmentSelection = Components.button(class_2561.method_43471("button.oritech.enchanter.bane_of_long_names"), this::onOpenClicked);
        openEnchantmentSelection.positioning(Positioning.relative(54, 13));
        openEnchantmentSelection.active(false);
        openEnchantmentSelection.renderer(ORITECH_BUTTON_DARK);
        overlay.child(openEnchantmentSelection);
        
        detailsScrollPane = Containers.verticalFlow(Sizing.content(2), Sizing.content(2));
        detailsScrollPane.padding(Insets.of(2));
        detailsScrollPane.margins(Insets.of(3));
        
        statisticsLabel = Components.label(class_2561.method_43469("title.oritech.enchanter.catalysts_available", 1, 4));
        statisticsLabel.positioning(Positioning.relative(54, 29));
        overlay.child(statisticsLabel);
    }
    
    private void onOpenClicked(ButtonComponent event) {
        sendEnchantmentToServer(EnchanterBlockEntity.NONE_SELECTED);
        openSelectionPanel();
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        
        var stack = this.field_2797.enchanter.inventory.method_5438(0);
        if (currentItem == null)
            currentItem = stack;
        
        if (stack.method_7909() != currentItem.method_7909()) {
            currentItem = stack;
            onStackChanged();
        }
        
        class_2561 description = class_2561.method_43471("message.oritech.enchanter.insert_item");
        var hasSelection = this.field_2797.enchanter.getSelectedEnchantment() != null;
        if (hasSelection) {
            description = this.field_2797.enchanter.getSelectedEnchantment().comp_349().comp_2686();
        }
        openEnchantmentSelection.method_25355(description);
        
        
        var registry = field_2797.enchanter.method_10997().method_30349().method_30530(class_7924.field_41265);
        var canBeEnchanted = registry.method_10220().anyMatch(elem -> elem.method_8192(stack));
        
        openEnchantmentSelection.active(hasSelection && canBeEnchanted);
        
        var statistics = field_2797.enchanter.statistics;
        if (statistics.equals(EnchanterBlockEntity.EnchanterStatistics.EMPTY)) {
            statisticsLabel.text(class_2561.method_43470(" "));
        } else {
            statisticsLabel.text(class_2561.method_43469("title.oritech.enchanter.catalysts", statistics.availableCatalysts(), statistics.requiredCatalysts()).method_27692(class_124.field_1063));
        }
        
        this.progress_indicator.tooltip(class_2561.method_43469("title.oritech.enchanter.souls_used", field_2797.enchanter.progress, field_2797.enchanter.maxProgress));
        
    }
    
    private void onStackChanged() {
        if (field_2797.enchanter.getSelectedEnchantment() != null) return;
        openSelectionPanel();
        
    }
    
    private void openSelectionPanel() {
        
        var slotCount = this.field_2797.field_7761.size();
        
        for (int i = 0; i < slotCount; i++) {
            this.disableSlot(i);
        }
        
        // find enchantments
        var registry = field_2797.enchanter.method_10997().method_30349().method_30530(class_7924.field_41265);
        var all = registry.method_10220().map(registry::method_47983).filter(entry -> entry.comp_349().method_8192(currentItem)).toList();
        
        if (all.isEmpty()) return;
        
        detailsScrollPane.clearChildren();
        
        var title = Components.label(class_2561.method_43471("tooltip.oritech.enchanter_selection"));
        detailsScrollPane.child(title);
        
        var scrollPane = Containers.verticalScroll(Sizing.fixed(184), Sizing.fixed(200), detailsScrollPane);
        scrollPane.padding(Insets.of(2));
        var floatingPanel = new OverlayContainer<>(scrollPane) {
            @Override
            public void remove() {
                super.remove();
                for (int i = 0; i < slotCount; i++) {
                    EnchanterScreen.this.enableSlot(i);
                }
            }
        };
        
        // refresh gui
        for (var entry : all) {
            var candidate = entry.comp_349();
            var button = Components.button(candidate.comp_2686().method_27661().method_54663(BasicMachineScreen.GRAY_TEXT_COLOR), data -> onEnchantmentSelected(entry, floatingPanel));
            button.sizing(Sizing.fill(), Sizing.fixed(25));
            button.margins(Insets.of(1, 1, 0, 8));
            button.renderer(ORITECH_BUTTON);
            button.textShadow(false);
            detailsScrollPane.child(button);
        }
        
        scrollPane.surface(Surface.DARK_PANEL);
        
        
        floatingPanel.zIndex(9800);
        floatingPanel
          .horizontalAlignment(HorizontalAlignment.CENTER)
          .verticalAlignment(VerticalAlignment.CENTER);
        
        this.root.child(floatingPanel);
    }
    
    private void onEnchantmentSelected(class_6880<class_1887> entry, OverlayContainer<ScrollContainer<FlowLayout>> floatingPanel) {
        this.field_2797.enchanter.selectedEnchantment = class_2960.method_60654(entry.method_55840());
        sendEnchantmentToServer(class_2960.method_60654(entry.method_55840()));
        floatingPanel.remove();
    }
    
    private void sendEnchantmentToServer(class_2960 selected) {
        NetworkManager.sendToServer(new EnchanterBlockEntity.SelectEnchantingPacket(this.field_2797.blockPos, selected));
    }
    
    
}
