package rearth.oritech.client.other;

import java.util.BitSet;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_778;

import static net.minecraft.class_761.field_4095;
import static net.minecraft.class_4668.*;

public class OreFinderRenderer {
    
    public static List<class_2338> renderedBlocks;
    public static long receivedAt;
    
    private static final class_1921 OVERLAY = class_1921.method_24049("overlay",
      class_290.field_1590,
      class_293.class_5596.field_27382,
      4194304,
      true,
      false,
      class_1921.class_4688.method_23598()
        .method_23608(field_21383)
        .method_34578(field_29443)
        .method_34577(field_21376)
        .method_23603(field_21344)
        .method_23610(field_21359)
        .method_23617(false));
    
    public static void doRender(class_4587 matrices, class_4184 camera, class_4597 vertexConsumers) {
        var world = class_310.method_1551().field_1687;
        if (world == null || renderedBlocks == null) return;
        var age = world.method_8510() - receivedAt;
        
        if (age > 15) return;
        
        for (var pos : renderedBlocks) {
            var state = world.method_8320(pos);
            
            matrices.method_22903();
            //Offset by the camera position so that the render is relative to the camera
            matrices.method_22904(pos.method_10263() - camera.method_19326().field_1352, pos.method_10264() - camera.method_19326().field_1351, pos.method_10260() - camera.method_19326().field_1350);
            
            
            var renderer = class_310.method_1551().method_1541().method_3350();
            var vertexProvider = vertexConsumers.getBuffer(OVERLAY);
            
            OreFinderRenderer.tesselateWithoutAO(renderer, world, class_310.method_1551().method_1541().method_3349(state), state, pos, matrices, vertexProvider, false, world.field_9229, 0, 0);
            
            matrices.method_22909();
        }
    }
    
    
    public static void tesselateWithoutAO(class_778 renderer, class_1920 level, class_1087 model, class_2680 state, class_2338 pos, class_4587 poseStack, class_4588 consumer, boolean checkSides, class_5819 random, long seed, int packedOverlay) {
        BitSet bitSet = new BitSet(3);
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        
        for(class_2350 direction : field_4095) {
            random.method_43052(seed);
            List<class_777> list = model.method_4707(state, direction, random);
            if (!list.isEmpty()) {
                mutableBlockPos.method_25505(pos, direction);
                if (!checkSides || class_2248.method_9607(state, level, pos, direction, mutableBlockPos)) {
                    int i = class_765.field_32767;
                    renderer.method_3370(level, state, pos, i, packedOverlay, false, poseStack, consumer, list, bitSet);
                }
            }
        }
        
        random.method_43052(seed);
        List<class_777> list2 = model.method_4707(state, null, random);
        if (!list2.isEmpty()) {
            int i = class_765.field_32767;
            renderer.method_3370(level, state, pos, i, packedOverlay, true, poseStack, consumer, list2, bitSet);
        }
        
    }
}
