package rearth.oritech.client.cablesurfer;

import com.mojang.blaze3d.vertex.*;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.oritech.client.renderers.PowerPoleCableRenderer;

public class ActiveCableRenderer {
    
    public static void render(class_4587 poseStack, class_4597 bufferSource) {
        if (!ClientZiplineHandler.isActive()) return;
        
        class_310 mc = class_310.method_1551();
        class_243 camPos = mc.field_1773.method_19418().method_19326();
        
        class_243 start = ClientZiplineHandler.getStartPos();
        class_243 end = ClientZiplineHandler.getEndPos();
        
        // Get Parallel
        class_243 parStart = ClientZiplineHandler.getParallelStart();
        class_243 parEnd = ClientZiplineHandler.getParallelEnd();
        
        if (start == null || end == null) return;
        
        var consumer = bufferSource.getBuffer(class_1921.method_23572(PowerPoleCableRenderer.CABLE_TEXTURE));
        
        renderHangingCable(poseStack, consumer, start.method_1020(camPos), end.method_1020(camPos), 0.048f);
        
        if (parStart != null && parEnd != null) {
            renderHangingCable(poseStack, consumer, parStart.method_1020(camPos), parEnd.method_1020(camPos), 0.048f);
        }
    }
    
    private static void renderHangingCable(class_4587 poseStack, class_4588 consumer, class_243 startPos, class_243 endPos, float thickness) {
        
        var totalOffset = endPos.method_1020(startPos);
        float totalLength = (float) totalOffset.method_1033();
        int segments = class_3532.method_15340((int) totalLength, 8, 48);
        
        var sag = Math.min(totalLength * 0.05f, 4);
        var currentPos = startPos;
        
        for (int i = 0; i < segments; i++) {
            float t = (float) (i + 1) / segments;
            
            // Linear
            var nextPos = startPos.method_1019(totalOffset.method_1021(t));
            
            // Parabolic Sag
            var sagY = -sag * 4 * t * (1 - t);
            nextPos = nextPos.method_1031(0, sagY, 0);
            
            var segmentDelta = nextPos.method_1020(currentPos);
            
            // Draw segment
            drawSegment(poseStack, consumer, currentPos, segmentDelta, thickness);
            
            currentPos = nextPos;
        }
    }
    
    private static void drawSegment(class_4587 poseStack, class_4588 consumer, class_243 startPos, class_243 delta, float thickness) {
        poseStack.method_22903();
        poseStack.method_22904(startPos.field_1352, startPos.field_1351, startPos.field_1350);
        poseStack.method_46416(0, 0.35f, 0);
        
        var xzLen = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        var yRot = (float) (-Math.atan2(-delta.field_1352, delta.field_1350));
        var xRot = (float) (-Math.atan2(delta.field_1351, xzLen));
        
        poseStack.method_22907(class_7833.field_40716.rotation(yRot));
        poseStack.method_22907(class_7833.field_40714.rotation(xRot + (float) (Math.PI / 2)));
        
        float length = (float) delta.method_1033() * 1.02f; // Slight overlap
        float r = thickness;
        
        int light = class_765.field_32767;
        
        Matrix4f pose = poseStack.method_23760().method_23761();
        Matrix3f normal = poseStack.method_23760().method_23762(); // Critical for rotating lighting
        
        // --- Side 1 (Front: Z+) ---
        // Normal: (0, 0, 1)
        addVertex(consumer, pose, normal, -r, 0, r, 0, 0, 0, 0, 1, light);
        addVertex(consumer, pose, normal, r, 0, r, 1, 0, 0, 0, 1, light);
        addVertex(consumer, pose, normal, r, length, r, 1, 1, 0, 0, 1, light);
        addVertex(consumer, pose, normal, -r, length, r, 0, 1, 0, 0, 1, light);
        
        // --- Side 2 (Back: Z-) ---
        // Normal: (0, 0, -1)
        addVertex(consumer, pose, normal, r, 0, -r, 0, 0, 0, 0, -1, light);
        addVertex(consumer, pose, normal, -r, 0, -r, 1, 0, 0, 0, -1, light);
        addVertex(consumer, pose, normal, -r, length, -r, 1, 1, 0, 0, -1, light);
        addVertex(consumer, pose, normal, r, length, -r, 0, 1, 0, 0, -1, light);
        
        // --- Side 3 (Left: X-) ---
        // Normal: (-1, 0, 0)
        addVertex(consumer, pose, normal, -r, 0, -r, 0, 0, -1, 0, 0, light);
        addVertex(consumer, pose, normal, -r, 0, r, 1, 0, -1, 0, 0, light);
        addVertex(consumer, pose, normal, -r, length, r, 1, 1, -1, 0, 0, light);
        addVertex(consumer, pose, normal, -r, length, -r, 0, 1, -1, 0, 0, light);
        
        // --- Side 4 (Right: X+) ---
        // Normal: (1, 0, 0)
        addVertex(consumer, pose, normal, r, 0, r, 0, 0, 1, 0, 0, light);
        addVertex(consumer, pose, normal, r, 0, -r, 1, 0, 1, 0, 0, light);
        addVertex(consumer, pose, normal, r, length, -r, 1, 1, 1, 0, 0, light);
        addVertex(consumer, pose, normal, r, length, r, 0, 1, 1, 0, 0, light);
        
        poseStack.method_22909();
    }
    
    private static void addVertex(class_4588 consumer, Matrix4f pose, Matrix3f normalMatrix,
                                  float x, float y, float z, float u, float v,
                                  float nx, float ny, float nz, int light) {
        
        var n = new Vector3f(nx, ny, nz);
        n.mul(normalMatrix);
        
        consumer.method_22918(pose, x, y, z)
          .method_1336(50, 50, 50, 255)
          .method_22913(u, v)
          .method_22922(class_4608.field_21444)
          .method_60803(light)
          .method_22914(n.x, n.y, n.z);
    }
}