package rearth.oritech.block.entity.pipes;

import com.google.common.collect.Streams;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.blocks.pipes.ExtractablePipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeConnectionBlock;
import rearth.oritech.init.BlockEntitiesContent;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class FluidPipeInterfaceEntity extends ExtractablePipeInterfaceEntity {
    
    public static final int MAX_TRANSFER_RATE = (int) (FluidStackHooks.bucketAmount() * Oritech.CONFIG.fluidPipeExtractAmountBuckets());
    private static final int TRANSFER_PERIOD = Oritech.CONFIG.fluidPipeExtractIntervalDuration();
    
    private List<FluidApi.FluidStorage> filteredFluidTargetsCached;
    
    public FluidPipeInterfaceEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.FLUID_PIPE_ENTITY, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, GenericPipeInterfaceEntity blockEntity) {
        var block = (ExtractablePipeConnectionBlock) state.method_26204();
        if (world.field_9236 || !block.isExtractable(state)) return;
        
        var boosted = isBoostAvailable();
        
        // boosted pipe works every tick, otherwise only every N tick
        if (world.method_8510() % TRANSFER_PERIOD != 0 && !boosted)
            return;
        
        var data = FluidPipeBlock.FLUID_PIPE_DATA.getOrDefault(world.method_27983().method_29177(), new PipeNetworkData());
        var transferAmount = boosted ? MAX_TRANSFER_RATE * 100 : MAX_TRANSFER_RATE;
        
        // try to get fluid to transfer
        // one transaction for each side
        var stackToMove = FluidStack.empty();
        FluidApi.FluidStorage takenFrom = null;
        var sources = data.machineInterfaces.getOrDefault(pos, new HashSet<>());
        
        for (var sourcePos : sources) {
            var offset = pos.method_10059(sourcePos);
            var direction = class_2350.method_50026(offset.method_10263(), offset.method_10264(), offset.method_10260());
            if (!block.isSideExtractable(state, direction.method_10153())) continue;
            
            var sourceBlock = world.method_8320(sourcePos);
            
            if (sourceBlock.method_26164(class_3481.field_26985))
                transferAmount = (int) FluidStackHooks.bucketAmount();
            
            var sourceContainer = FluidApi.BLOCK.find(world, sourcePos, sourceBlock, null, direction);
            if (sourceContainer == null || !sourceContainer.supportsExtraction()) continue;
            
            var contents = sourceContainer.getContent();
            var extractionCandidate = Streams.stream(contents)
                                        .filter(candidate -> !candidate.isEmpty())
                                        .filter(candidate -> sourceContainer.extract(candidate, true) > 0)
                                        .findFirst();
            
            if (extractionCandidate.isPresent()) {
                var extractionTest = extractionCandidate.get().copyWithAmount(transferAmount);
                var movedAmount = sourceContainer.extract(extractionTest, true);
                stackToMove = extractionTest;
                stackToMove.setAmount(movedAmount);
                takenFrom = sourceContainer;
                break;
            }
        }
        
        // if one (or more) of connected blocks has fluid available (of first found type, only transfer one type per tick)
        // gather all connection targets supporting insertion
        // shuffle em
        // insert until no more fluid to output is available
        if (stackToMove.isEmpty() || takenFrom == null) return;
        
        var targets = findNetworkTargets(pos, data);
        
        if (targets == null) {
            System.err.println("Yeah your pipe network likely is too long. At: " + this.method_11016());
            return;
        }
        
        var netHash = targets.hashCode();
        
        if (netHash != filteredTargetsNetHash || filteredFluidTargetsCached == null) {
            filteredFluidTargetsCached = targets.stream()
                                           .filter(target -> {
                                               var direction = target.method_15441();
                                               var pipePos = target.method_15442().method_10081(direction.method_10163());
                                               var pipeState = world.method_8320(pipePos);
                                               if (!(pipeState.method_26204() instanceof FluidPipeConnectionBlock fluidBlock))
                                                   return true;   // edge case, this should never happen
                                               var extracting = fluidBlock.isSideExtractable(pipeState, target.method_15441().method_10153());
                                               return !extracting;
                                           })
                                           .map(target -> FluidApi.BLOCK.find(world, target.method_15442(), target.method_15441()))
                                           .filter(obj -> Objects.nonNull(obj) && obj.supportsInsertion())
                                           .collect(Collectors.toList());
            
            filteredTargetsNetHash = netHash;
        }
        
        Collections.shuffle(filteredFluidTargetsCached);
        
        var availableFluid = stackToMove.getAmount();
        
        for (var targetStorage : filteredFluidTargetsCached) {
            
            var maxInsert = targetStorage.insert(stackToMove, true);
            var taken = takenFrom.extract(stackToMove.copyWithAmount(maxInsert), false);
            var inserted = targetStorage.insert(stackToMove.copyWithAmount(taken), false);
            
            stackToMove.shrink(inserted);
            targetStorage.update();
            
            if (stackToMove.getAmount() <= 0) break;
        }
        
        var moved = availableFluid - stackToMove.getAmount();
        if (moved > 0) {
            stackToMove.setAmount(moved);
            onBoostUsed();
            takenFrom.update();
        }
        
    }
}
