package rearth.oritech.block.entity.accelerator;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.init.BlockEntitiesContent;

import static rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity.getOutputPosition;

import net.minecraft.class_1937;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5558;
import net.minecraft.class_7225;

public class ParticleCollectorBlockEntity extends class_2586 implements class_5558<ParticleCollectorBlockEntity>, EnergyApi.BlockProvider {
    
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.collectorEnergyStorage(), 0, Oritech.CONFIG.collectorEnergyStorage(), this::method_5431);
    
    public ParticleCollectorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PARTICLE_COLLECTOR_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(@Nullable class_2350 direction) {
        return energyStorage;
    }
    
    public void onParticleCollided() {
        onParticleCollided(Oritech.CONFIG.blackHoleTachyonEnergy());
    }
    
    public void onParticleCollided(int amount) {
        energyStorage.amount = Math.min(energyStorage.capacity, energyStorage.amount + amount);
        energyStorage.update();
        triggerAnimation();
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, ParticleCollectorBlockEntity blockEntity) {
        if (world.field_9236) return;
        
        
        if (energyStorage.amount <= 0) return;
        
        // output energy to back
        var target = getOutputPosition(pos, method_11010().method_11654(class_2318.field_10927).method_10153());
        var candidate = EnergyApi.BLOCK.find(world, target.method_15441(), target.method_15442());
        if (candidate != null) {
            EnergyApi.transfer(energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("energy", energyStorage.getAmount());
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        energyStorage.setAmount(nbt.method_10537("energy"));
    }
    
    public void triggerAnimation() {
        if (field_11863 instanceof class_3218 serverLevel) {
            var forward = method_11010().method_11654(class_2318.field_10927).method_10163();
            var at = field_11867.method_46558().method_1019(class_243.method_24953(forward));
            serverLevel.method_14199(class_2398.field_11227, at.field_1352, at.field_1351, at.field_1350, 2, field_11863.field_9229.method_43057(), field_11863.field_9229.method_43057(), field_11863.field_9229.method_43057(), 0.15f);
        }
    }
}
