package rearth.oritech.block.blocks.reactor;

import org.jetbrains.annotations.Nullable;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3965;

public class ReactorRedstonePortBlock extends BaseReactorBlock {
    
    public static final class_2758 PORT_MODE = class_2758.method_11867("port_mode", 0, 2);  // 0 = temperature, 1 = fuel, 2 = power
    
    public ReactorRedstonePortBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(class_2741.field_12525, class_2350.field_11043).method_11657(PORT_MODE, 0).method_11657(class_2741.field_12511, 0));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(class_2741.field_12525);
        builder.method_11667(PORT_MODE);
        builder.method_11667(class_2741.field_12511);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12525, ctx.method_7715().method_10153());
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (world.field_9236) return class_1269.field_5812;
        
        var lastMode = state.method_11654(PORT_MODE);
        var cycledMode = (lastMode + 1) % 3;
        
        player.method_43496(class_2561.method_43471("tooltip.oritech.reactor_port_mode." + cycledMode));
        
        var newState = state.method_11657(PORT_MODE, cycledMode);
        world.method_8501(pos, newState);
        
        return class_1269.field_5812;
        
    }
    
    @Override
    protected boolean method_9498(class_2680 state) {
        return true;
    }
    
    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11654(class_2741.field_12511);
    }
    
    @Override
    public boolean validForWalls() {
        return true;
    }
}
