package rearth.oritech.block.blocks.pipes;

import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.item.tools.Wrench;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_9062;

public abstract class GenericPipeBlock extends AbstractPipeBlock implements Wrench.Wrenchable, class_3737 {
    
    // 0 = no connection, 1 = connection (pipe->pipe or pipe->machine)
    public static int NO_CONNECTION = 0;
    public static int CONNECTION = 1;
    
    public static final class_2758 NORTH = class_2758.method_11867("north", 0, 1);
    public static final class_2758 EAST = class_2758.method_11867("east", 0, 1);
    public static final class_2758 SOUTH = class_2758.method_11867("south", 0, 1);
    public static final class_2758 WEST = class_2758.method_11867("west", 0, 1);
    public static final class_2758 UP = class_2758.method_11867("up", 0, 1);
    public static final class_2758 DOWN = class_2758.method_11867("down", 0, 1);
    public static final class_2746 STRAIGHT = class_2746.method_11825("straight");
    
    public static final class_265[] THICK_SHAPES = createShapes(
      class_2248.method_9541(5, 5, 5, 11, 11, 11),
      class_2248.method_9541(5, 5, 0, 11, 11, 5),
      class_2248.method_9541(11, 5, 5, 16, 11, 11),
      class_2248.method_9541(5, 5, 11, 11, 11, 16),
      class_2248.method_9541(0, 5, 5, 5, 11, 11),
      class_2248.method_9541(5, 11, 5, 11, 16, 11),
      class_2248.method_9541(5, 0, 5, 11, 5, 11)
    );
    public static final class_265[] EXTRA_THICK_SHAPES = createShapes(
      class_2248.method_9541(4, 4, 4, 12, 12, 12),
      class_2248.method_9541(4, 4, 0, 12, 12, 4),
      class_2248.method_9541(12, 4, 4, 16, 12, 12),
      class_2248.method_9541(4, 4, 12, 12, 12, 16),
      class_2248.method_9541(0, 4, 4, 4, 12, 12),
      class_2248.method_9541(4, 12, 4, 12, 16, 12),
      class_2248.method_9541(4, 0, 4, 12, 4, 12)
    );
    public static final class_265[] THIN_SHAPES = createShapes(
      class_2248.method_9541(6, 6, 6, 10, 10, 10),
      class_2248.method_9541(6, 6, 0, 10, 10, 6),
      class_2248.method_9541(10, 6, 6, 16, 10, 10),
      class_2248.method_9541(6, 6, 10, 10, 10, 16),
      class_2248.method_9541(0, 6, 6, 6, 10, 10),
      class_2248.method_9541(6, 10, 6, 10, 16, 10),
      class_2248.method_9541(6, 0, 6, 10, 6, 10)
    );
    
    public GenericPipeBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564()
                                    .method_11657(getNorthProperty(), 0)
                                    .method_11657(getEastProperty(), 0)
                                    .method_11657(getSouthProperty(), 0)
                                    .method_11657(getWestProperty(), 0)
                                    .method_11657(getUpProperty(), 0)
                                    .method_11657(getDownProperty(), 0)
                                    .method_11657(STRAIGHT, false)
                                    .method_11657(class_2741.field_12508, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(getNorthProperty(), getEastProperty(), getSouthProperty(), getWestProperty(), getUpProperty(), getDownProperty(), STRAIGHT, class_2741.field_12508);
    }
    
    protected class_265 getShape(class_2680 state) {
        return boundingShapes[packStates(state)];
    }
    
    protected class_265[] createShapes() {
        return THICK_SHAPES;
    }
    
    public static class_265[] createShapes(class_265 inner, class_265 north, class_265 east, class_265 south, class_265 west, class_265 up, class_265 down) {
        class_265[] shapes = new class_265[64];
        
        for (int i = 0; i <= 63; i++) {
            class_265 shape = inner;
            if ((i & 1) != 0) shape = class_259.method_1082(shape, north, class_247.field_1366);
            if ((i & 2) != 0) shape = class_259.method_1082(shape, east, class_247.field_1366);
            if ((i & 4) != 0) shape = class_259.method_1082(shape, south, class_247.field_1366);
            if ((i & 8) != 0) shape = class_259.method_1082(shape, west, class_247.field_1366);
            if ((i & 16) != 0) shape = class_259.method_1082(shape, up, class_247.field_1366);
            if ((i & 32) != 0) shape = class_259.method_1082(shape, down, class_247.field_1366);
            shapes[i] = shape.method_1097();
        }
        
        return shapes;
    }
    
    private int packStates(class_2680 state) {
        int i = 0;
        if (state.method_11654(getNorthProperty()) != NO_CONNECTION) i |= 1;
        if (state.method_11654(getEastProperty()) != NO_CONNECTION) i |= 2;
        if (state.method_11654(getSouthProperty()) != NO_CONNECTION) i |= 4;
        if (state.method_11654(getWestProperty()) != NO_CONNECTION) i |= 8;
        if (state.method_11654(getUpProperty()) != NO_CONNECTION) i |= 16;
        if (state.method_11654(getDownProperty()) != NO_CONNECTION) i |= 32;
        return i;
    }
    
    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_26204().equals(state.method_26204())) return;
        else if (oldState.method_27852(getConnectionBlock().method_26204())) {
            GenericPipeInterfaceEntity.addNode(world, pos, false, state, getNetworkData(world));
            return;
        }
        
        // transform to interface block on placement when machine is neighbor
        if (hasNeighboringMachine(state, world, pos, true)) {
            var connectionBlock = getConnectionBlock();
            var interfaceState = ((GenericPipeBlock) connectionBlock.method_26204()).addConnectionStates(connectionBlock, world, pos, true);
            world.method_8501(pos, interfaceState);
        } else {
            // no states need to be added (see getPlacementState)
            GenericPipeInterfaceEntity.addNode(world, pos, false, state, getNetworkData(world));
        }
        
        updateNeighbors(world, pos, false);
    }
    
    // also known as 'getStateForNeighborUpdate'
    @Override
    public @NotNull class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 worldAccess, class_2338 pos, class_2338 neighborPos) {
        var world = (class_1937) worldAccess;
        if (world.field_9236) return state;
        
        if (state.method_11654(class_2741.field_12508))
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        
        // transform to interface when machine is placed as neighbor
        if (hasMachineInDirection(direction, world, pos, apiValidationFunction())) {
            // Only update if the neighbor is a new machine
            var hasMachine = getNetworkData(world).machinePipeNeighbors.getOrDefault(neighborPos, HashSet.newHashSet(0)).contains(direction.method_10153());
            if (hasMachine) return state;
            
            var connectionBlock = getConnectionBlock();
            return ((GenericPipeBlock) connectionBlock.method_26204()).addConnectionStates(connectionBlock, world, pos, direction);
        } else if (neighborState.method_27852(class_2246.field_10124))
            // remove potential stale machine -> neighboring pipes mapping
            getNetworkData(world).machinePipeNeighbors.remove(neighborPos);
        
        return state;
    }
    
    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        
        if (!state.method_27852(newState.method_26204()) && !(newState.method_26204() instanceof GenericPipeBlock)) {
            // block was removed/replaced instead of updated
            onBlockRemoved(pos, state, world);
        }
        
    }
    
    @Override
    protected @NotNull class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }
    
    /**
     * Updates all the neighboring pipes of the target position.
     *
     * @param world           The target world
     * @param pos             The target position
     * @param neighborToggled Whether the neighbor was toggled
     */
    public void updateNeighbors(class_1937 world, class_2338 pos, boolean neighborToggled) {
        for (var direction : class_2350.values()) {
            var neighborPos = pos.method_10093(direction);
            var neighborState = world.method_8320(neighborPos);
            // Only update pipes
            if (neighborState.method_26204() instanceof AbstractPipeBlock pipeBlock) {
                var updatedState = pipeBlock.addConnectionStates(neighborState, world, neighborPos, false);
                world.method_8501(neighborPos, updatedState);
                
                // Update network data if the state was changed
                if (!neighborState.equals(updatedState) || pipeBlock instanceof GenericPipeDuctBlock) {
                    boolean interfaceBlock = updatedState.method_27852(getConnectionBlock().method_26204());
                    if (neighborToggled)
                        GenericPipeInterfaceEntity.addNode(world, neighborPos, interfaceBlock, updatedState, getNetworkData(world));
                }
            }
        }
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!player.method_7337() && !world.field_9236) {
            onBlockRemoved(pos, state, world);
        }
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    protected @NotNull class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        
        if (!level.method_8608() && stack.method_31573(TagContent.WRENCHES) && !stack.method_31574(ItemContent.WRENCH)) {
            this.onWrenchUse(state, level, pos, player, hand);
            return class_9062.field_47728;
        }
        
        return super.method_55765(stack, state, level, pos, player, hand, hitResult);
    }
    
    @Override
    public class_1269 onWrenchUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            this.method_9576(world, pos, state, player);
            world.method_8651(pos, true, player);
            return class_1269.field_5812;
        }
        
        return toggleSideConnection(state, getInteractDirection(state, pos, player), world, pos) ? class_1269.field_5812 : class_1269.field_5814;
    }
    
    @Override
    public class_1269 onWrenchUseNeighbor(class_2680 state, class_2680 neighborState, class_1937 world, class_2338 pos, class_2338 neighborPos, class_2350 neighborFace, class_1657 player, class_1268 hand) {
        return toggleSideConnection(state, neighborFace.method_10153(), world, pos) ? class_1269.field_5812 : class_1269.field_5814;
    }
    
    protected class_2350 getInteractDirection(class_2680 state, class_2338 pos, class_1657 player) {
        var shapes = getActiveShapes(state);
        var start = player.method_5836(0f);
        var end = start.method_1019(player.method_5828(0).method_1021(5));
        
        var targetShape = shapes.getFirst();
        var distance = Double.MAX_VALUE;
        var hitPos = class_243.field_1353;
        for (var shape : shapes) {
            var hitResult = shape.method_1092(start, end, pos);
            if (hitResult == null) continue;
            
            // skip center if we already matched one of the outer ones
            if (shape.equals(shapes.getLast()) && distance < Double.MAX_VALUE) continue;
            
            var shapeDistance = hitResult.method_17784().method_1022(start);
            if (shapeDistance < distance) {
                distance = shapeDistance;
                targetShape = shape;
                hitPos = hitResult.method_17784();
            }
        }
        
        var center = targetShape.method_1107().method_1005();
        var diff = center.method_1020(new class_243(0.5, 0.5, 0.5));
        if (diff.equals(class_243.field_1353))
            // center hit
            diff = hitPos.method_1020(center.method_1019(class_243.method_24954(pos)));
        
        return class_2350.method_10142(diff.field_1352, diff.field_1351, diff.field_1350);
    }
    
    // only returns the outside shapes
    private List<class_265> getActiveShapes(class_2680 state) {
        
        var shapes = new ArrayList<class_265>();
        if (state.method_11654(getNorthProperty()) != NO_CONNECTION)
            shapes.add(class_2248.method_9541(5, 5, 0, 11, 11, 5));
        if (state.method_11654(getEastProperty()) != NO_CONNECTION)
            shapes.add(class_2248.method_9541(11, 5, 5, 16, 11, 11));
        if (state.method_11654(getSouthProperty()) != NO_CONNECTION)
            shapes.add(class_2248.method_9541(5, 5, 11, 11, 11, 16));
        if (state.method_11654(getWestProperty()) != NO_CONNECTION)
            shapes.add(class_2248.method_9541(0, 5, 5, 5, 11, 11));
        if (state.method_11654(getUpProperty()) != NO_CONNECTION)
            shapes.add(class_2248.method_9541(5, 11, 5, 11, 16, 11));
        if (state.method_11654(getDownProperty()) != NO_CONNECTION)
            shapes.add(class_2248.method_9541(5, 0, 5, 11, 5, 11));
        
        shapes.add(class_2248.method_9541(5, 5, 5, 11, 11, 11));
        
        return shapes;
    }
    
    /**
     * Toggles the connection state of a pipe side between disabled and enabled.
     *
     * @param state The current pipe block-state
     * @param side  The side to toggle the connection state
     * @param world The target world
     * @param pos   The target pipe position
     */
    protected boolean toggleSideConnection(class_2680 state, class_2350 side, class_1937 world, class_2338 pos) {
        var property = directionToProperty(side);
        var createConnection = state.method_11654(property) == NO_CONNECTION;
        
        // check if connection would be valid if state is toggled
        var targetPos = pos.method_10093(side);
        if (createConnection && !isValidConnectionTarget(world.method_8320(targetPos).method_26204(), world, side.method_10153(), targetPos))
            return false;
        
        // toggle connection state
        int nextConnectionState = getNextConnectionState(state, side, world, pos, state.method_11654(property));
        var newState = addStraightState(state.method_11657(property, nextConnectionState));
        
        // transform to interface block if side is being enabled and machine is connected
        if (!newState.method_27852(getConnectionBlock().method_26204()) && createConnection && hasMachineInDirection(side, world, pos, apiValidationFunction())) {
            var connectionState = getConnectionBlock();
            var interfaceState = ((GenericPipeBlock) connectionState.method_26204()).addConnectionStates(connectionState, world, pos, side);
            interfaceState = addFluidState(interfaceState, pos, world);
            world.method_8501(pos, interfaceState);
        } else {
            world.method_8501(pos, newState);
            GenericPipeInterfaceEntity.addNode(world, pos, false, newState, getNetworkData(world));
            
            // update neighbor if it's a pipe
            updateNeighbors(world, pos, true);
        }
        
        // play sound
        var soundGroup = method_9573(state);
        world.method_8396(null, pos, soundGroup.method_10598(), class_3419.field_15245, soundGroup.method_10597() * .5f, soundGroup.method_10599());
        
        return true;
    }
    
    /**
     * Adds the connection states to the pipe block-state.
     *
     * @param state            The current pipe block-state
     * @param world            The target world
     * @param pos              The target pipe position
     * @param createConnection Whether to create a connection
     * @return The updated block-state
     */
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, boolean createConnection) {
        
        state = addFluidState(state, pos, world);
        
        for (var direction : class_2350.values()) {
            var property = directionToProperty(direction);
            var connection = shouldConnect(state, direction, pos, world, createConnection);
            state = state.method_11657(property, connection ? CONNECTION : NO_CONNECTION);
        }
        
        return addStraightState(state);
    }
    
    /**
     * Adds the connection states to the pipe block-state.
     * Attempts to create a connection ONLY in the specified direction.
     * Useful for when only one connection needs to be created.
     *
     * @param state           The current pipe block-state
     * @param world           The target world
     * @param pos             The target pipe position
     * @param createDirection The direction to create a connection in
     * @return The updated block-state
     */
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, class_2350 createDirection) {
        for (var direction : class_2350.values()) {
            var property = directionToProperty(direction);
            var connection = shouldConnect(state, direction, pos, world, direction.equals(createDirection));
            state = state.method_11657(property, connection ? CONNECTION : NO_CONNECTION);
        }
        return addFluidState(addStraightState(state), pos, world);
    }
    
    /**
     * Adds the straight property to the pipe block-state.
     *
     * @param state The current pipe block-state
     * @return The updated block-state
     */
    public class_2680 addStraightState(class_2680 state) {
        var north = state.method_11654(getNorthProperty()) != NO_CONNECTION;
        var south = state.method_11654(getSouthProperty()) != NO_CONNECTION;
        var east = state.method_11654(getEastProperty()) != NO_CONNECTION;
        var west = state.method_11654(getWestProperty()) != NO_CONNECTION;
        var up = state.method_11654(getUpProperty()) != NO_CONNECTION;
        var down = state.method_11654(getDownProperty()) != NO_CONNECTION;
        
        // Check for straight connections along each axis
        boolean straightX = north && south && !east && !west && !up && !down;
        boolean straightY = up && down && !north && !south && !east && !west;
        boolean straightZ = east && west && !north && !south && !up && !down;
        
        // The pipe is straight if exactly one of the axes has a straight connection
        var straight = straightX || straightY || straightZ;
        
        return state.method_11657(STRAIGHT, straight);
    }
    
    /**
     * Check if the pipe should connect in a specific direction.
     *
     * @param current          The current pipe block-state
     * @param direction        The direction to check
     * @param currentPos       The current pipe position
     * @param world            The target world
     * @param createConnection Whether to create a connection
     * @return Boolean whether the pipe should connect
     */
    public boolean shouldConnect(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection) {
        var targetPos = currentPos.method_10093(direction);
        var targetState = world.method_8320(targetPos);
        
        // If creating a connection we don't check the other pipe's connection state, force the connection
        // Otherwise we check if the other pipe is connecting in the opposite direction
        if (createConnection) {
            return isValidConnectionTarget(targetState.method_26204(), world, direction.method_10153(), targetPos);
        } else if (targetState.method_26204() instanceof AbstractPipeBlock pipeBlock) {
            return pipeBlock.isConnectingInDirection(targetState, direction.method_10153(), targetPos, world, false);
        } else
            return isConnectingInDirection(current, direction, currentPos, world, false) && isValidInterfaceTarget(targetState.method_26204(), world, direction.method_10153(), targetPos);
    }
    
    /**
     * Check if the pipe is connecting in a specific direction.
     *
     * @param current          The target pipe block-state
     * @param direction        The direction to check
     * @param createConnection Whether to create a connection
     * @return Boolean whether the pipe is connecting
     */
    public boolean isConnectingInDirection(class_2680 current, class_2350 direction, class_2338 currentPos, class_1937 world, boolean createConnection) {
        var block = current.method_26204();
        if (!(block instanceof GenericPipeBlock pipeBlock)) return false;
        var property = pipeBlock.directionToProperty(direction);
        return current.method_11654(property) >= CONNECTION || createConnection && current.method_11654(property) == NO_CONNECTION;
    }
    
    /**
     * Converts a {@link class_2350} into an IntProperty value for a connection
     *
     * @param state     State to pull the value from
     * @param direction Respective direction
     * @return the connection value
     */
    public int directionToPropertyValue(class_2680 state, class_2350 direction) {
        if (direction == class_2350.field_11043)
            return state.method_11654(getNorthProperty());
        else if (direction == class_2350.field_11034)
            return state.method_11654(getEastProperty());
        else if (direction == class_2350.field_11035)
            return state.method_11654(getSouthProperty());
        else if (direction == class_2350.field_11039)
            return state.method_11654(getWestProperty());
        else if (direction == class_2350.field_11036)
            return state.method_11654(getUpProperty());
        else return state.method_11654(getDownProperty());
    }
    
    /**
     * Converts a {@link class_2350} into a {@link class_2758} for a connection
     *
     * @param direction Respective direction
     * @return the property
     */
    public class_2758 directionToProperty(class_2350 direction) {
        if (direction == class_2350.field_11043)
            return getNorthProperty();
        else if (direction == class_2350.field_11034)
            return getEastProperty();
        else if (direction == class_2350.field_11035)
            return getSouthProperty();
        else if (direction == class_2350.field_11039)
            return getWestProperty();
        else if (direction == class_2350.field_11036)
            return getUpProperty();
        else return getDownProperty();
    }
    
    protected int getNextConnectionState(class_2680 state, class_2350 side, class_1937 world, class_2338 pos, int current) {
        return current == NO_CONNECTION ? CONNECTION : NO_CONNECTION;
    }
    
    protected void onBlockRemoved(class_2338 pos, class_2680 oldState, class_1937 world) {
        updateNeighbors(world, pos, false);
        GenericPipeInterfaceEntity.removeNode(world, pos, false, oldState, getNetworkData(world));
    }
    
    @Override
    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }
    
    /*
     * The following is a hacky implementation to allow child classes to modify the connection properties
     */
    
    public class_2758 getNorthProperty() {
        return NORTH;
    }
    
    public class_2758 getEastProperty() {
        return EAST;
    }
    
    public class_2758 getSouthProperty() {
        return SOUTH;
    }
    
    public class_2758 getWestProperty() {
        return WEST;
    }
    
    public class_2758 getUpProperty() {
        return UP;
    }
    
    public class_2758 getDownProperty() {
        return DOWN;
    }
}
