package rearth.oritech.block.blocks.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.TooltipHelper;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5558;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.util.TooltipHelper.addMachineTooltip;

public class PowerPoleBlock extends class_2248 implements class_2343 {
    
    public PowerPoleBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(ASSEMBLED, false).method_11657(class_2741.field_12481, class_2350.field_11043));
    }
    
    @Override
    protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ASSEMBLED, class_2741.field_12481);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12481, ctx.method_8042().method_10170().method_10153());
    }
    
    @Override
    public @NotNull class_1269 method_55766(@NotNull class_2680 state, class_1937 world, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            
            if (!(entity instanceof PowerPoleEntity powerPole)) {
                return class_1269.field_5812;
            }
            
            var wasAssembled = state.method_11654(ASSEMBLED);
            
            if (!wasAssembled) {
                var corePlaced = powerPole.tryPlaceNextCore(player);
                if (corePlaced) return class_1269.field_5812;
            }
            
            var isAssembled = powerPole.initMultiblock(state);
            
            // first time created
            if (isAssembled && !wasAssembled) {
                powerPole.triggerSetupAnimation();
                return class_1269.field_5812;
            }
            
            if (!isAssembled) {
                player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
                return class_1269.field_5812;
            }
            
            var handler = (ExtendedMenuProvider) world.method_8321(pos);
            MenuRegistry.openExtendedMenu((class_3222) player, handler);
            
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    public @NotNull class_2680 method_9576(class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1657 player) {
        
        if (!world.method_8608() && state.method_11654(ASSEMBLED)) {
            
            var entity = world.method_8321(pos);
            if (entity instanceof MultiblockMachineController machineEntity) {
                machineEntity.onControllerBroken();
            }
            
            if (entity instanceof PowerPoleEntity poleBlock) {
                poleBlock.onRemoved();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    public @NotNull class_2464 method_9604(@NotNull class_2680 state) {
        return class_2464.field_11458;
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new PowerPoleEntity(pos, state);
    }
    
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public void method_9568(@NotNull class_1799 stack, class_1792.@NotNull class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        var showExtra = class_437.method_25441();
        
        if (!showExtra)
            tooltip.add(class_2561.method_43471("tooltip.oritech.power_pole.short").method_27692(class_124.field_1080));
        
        addMachineTooltip(tooltip, this, this);
        
        if (showExtra) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.power_pole.1").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("tooltip.oritech.power_pole.2").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43469("tooltip.oritech.power_pole.3", Oritech.CONFIG.poleConfig.minRange(), Oritech.CONFIG.poleConfig.maxRange(), TooltipHelper.getEnergyText(Oritech.CONFIG.poleConfig.energyCapacity())).method_27692(class_124.field_1080));
        }
    }
}
