package rearth.oritech.block.blocks.interaction;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.init.TagContent;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3726;

public class MachineFrameBlock extends class_2248 {
    
    private static final Boolean USE_ACCURATE_OUTLINES = Oritech.CONFIG.tightMachineFrameHitboxes();
    
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;      // south and west are only needed for voxel shapes
    public static final class_2746 WEST = class_2429.field_11328;
    public static final class_2746 UP = class_2429.field_11327;
    public static final class_2746 DOWN = class_2429.field_11330;        // used to connect to pillars to make things look nice
    
    protected final class_265[] boundingShapes;
    
    public MachineFrameBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(NORTH, false).method_11657(EAST, false).method_11657(SOUTH, false).method_11657(WEST, false).method_11657(UP, false).method_11657(DOWN, false));
        boundingShapes = createShapes();
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add(class_2561.method_43471("tooltip.oritech.machine_frame").method_27695(class_124.field_1080, class_124.field_1056));
        tooltip.add(class_2561.method_43469("tooltip.oritech.machine_frame.1", Oritech.CONFIG.processingMachines.machineFrameMaxLength(), Oritech.CONFIG.processingMachines.machineFrameMaxLength()).method_27692(class_124.field_1080));
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
    
    private class_265 getShape(class_2680 state) {
        return boundingShapes[packStates(state)];
    }
    
    private static int packStates(class_2680 state) {
        int i = 0;
        if (state.method_11654(NORTH)) i |= 1;
        if (state.method_11654(EAST)) i |= 2;
        if (state.method_11654(SOUTH)) i |= 4;
        if (state.method_11654(WEST)) i |= 8;
        if (state.method_11654(UP)) i |= 16;
        if (state.method_11654(DOWN)) i |= 32;
        return i;
    }
    
    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (!USE_ACCURATE_OUTLINES)
            return super.method_9530(state, world, pos, context);
        return getShape(state);
    }
    
    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return getShape(state);
    }
    
    protected class_265[] createShapes() {
        return GenericPipeBlock.createShapes(
          class_2248.method_9541(5, 5, 5, 11, 11, 11),
          class_2248.method_9541(5, 5, 0, 11, 11, 5),
          class_2248.method_9541(11, 5, 5, 16, 11, 11),
          class_2248.method_9541(5, 5, 11, 11, 11, 16),
          class_2248.method_9541(0, 5, 5, 5, 11, 11),
          class_2248.method_9541(5, 5, 5, 11, 16, 11),
          class_2248.method_9541(5, 0, 5, 11, 5, 11)
        );
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        var baseState = super.method_9605(ctx);
        
        var northConnected = ctx.method_8045().method_8320(ctx.method_8037().method_10095()).method_26204() == this;
        var eastConnected = ctx.method_8045().method_8320(ctx.method_8037().method_10078()).method_26204() == this;
        var southConnected = ctx.method_8045().method_8320(ctx.method_8037().method_10072()).method_26204() == this;
        var westConnected = ctx.method_8045().method_8320(ctx.method_8037().method_10067()).method_26204() == this;
        var upConnected = ctx.method_8045().method_8320(ctx.method_8037().method_10084()).method_26164(TagContent.MACHINE_FRAME_SUPPORT);
        var downConnected = ctx.method_8045().method_8320(ctx.method_8037().method_10074()).method_26164(TagContent.MACHINE_FRAME_SUPPORT);
        
        return Objects.requireNonNull(baseState).method_11657(NORTH, northConnected).method_11657(EAST, eastConnected).method_11657(SOUTH, southConnected).method_11657(WEST, westConnected).method_11657(UP, upConnected).method_11657(DOWN, downConnected);
    }
    
    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        
        var northConnected = world.method_8320(pos.method_10095()).method_26204() == this;
        var eastConnected = world.method_8320(pos.method_10078()).method_26204() == this;
        var southConnected = world.method_8320(pos.method_10072()).method_26204() == this;
        var westConnected = world.method_8320(pos.method_10067()).method_26204() == this;
        var upConnected = world.method_8320(pos.method_10084()).method_26164(TagContent.MACHINE_FRAME_SUPPORT);
        var downConnected = world.method_8320(pos.method_10074()).method_26164(TagContent.MACHINE_FRAME_SUPPORT);
        
        return state.method_11657(NORTH, northConnected).method_11657(EAST, eastConnected).method_11657(SOUTH, southConnected).method_11657(WEST, westConnected).method_11657(UP, upConnected).method_11657(DOWN, downConnected);
        
    }
}
