package rearth.oritech.block.blocks.interaction;

import dev.architectury.registry.menu.MenuRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.behavior.LaserArmBlockBehavior;
import rearth.oritech.block.behavior.LaserArmEntityBehavior;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;

import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.util.TooltipHelper.addMachineTooltip;


public class LaserArmBlock extends class_2248 implements class_2343 {

    private static final LaserArmBlockBehavior DEFAULT_BLOCK_BEHAVIOR = new LaserArmBlockBehavior();
    public static final Map<class_2248, LaserArmBlockBehavior> BLOCK_BEHAVIORS = new Object2ObjectOpenHashMap<>();
    private static final LaserArmEntityBehavior DEFAULT_ENTITY_BEHAVIOR = new LaserArmEntityBehavior();
    public static final Map<class_1299<?>, LaserArmEntityBehavior> ENTITY_BEHAVIORS = new Object2ObjectOpenHashMap<>();
    
    public LaserArmBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(ASSEMBLED, false).method_11657(class_2741.field_12525, class_2350.field_11036));
        LaserArmBlockBehavior.registerDefaults();
        LaserArmEntityBehavior.registerDefaults();
    }

    public static void registerBlockBehavior(class_2248 targetBlock, LaserArmBlockBehavior behavior) {
        BLOCK_BEHAVIORS.put(targetBlock, behavior);
    }

    public static void registerEntityBehavior(class_1299<?> entityType, LaserArmEntityBehavior behavior) {
        ENTITY_BEHAVIORS.put(entityType, behavior);
    }

    public static LaserArmBlockBehavior getBehaviorForBlock(class_2248 targetBlock) {
        return BLOCK_BEHAVIORS.getOrDefault(targetBlock, DEFAULT_BLOCK_BEHAVIOR);
    }

    public static LaserArmEntityBehavior getBehaviorForEntity(class_1299<?> targetEntityType) {
        return ENTITY_BEHAVIORS.getOrDefault(targetEntityType, DEFAULT_ENTITY_BEHAVIOR);
    }
    
    @Override
    public @Nullable class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12525, ctx.method_8038());
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ASSEMBLED);
        builder.method_11667(class_2741.field_12525);
    }
    
    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }
    
    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        
        if (world.field_9236) return;
        
        var isPowered = world.method_49803(pos);
        
        var laserEntity = (LaserArmBlockEntity) world.method_8321(pos);
        laserEntity.setRedstonePowered(isPowered);
        
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof LaserArmBlockEntity laserArm)) {
                return class_1269.field_5812;
            }
            
            var wasAssembled = state.method_11654(ASSEMBLED);
            
            if (!wasAssembled) {
                var corePlaced = laserArm.tryPlaceNextCore(player);
                if (corePlaced) return class_1269.field_5812;
            }
            
            var isAssembled = laserArm.initMultiblock(state);
            
            // first time created
            if (isAssembled && !wasAssembled) {
                laserArm.triggerSetupAnimation();
                laserArm.initAddons();
                return class_1269.field_5812;
            }
            
            if (!isAssembled) {
                player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
                return class_1269.field_5812;
            }
            
            laserArm.initAddons();
            MenuRegistry.openExtendedMenu((class_3222) player, laserArm);
            
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608()) {
            
            var entity = world.method_8321(pos);
            if (state.method_11654(ASSEMBLED) && entity instanceof MultiblockMachineController machineEntity) {
                machineEntity.onControllerBroken();
            }
            
            if (entity instanceof MachineAddonController machineEntity) {
                machineEntity.resetAddons();
            }
            
            if (entity instanceof LaserArmBlockEntity storageBlock) {
                var stacks = storageBlock.inventory.heldStacks;
                for (var heldStack : stacks) {
                    if (!heldStack.method_7960()) {
                        var itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), heldStack);
                        world.method_8649(itemEntity);
                    }
                }
                
                storageBlock.inventory.heldStacks.clear();
                storageBlock.inventory.method_5431();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LaserArmBlockEntity(pos, state);
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        addMachineTooltip(tooltip, this, this);
    }
}
