package rearth.oritech.api.recipe;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.init.recipes.AugmentDataRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.SizedIngredient;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8790;

public class AugmentRecipeBuilder {
    private final AugmentDataRecipeType type;
    private final String resourcePath;
    
    private boolean toggleable;
    
    private List<SizedIngredient> researchCosts;
    private List<SizedIngredient> applyCosts;
    private List<class_2960> requirements;
    private class_2960 requiredStation;
    private int uiX;
    private int uiY;
    private int time;
    private long rfCost;
    
    // 2 of these 3 should always be null
    private @Nullable AugmentDataRecipe.EffectDefinition effectDefinition;
    private @Nullable AugmentDataRecipe.ModifierDefinition modifierDefinition;
    private @Nullable AugmentDataRecipe.CustomAugmentDefinition customAugmentDefinition;
    
    private AugmentRecipeBuilder(AugmentDataRecipeType type, String resourcePath) {
        this.type = type;
        this.resourcePath = resourcePath;
    }
    
    public static AugmentRecipeBuilder build() {
        return new AugmentRecipeBuilder(RecipeContent.AUGMENT_DATA, "augment");
    }
    
    public AugmentRecipeBuilder researchCost(List<SizedIngredient> researchCosts) {
        if (this.researchCosts == null)
            this.researchCosts = new ArrayList<>();
        this.researchCosts.addAll(researchCosts);
        return this;
    }
    
    public AugmentRecipeBuilder researchCost(SizedIngredient researchCost) {
        if (this.researchCosts == null)
            this.researchCosts = new ArrayList<>();
        this.researchCosts.add(researchCost);
        return this;
    }
    
    public AugmentRecipeBuilder researchCost(class_1856 researchCost, int count) {
        return researchCost(new SizedIngredient(count, researchCost));
    }
    
    public AugmentRecipeBuilder researchCost(class_1856 researchCost) {
        return researchCost(researchCost, 1);
    }
    
    public AugmentRecipeBuilder researchCost(class_6862<class_1792> researchCostTag, int count) {
        return researchCost(class_1856.method_8106(researchCostTag), count);
    }
    
    public AugmentRecipeBuilder researchCost(class_6862<class_1792> researchCostTag) {
        return researchCost(researchCostTag, 1);
    }
    
    public AugmentRecipeBuilder researchCost(class_1935 researchCost, int count) {
        return researchCost(class_1856.method_8091(researchCost), count);
    }
    
    public AugmentRecipeBuilder researchCost(class_1935 researchCost) {
        return researchCost(researchCost, 1);
    }
    
    public AugmentRecipeBuilder applyCost(List<SizedIngredient> applyCost) {
        if (this.applyCosts == null)
            this.applyCosts = new ArrayList<>();
        this.applyCosts.addAll(applyCost);
        return this;
    }
    
    public AugmentRecipeBuilder applyCost(SizedIngredient applyCost) {
        if (this.applyCosts == null)
            this.applyCosts = new ArrayList<>();
        this.applyCosts.add(applyCost);
        return this;
    }
    
    public AugmentRecipeBuilder applyCost(class_1856 applyCost, int count) {
        return applyCost(new SizedIngredient(count, applyCost));
    }
    
    public AugmentRecipeBuilder applyCost(class_1856 applyCost) {
        return applyCost(applyCost, 1);
    }
    
    public AugmentRecipeBuilder applyCost(class_6862<class_1792> applyCostTag, int count) {
        return applyCost(class_1856.method_8106(applyCostTag), count);
    }
    
    public AugmentRecipeBuilder applyCost(class_6862<class_1792> applyCostTag) {
        return applyCost(applyCostTag, 1);
    }
    
    public AugmentRecipeBuilder applyCost(class_1935 applyCost, int count) {
        return applyCost(class_1856.method_8091(applyCost), count);
    }
    
    public AugmentRecipeBuilder applyCost(class_1935 applyCost) {
        return applyCost(applyCost, 1);
    }
    
    public AugmentRecipeBuilder requirement(List<class_2960> requirements) {
        if (this.requirements == null)
            this.requirements = new ArrayList<>();
        this.requirements.addAll(requirements);
        return this;
    }
    
    public AugmentRecipeBuilder requirement(class_2960 requirement) {
        if (this.requirements == null)
            this.requirements = new ArrayList<>();
        this.requirements.add(requirement);
        return this;
    }
    
    public AugmentRecipeBuilder requiredStation(class_2960 requiredStation) {
        this.requiredStation = requiredStation;
        return this;
    }
    
    public AugmentRecipeBuilder uiX(int uiX) {
        this.uiX = uiX;
        return this;
    }
    
    public AugmentRecipeBuilder uiY(int uiY) {
        this.uiY = uiY;
        return this;
    }
    
    public AugmentRecipeBuilder time(int time) {
        this.time = time;
        return this;
    }
    
    public AugmentRecipeBuilder rfCost(long rfCost) {
        this.rfCost = rfCost;
        return this;
    }
    
    public AugmentRecipeBuilder toggleable(boolean toggleable) {
        this.toggleable = toggleable;
        return this;
    }
    
    public AugmentRecipeBuilder toggleable() {
        this.toggleable = true;
        return this;
    }
    
    public AugmentRecipeBuilder effectDefinition(class_6880<class_1291> entry, int amplifier) {
        this.effectDefinition = new AugmentDataRecipe.EffectDefinition(class_7923.field_41174.method_10221(entry.comp_349()), amplifier);
        return this;
    }
    
    public AugmentRecipeBuilder modifierDefinition(class_6880<class_1320> entry, float amount, class_1322.class_1323 op) {
        this.modifierDefinition = new AugmentDataRecipe.ModifierDefinition(class_7923.field_41190.method_10221(entry.comp_349()), op.method_56082(), amount);
        return this;
    }
    
    public AugmentRecipeBuilder customAugmentDefinition(class_2960 customAugmentId) {
        this.customAugmentDefinition = new AugmentDataRecipe.CustomAugmentDefinition(customAugmentId);
        return this;
    }
    
    private void validate(class_2960 id) throws IllegalStateException {
        if (researchCosts == null || researchCosts.isEmpty())
            throw new IllegalStateException("Research costs expected for recipe " + id + " (type " + type + ")");
        if (applyCosts == null || applyCosts.isEmpty())
            throw new IllegalStateException("Apply costs expected for recipe " + id + " (type " + type + ")");
        if (requiredStation == null)
            throw new IllegalStateException("required station expected for recipe " + id + " (type " + type + ")");
        
        // ensure exactly one type is set
        if ((effectDefinition != null ? 1 : 0) + (modifierDefinition != null ? 1 : 0) + (customAugmentDefinition != null ? 1 : 0) != 1) {
            throw new IllegalStateException("Exactly one of effectDefinition, modifierDefinition, or customAugmentDefinition must be set for recipe " + id + " (type " + type + ")");
        }
    }
    
    public void export(class_8790 exporter, String suffix) {
        var id = Oritech.id(resourcePath + "/" + suffix);
        validate(id);
        
        exporter.method_53819(id, new AugmentDataRecipe(
          type,
          toggleable,
          researchCosts,
          applyCosts,
          requirements != null ? requirements : List.of(),
          requiredStation,
          uiX,
          uiY,
          time,
          rfCost,
          effectDefinition,
          modifierDefinition,
          customAugmentDefinition
        ), null);
    }
}
