/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.harvesting;

import java.util.Deque;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.TreefellerBlockEntity;
import rearth.oritech.item.tools.harvesting.PromethiumAxeItem;
import rearth.oritech.item.tools.util.OritechEnergyItem;

public class ChainsawItem
extends class_1743
implements OritechEnergyItem {
    public static final int BAR_STEP_COUNT = 13;
    private final float energyUsageMultiplier;

    public ChainsawItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
        this.energyUsageMultiplier = Oritech.CONFIG.chainSaw.energyUsage();
        class_9424 toolComponent = new class_9424(List.of(class_9424.class_9425.method_58427((class_6862)toolMaterial.method_58419()), class_9424.class_9425.method_58428((class_6862)class_3481.field_33713, (float)toolMaterial.method_8027()), class_9424.class_9425.method_58433((class_6862)class_3481.field_44469, (float)1.5f), class_9424.class_9425.method_58431(List.of(class_2246.field_10343), (float)15.0f)), 1.0f, 1);
        this.field_49263 = settings.method_57349(class_9334.field_50077, (Object)toolComponent).method_58406();
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull class_1799 oldStack, @NotNull class_1799 newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@NotNull class_1799 oldStack, @NotNull class_1799 newStack) {
        return false;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        class_2338 startPos;
        class_2680 startState;
        if (!(miner instanceof class_1657)) {
            return true;
        }
        class_1657 player = (class_1657)miner;
        float amount = state.method_26204().method_36555() * this.energyUsageMultiplier;
        amount = Math.min(amount, (float)this.getStoredEnergy(stack));
        boolean energySuccess = this.tryUseEnergy(stack, (long)amount, player);
        if (!world.field_9236 && miner.method_5715() && energySuccess && Oritech.CONFIG.chainsawTreeCutting() && (startState = world.method_8320(startPos = pos.method_10084())).method_26164(class_3481.field_15475)) {
            Deque<class_2338> treeBlocks = TreefellerBlockEntity.getTreeBlocks(startPos, world);
            PromethiumAxeItem.pendingBlocks.addAll(treeBlocks.stream().map(elem -> new class_3545((Object)world, elem)).toList());
            float extraEnergyUsed = (float)treeBlocks.size() * this.energyUsageMultiplier / 2.0f;
            this.tryUseEnergy(stack, (long)extraEnergyUsed, player);
        }
        return energySuccess;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_5250 text = class_2561.method_43469((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{this.getStoredEnergy(stack), this.getEnergyCapacity(stack)});
        tooltip.add((class_2561)text.method_27692(class_124.field_1065));
        if (Oritech.CONFIG.chainsawTreeCutting()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.promethium_axe").method_27692(class_124.field_1063));
        }
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        boolean enoughEnergy = (float)this.getStoredEnergy(stack) >= state.method_26204().method_36555() * this.energyUsageMultiplier;
        float multiplier = enoughEnergy ? 1.0f : 0.1f;
        return super.method_58404(stack, state) * multiplier;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31571(class_1799 stack) {
        return 0xFF7007;
    }

    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.chainSaw.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return Oritech.CONFIG.chainSaw.chargeSpeed();
    }
}

