/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.arcane.EnchanterBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.EnchanterScreenHandler;

public class EnchanterScreen
extends BasicMachineScreen<EnchanterScreenHandler> {
    private class_1799 currentItem = null;
    private FlowLayout detailsScrollPane;
    private ButtonComponent openEnchantmentSelection;
    private LabelComponent statisticsLabel;

    public EnchanterScreen(EnchanterScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    public boolean showExtensionPanel() {
        return false;
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        this.openEnchantmentSelection = Components.button((class_2561)class_2561.method_43471((String)"button.oritech.enchanter.bane_of_long_names"), this::onOpenClicked);
        this.openEnchantmentSelection.positioning(Positioning.relative((int)54, (int)13));
        this.openEnchantmentSelection.active(false);
        this.openEnchantmentSelection.renderer(ORITECH_BUTTON_DARK);
        overlay.child((Component)this.openEnchantmentSelection);
        this.detailsScrollPane = Containers.verticalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
        this.detailsScrollPane.padding(Insets.of((int)2));
        this.detailsScrollPane.margins(Insets.of((int)3));
        this.statisticsLabel = Components.label((class_2561)class_2561.method_43469((String)"title.oritech.enchanter.catalysts_available", (Object[])new Object[]{1, 4}));
        this.statisticsLabel.positioning(Positioning.relative((int)54, (int)29));
        overlay.child((Component)this.statisticsLabel);
    }

    private void onOpenClicked(ButtonComponent event) {
        this.sendEnchantmentToServer(EnchanterBlockEntity.NONE_SELECTED);
        this.openSelectionPanel();
    }

    @Override
    protected void method_37432() {
        boolean hasSelection;
        super.method_37432();
        class_1799 stack = ((EnchanterScreenHandler)this.field_2797).enchanter.inventory.method_5438(0);
        if (this.currentItem == null) {
            this.currentItem = stack;
        }
        if (stack.method_7909() != this.currentItem.method_7909()) {
            this.currentItem = stack;
            this.onStackChanged();
        }
        class_5250 description = class_2561.method_43471((String)"message.oritech.enchanter.insert_item");
        boolean bl = hasSelection = ((EnchanterScreenHandler)this.field_2797).enchanter.getSelectedEnchantment() != null;
        if (hasSelection) {
            description = ((class_1887)((EnchanterScreenHandler)this.field_2797).enchanter.getSelectedEnchantment().comp_349()).comp_2686();
        }
        this.openEnchantmentSelection.method_25355((class_2561)description);
        class_2378 registry = ((EnchanterScreenHandler)this.field_2797).enchanter.method_10997().method_30349().method_30530(class_7924.field_41265);
        boolean canBeEnchanted = registry.method_10220().anyMatch(elem -> elem.method_8192(stack));
        this.openEnchantmentSelection.active(hasSelection && canBeEnchanted);
        EnchanterBlockEntity.EnchanterStatistics statistics = ((EnchanterScreenHandler)this.field_2797).enchanter.statistics;
        if (statistics.equals(EnchanterBlockEntity.EnchanterStatistics.EMPTY)) {
            this.statisticsLabel.text((class_2561)class_2561.method_43470((String)" "));
        } else {
            this.statisticsLabel.text((class_2561)class_2561.method_43469((String)"title.oritech.enchanter.catalysts", (Object[])new Object[]{statistics.availableCatalysts(), statistics.requiredCatalysts()}).method_27692(class_124.field_1063));
        }
        this.progress_indicator.tooltip((class_2561)class_2561.method_43469((String)"title.oritech.enchanter.souls_used", (Object[])new Object[]{((EnchanterScreenHandler)this.field_2797).enchanter.progress, ((EnchanterScreenHandler)this.field_2797).enchanter.maxProgress}));
    }

    private void onStackChanged() {
        if (((EnchanterScreenHandler)this.field_2797).enchanter.getSelectedEnchantment() != null) {
            return;
        }
        this.openSelectionPanel();
    }

    private void openSelectionPanel() {
        final int slotCount = ((EnchanterScreenHandler)this.field_2797).field_7761.size();
        for (int i = 0; i < slotCount; ++i) {
            this.disableSlot(i);
        }
        class_2378 registry = ((EnchanterScreenHandler)this.field_2797).enchanter.method_10997().method_30349().method_30530(class_7924.field_41265);
        List<class_6880> all = registry.method_10220().map(arg_0 -> ((class_2378)registry).method_47983(arg_0)).filter(entry -> ((class_1887)entry.comp_349()).method_8192(this.currentItem)).toList();
        if (all.isEmpty()) {
            return;
        }
        this.detailsScrollPane.clearChildren();
        LabelComponent title = Components.label((class_2561)class_2561.method_43471((String)"tooltip.oritech.enchanter_selection"));
        this.detailsScrollPane.child((Component)title);
        ScrollContainer scrollPane = Containers.verticalScroll((Sizing)Sizing.fixed((int)184), (Sizing)Sizing.fixed((int)200), (Component)this.detailsScrollPane);
        scrollPane.padding(Insets.of((int)2));
        OverlayContainer<ScrollContainer<FlowLayout>> floatingPanel = new OverlayContainer<ScrollContainer<FlowLayout>>(scrollPane){

            public void remove() {
                super.remove();
                for (int i = 0; i < slotCount; ++i) {
                    EnchanterScreen.this.enableSlot(i);
                }
            }
        };
        for (class_6880 entry2 : all) {
            class_1887 candidate = (class_1887)entry2.comp_349();
            ButtonComponent button = Components.button((class_2561)candidate.comp_2686().method_27661().method_54663(BasicMachineScreen.GRAY_TEXT_COLOR), arg_0 -> this.lambda$openSelectionPanel$2(entry2, floatingPanel, arg_0));
            button.sizing(Sizing.fill(), Sizing.fixed((int)25));
            button.margins(Insets.of((int)1, (int)1, (int)0, (int)8));
            button.renderer(ORITECH_BUTTON);
            button.textShadow(false);
            this.detailsScrollPane.child((Component)button);
        }
        scrollPane.surface(Surface.DARK_PANEL);
        floatingPanel.zIndex(9800);
        floatingPanel.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.root.child((Component)floatingPanel);
    }

    private void onEnchantmentSelected(class_6880<class_1887> entry, OverlayContainer<ScrollContainer<FlowLayout>> floatingPanel) {
        ((EnchanterScreenHandler)this.field_2797).enchanter.selectedEnchantment = class_2960.method_60654((String)entry.method_55840());
        this.sendEnchantmentToServer(class_2960.method_60654((String)entry.method_55840()));
        floatingPanel.remove();
    }

    private void sendEnchantmentToServer(class_2960 selected) {
        NetworkManager.sendToServer(new EnchanterBlockEntity.SelectEnchantingPacket(((EnchanterScreenHandler)this.field_2797).blockPos, selected));
    }

    private /* synthetic */ void lambda$openSelectionPanel$2(class_6880 entry, 1 floatingPanel, ButtonComponent data) {
        this.onEnchantmentSelected((class_6880<class_1887>)entry, floatingPanel);
    }
}

