/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.util.Geometry;

public class PowerPoleLineRenderer
implements class_827<PowerPoleEntity> {
    private static final class_2960 CABLE_TEXTURE = class_2960.method_60656((String)"textures/block/white_concrete.png");

    public void render(@NotNull PowerPoleEntity blockEntity, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight, int packedOverlay) {
        Set<PowerPoleEntity.ConnectionTarget> connections = blockEntity.getConnections();
        if (connections.isEmpty() || blockEntity.method_11015()) {
            return;
        }
        class_2338 camPos = class_310.method_1551().field_1719.method_24515();
        double poleDist = blockEntity.method_11016().method_10262((class_2382)camPos);
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23572((class_2960)CABLE_TEXTURE));
        class_2338 ownPos = blockEntity.method_11016();
        class_2350 ownFacing = blockEntity.getFacingForMultiblock();
        class_243 ownSideVec = class_243.method_24954((class_2382)Geometry.getForward(ownFacing));
        class_243 centerPos = new class_243(0.5, 0.5, 0.5);
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.35f, 0.0f);
        for (PowerPoleEntity.ConnectionTarget target : connections) {
            class_243 targetForStartB;
            class_243 targetForStartA;
            double distCross;
            double targetDist;
            if (target == null || (targetDist = target.pos().method_10262((class_2382)camPos)) < poleDist) continue;
            class_243 startWorldA = class_243.method_24953((class_2382)ownPos).method_1019(ownSideVec);
            class_243 startWorldB = class_243.method_24953((class_2382)ownPos).method_1020(ownSideVec);
            class_243 targetArmVec = class_243.method_24954((class_2382)Geometry.getForward(target.facing()));
            class_243 targetWorldA = class_243.method_24953((class_2382)target.pos()).method_1019(targetArmVec);
            class_243 targetWorldB = class_243.method_24953((class_2382)target.pos()).method_1020(targetArmVec);
            double distDirect = startWorldA.method_1025(targetWorldA) + startWorldB.method_1025(targetWorldB);
            if (distDirect < (distCross = startWorldA.method_1025(targetWorldB) + startWorldB.method_1025(targetWorldA))) {
                targetForStartA = targetWorldA;
                targetForStartB = targetWorldB;
            } else {
                targetForStartA = targetWorldB;
                targetForStartB = targetWorldA;
            }
            class_243 localStartA = centerPos.method_1019(ownSideVec);
            class_243 localStartB = centerPos.method_1020(ownSideVec);
            class_243 localTargetA = targetForStartA.method_1023((double)ownPos.method_10263(), (double)ownPos.method_10264(), (double)ownPos.method_10260());
            class_243 localTargetB = targetForStartB.method_1023((double)ownPos.method_10263(), (double)ownPos.method_10264(), (double)ownPos.method_10260());
            float thickness = 0.05f;
            this.renderHangingCable(poseStack, consumer, localStartA, localTargetA, thickness, packedLight);
            this.renderHangingCable(poseStack, consumer, localStartB, localTargetB, thickness, packedLight);
        }
        poseStack.method_22909();
    }

    private void renderHangingCable(class_4587 poseStack, class_4588 consumer, class_243 startPos, class_243 endPos, float thickness, int packedLight) {
        poseStack.method_22903();
        class_243 totalOffset = endPos.method_1020(startPos);
        int segments = 8;
        float totalLength = (float)totalOffset.method_1033();
        float sag = totalLength * 0.05f;
        sag = Math.min(sag, 4.0f);
        class_243 currentPos = startPos;
        for (int i = 0; i < segments; ++i) {
            float t = (float)(i + 1) / (float)segments;
            class_243 nextPos = startPos.method_1019(totalOffset.method_1021((double)t));
            float sagY = -sag * 4.0f * t * (1.0f - t);
            nextPos = nextPos.method_1031(0.0, (double)sagY, 0.0);
            class_243 segmentDelta = nextPos.method_1020(currentPos);
            class_243 drawDelta = segmentDelta.method_1021(1.02);
            this.drawSegment(poseStack, consumer, currentPos, drawDelta, thickness, packedLight);
            currentPos = nextPos;
        }
        poseStack.method_22909();
    }

    private void drawSegment(class_4587 poseStack, class_4588 consumer, class_243 startPos, class_243 delta, float thickness, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22904(startPos.field_1352, startPos.field_1351, startPos.field_1350);
        double xzLen = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        float yRot = (float)(-Math.atan2(-delta.field_1352, delta.field_1350));
        float xRot = (float)(-Math.atan2(delta.field_1351, xzLen));
        poseStack.method_22907(class_7833.field_40716.rotation(yRot));
        poseStack.method_22907(class_7833.field_40714.rotation(xRot + 1.5707964f));
        float length = (float)delta.method_1033();
        float r = thickness;
        int red = 50;
        int green = 50;
        int blue = 50;
        int alpha = 255;
        class_4587.class_4665 pose = poseStack.method_23760();
        this.addVertex(consumer, pose, -r, 0.0f, r, red, green, blue, alpha, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, r, red, green, blue, alpha, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, r, length, r, red, green, blue, alpha, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, r, red, green, blue, alpha, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, -r, red, green, blue, alpha, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, -r, 0.0f, -r, red, green, blue, alpha, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, -r, red, green, blue, alpha, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, r, length, -r, red, green, blue, alpha, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, packedLight);
        this.addVertex(consumer, pose, -r, 0.0f, -r, red, green, blue, alpha, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, -r, 0.0f, r, red, green, blue, alpha, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, r, red, green, blue, alpha, 1.0f, 1.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, -r, length, -r, red, green, blue, alpha, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, r, red, green, blue, alpha, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, 0.0f, -r, red, green, blue, alpha, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, length, -r, red, green, blue, alpha, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, packedLight);
        this.addVertex(consumer, pose, r, length, r, red, green, blue, alpha, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, packedLight);
        poseStack.method_22909();
    }

    private void addVertex(class_4588 consumer, class_4587.class_4665 pose, float x, float y, float z, int r, int g, int b, int a, float u, float v, float nx, float ny, float nz, int packedLight) {
        consumer.method_22918(pose.method_23761(), x, y, z).method_1336(r, g, b, a).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, nx, ny, nz);
    }

    public int method_33893() {
        return 256;
    }

    public boolean shouldRenderOffScreen(PowerPoleEntity blockEntity) {
        return true;
    }
}

