/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_4538;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.AdditionalNetworkingProvider;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ScreenProvider;

public class PlacerBlockEntity
extends ItemEnergyFrameInteractionBlockEntity
implements AdditionalNetworkingProvider {
    public PlacerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PLACER_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected boolean hasWorkAvailable(class_2338 toolPosition) {
        class_1799 firstBlock = this.getFirstInInventory();
        if (firstBlock == null) {
            return false;
        }
        class_2248 block = class_2248.method_9503((class_1792)firstBlock.method_7909());
        if (block == null) {
            return false;
        }
        class_2338 targetPosition = toolPosition.method_10074();
        return Objects.requireNonNull(this.field_11863).method_8320(targetPosition).method_26204().equals(class_2246.field_10124) && block.method_9564().method_26184((class_4538)this.field_11863, targetPosition);
    }

    @Override
    public void finishBlockWork(class_2338 processed) {
        class_1799 firstBlock = this.getFirstInInventory();
        if (firstBlock == null) {
            return;
        }
        class_2248 block = class_2248.method_9503((class_1792)firstBlock.method_7909());
        if (block == null) {
            return;
        }
        class_2338 targetPosition = processed.method_10074();
        if (Objects.requireNonNull(this.field_11863).method_8320(targetPosition).method_26204().equals(class_2246.field_10124) && block.method_9564().method_26184((class_4538)this.field_11863, targetPosition)) {
            this.field_11863.method_8501(targetPosition, block.method_9564());
            firstBlock.method_7934(1);
            this.field_11863.method_8396(null, targetPosition, block.method_9564().method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
            super.finishBlockWork(processed);
        }
    }

    private class_1799 getFirstInInventory() {
        for (class_1799 stack : this.inventory.heldStacks) {
            if (stack == null || stack.method_7960() || !(stack.method_7909() instanceof class_1747)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public float getCoreQuality() {
        return 3.0f;
    }

    @Override
    public class_2680 getMachineHead() {
        return BlockContent.BLOCK_PLACER_HEAD.method_9564();
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(0, -1, 0));
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38));
    }

    @Override
    public class_1799 getToolheadAdditionalRender() {
        return this.getFirstInInventory();
    }

    @Override
    public float getMoveTime() {
        return (float)Oritech.CONFIG.placerConfig.moveDuration() * this.getSpeedMultiplier();
    }

    @Override
    public float getWorkTime() {
        return (float)Oritech.CONFIG.placerConfig.workDuration() * this.getSpeedMultiplier();
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.placerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        return Oritech.CONFIG.placerConfig.workEnergyUsage();
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.PLACER_SCREEN;
    }

    @Override
    public List<Field> additionalSyncedFields(SyncType type) {
        if (type.equals((Object)SyncType.TICK)) {
            try {
                return List.of(ItemEnergyFrameInteractionBlockEntity.class.getDeclaredField("inventory"));
            }
            catch (NoSuchFieldException e) {
                Oritech.LOGGER.error("unable to register inventory as extra synced field for placed block.");
            }
        }
        return List.of();
    }
}

