/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.wispforest.owo.util.VectorRandomUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9797;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.accelerator.AcceleratorMotorBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.block.entity.accelerator.BlackHoleBlockEntity;
import rearth.oritech.block.entity.accelerator.ParticleCollectorBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.AcceleratorScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;

public class AcceleratorControllerBlockEntity
extends class_2586
implements class_5558<AcceleratorControllerBlockEntity>,
ItemApi.BlockProvider,
ExtendedMenuProvider,
ScreenProvider {
    private AcceleratorParticleLogic.ActiveParticle particle;
    private AcceleratorParticleLogic.ActiveParticle lastParticle;
    public class_1799 activeItemParticle = class_1799.field_8037;
    private AcceleratorParticleLogic particleLogic;
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(2, () -> ((AcceleratorControllerBlockEntity)this).method_5431(), new InventorySlotAssignment(0, 1, 1, 1));
    public List<class_243> displayTrail;
    public LastEventPacket lastEvent = new LastEventPacket(this.field_11867, ParticleEvent.IDLE, 0.0f, this.field_11867, 1.0f, class_1799.field_8037);

    public AcceleratorControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ACCELERATOR_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, AcceleratorControllerBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        this.initParticleLogic();
        if (this.particle == null && !this.inventory.method_5438(0).method_7960() && this.inventory.method_5438(1).method_7960()) {
            this.injectParticle();
        }
        if (this.particle != null) {
            this.particleLogic.update(this.particle);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        if (this.particle != null && this.activeItemParticle != null && this.activeItemParticle != class_1799.field_8037) {
            class_2487 data = new class_2487();
            data.method_10548("speed", this.particle.velocity);
            data.method_10548("posX", (float)this.particle.position.field_1352);
            data.method_10548("posY", (float)this.particle.position.field_1351);
            data.method_10548("posZ", (float)this.particle.position.field_1350);
            data.method_10544("lastGate", this.particle.lastGate.method_10063());
            data.method_10544("nextGate", this.particle.nextGate.method_10063());
            data.method_10566("item", this.activeItemParticle.method_57358(registryLookup));
            nbt.method_10566("particle", (class_2520)data);
        } else {
            nbt.method_10551("particle");
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        if (nbt.method_10545("particle")) {
            class_2487 data = nbt.method_10562("particle");
            float speed = data.method_10583("speed");
            float posX = data.method_10583("posX");
            float posY = data.method_10583("posY");
            float posZ = data.method_10583("posZ");
            class_2338 lastGate = class_2338.method_10092((long)data.method_10537("lastGate"));
            class_2338 nextGate = class_2338.method_10092((long)data.method_10537("nextGate"));
            Optional item = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)data.method_10580("item"));
            item.ifPresent(stack -> {
                this.activeItemParticle = stack;
            });
            this.particle = new AcceleratorParticleLogic.ActiveParticle(new class_243((double)posX, (double)posY, (double)posZ), speed, lastGate, nextGate);
        }
    }

    private void initParticleLogic() {
        if (this.particleLogic == null) {
            this.particleLogic = new AcceleratorParticleLogic(this.field_11867, (class_3218)this.field_11863, this);
        }
    }

    public void injectParticle() {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
        class_2382 posBehind = Geometry.offsetToWorldPosition(facing, new class_2382(1, 0, 0), (class_2382)this.field_11867);
        class_2382 directionRight = Geometry.getRight(facing);
        class_2680 candidateBlock = this.field_11863.method_8320(new class_2338(posBehind));
        if (candidateBlock.method_26204().equals(BlockContent.ACCELERATOR_RING)) {
            class_2338 startPosition = (class_2338)posBehind;
            class_2338 nextGate = this.particleLogic.findNextGate(startPosition, directionRight, 1.0f);
            this.particle = new AcceleratorParticleLogic.ActiveParticle(startPosition.method_46558(), 1.0f, nextGate, startPosition);
            this.activeItemParticle = this.inventory.method_5438(0).method_7971(1);
            class_243 soundPos = this.field_11867.method_46558();
            this.field_11863.method_54762(null, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, class_3417.field_40065, class_3419.field_15245);
        }
    }

    public void removeParticleDueToCollision() {
        this.particle = null;
        this.activeItemParticle = class_1799.field_8037;
    }

    public void onParticleExited(class_243 from, class_243 to, class_2338 lastGate, class_243 exitDirection, ParticleEvent reason) {
        class_2338 eventPosition = class_2338.method_49638((class_2374)this.particle.position);
        NetworkManager.sendBlockHandle(this, new LastEventPacket(this.field_11867, reason, this.particle.velocity, eventPosition, AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
        this.lastParticle = this.particle;
        this.particle = null;
        List<class_243> renderedTrail = List.of(from, to);
        NetworkManager.sendBlockHandle(this, new ParticleRenderTrail(this.field_11867, renderedTrail));
        this.method_5431();
    }

    public void onParticleCollided(float relativeSpeed, class_243 collision, AcceleratorControllerBlockEntity secondControllerEntity) {
        if (relativeSpeed > (float)Oritech.CONFIG.endPortalRequiredSpeed() && this.activeItemParticle.method_7909().equals(class_1802.field_8634) && secondControllerEntity.activeItemParticle.method_7909().equals(class_1802.field_8634)) {
            this.spawnEndPortal(class_2338.method_49638((class_2374)collision));
        } else if (relativeSpeed > (float)Oritech.CONFIG.netherPortalRequiredSpeed() && this.activeItemParticle.method_7909().equals(class_1802.field_8814) && secondControllerEntity.activeItemParticle.method_7909().equals(class_1802.field_8814)) {
            this.spawnNetherPortal(class_2338.method_49638((class_2374)collision));
        } else {
            boolean bl = this.tryCraftResult(relativeSpeed, this.activeItemParticle, secondControllerEntity.activeItemParticle);
        }
        NetworkManager.sendBlockHandle(this, new LastEventPacket(this.field_11867, ParticleEvent.COLLIDED, relativeSpeed, class_2338.method_49638((class_2374)collision), AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
        NetworkManager.sendBlockHandle(this, new LastEventPacket(secondControllerEntity.method_11016(), ParticleEvent.COLLIDED, relativeSpeed, class_2338.method_49638((class_2374)collision), AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
        this.removeParticleDueToCollision();
        secondControllerEntity.removeParticleDueToCollision();
        double particleCount = Math.pow(relativeSpeed, 0.5) / 2.0 + 1.0;
        this.createCollisionParticles((int)relativeSpeed, collision, (int)particleCount);
        ParticleContent.PARTICLE_COLLIDE.spawn(this.field_11863, collision);
        this.method_5431();
    }

    private void createCollisionParticles(int collisionEnergy, class_243 collisionPosition, int shotCount) {
        float energyMultiplier = 4.0f * Oritech.CONFIG.tachyonCollisionEnergyFactor();
        int energyPotential = (int)(Math.pow((float)collisionEnergy / 2.0f, 2.0) * (double)energyMultiplier * (double)Oritech.CONFIG.accelerationRFCost());
        int energyPerRay = energyPotential / shotCount;
        int rayRange = shotCount / 3;
        int caughtParticles = 0;
        for (int i = 0; i < shotCount; ++i) {
            class_243 offset = VectorRandomUtils.getRandomOffset((class_1937)this.field_11863, (class_243)collisionPosition, (double)rayRange);
            class_243 direction = offset.method_1020(collisionPosition).method_1029();
            class_2338 impactPos = BlackHoleBlockEntity.basicRaycast(collisionPosition.method_1019(direction.method_1021(1.2)), direction, rayRange, this.field_11863);
            if (impactPos != null) {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(this.field_11863, collisionPosition, (Object)impactPos.method_46558());
                class_2586 candidate = this.field_11863.method_8321(impactPos);
                if (!(candidate instanceof ParticleCollectorBlockEntity)) continue;
                ParticleCollectorBlockEntity collectorEntity = (ParticleCollectorBlockEntity)candidate;
                collectorEntity.onParticleCollided(energyPerRay);
                ++caughtParticles;
                continue;
            }
            ParticleContent.BLACK_HOLE_EMISSION.spawn(this.field_11863, collisionPosition, (Object)offset);
        }
    }

    private boolean tryCraftResult(float speed, class_1799 inputA, class_1799 inputB) {
        if (inputA == null || inputA.method_7960() || inputB == null || inputB.method_7960()) {
            return false;
        }
        SimpleCraftingInventory inputInv = new SimpleCraftingInventory(inputA, inputB);
        Optional candidate = this.field_11863.method_8433().method_8132((class_3956)RecipeContent.PARTICLE_COLLISION, (class_9695)inputInv, this.field_11863);
        if (candidate.isEmpty()) {
            inputInv = new SimpleCraftingInventory(inputB, inputA);
            candidate = this.field_11863.method_8433().method_8132((class_3956)RecipeContent.PARTICLE_COLLISION, (class_9695)inputInv, this.field_11863);
        }
        if (candidate.isEmpty()) {
            return false;
        }
        OritechRecipe recipe = (OritechRecipe)((class_8786)candidate.get()).comp_1933();
        int requiredSpeed = recipe.getTime();
        if (speed < (float)requiredSpeed) {
            return false;
        }
        List<class_1799> result = recipe.getResults();
        if (((class_1799)this.inventory.heldStacks.get(1)).method_7909().equals(result.get(0).method_7909())) {
            ((class_1799)this.inventory.heldStacks.get(1)).method_7933(1);
        } else {
            this.inventory.method_5447(1, result.get(0).method_7972());
        }
        return true;
    }

    private void spawnEndPortal(class_2338 pos) {
        for (class_2338 candidate : class_2338.method_25996((class_2338)pos, (int)8, (int)4, (int)8)) {
            class_2680 stateAbove;
            class_2680 candidateState;
            double dist = candidate.method_46558().method_1022(pos.method_46558());
            if ((double)this.field_11863.field_9229.method_43057() < dist / 8.0 || (candidateState = this.field_11863.method_8320(candidate)).method_26215() || candidateState.method_45474() || candidateState.method_26204().method_36555() < 0.0f) continue;
            if (!this.field_11863.method_8320(candidate.method_10074()).method_26204().equals(class_2246.field_10021)) {
                this.field_11863.method_8501(candidate, class_2246.field_10471.method_9564());
            }
            if (!((double)this.field_11863.field_9229.method_43057() > 0.8) || !(stateAbove = this.field_11863.method_8320(candidate.method_10084())).method_26215() && !stateAbove.method_45474()) continue;
            for (int i = 1; i < this.field_11863.field_9229.method_39332(3, 6); ++i) {
                stateAbove = this.field_11863.method_8320(candidate.method_10086(i));
                if (!stateAbove.method_26215() && !stateAbove.method_45474()) continue;
                this.field_11863.method_8501(candidate.method_10086(i), class_2246.field_10021.method_9564());
            }
        }
        this.field_11863.method_8501(pos, class_2246.field_10027.method_9564());
        this.field_11863.method_8501(pos.method_10095(), class_2246.field_10471.method_9564());
        this.field_11863.method_8501(pos.method_10078(), class_2246.field_10471.method_9564());
        this.field_11863.method_8501(pos.method_10072(), class_2246.field_10471.method_9564());
        this.field_11863.method_8501(pos.method_10067(), class_2246.field_10471.method_9564());
    }

    private void spawnNetherPortal(class_2338 pos) {
        for (class_2338 candidate : class_2338.method_25996((class_2338)pos, (int)12, (int)4, (int)12)) {
            class_2680 stateAbove;
            class_2680 candidateState;
            double dist = candidate.method_46558().method_1022(pos.method_46558());
            if ((double)this.field_11863.field_9229.method_43057() < dist / 12.0 || (candidateState = this.field_11863.method_8320(candidate)).method_26215() || candidateState.method_45474() || candidateState.method_26204().method_36555() < 0.0f) continue;
            this.field_11863.method_8501(candidate, class_2246.field_10515.method_9564());
            if (!((double)this.field_11863.field_9229.method_43057() > 0.8) || !(stateAbove = this.field_11863.method_8320(candidate.method_10084())).method_26215() && !stateAbove.method_45474()) continue;
            this.field_11863.method_8501(candidate.method_10084(), class_2246.field_10036.method_9564());
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 4; ++y) {
                this.field_11863.method_8501(pos.method_10069(x, y, 0), class_2246.field_10540.method_9564());
            }
        }
        this.field_11863.method_8501(pos.method_10069(1, 1, 0), class_2246.field_10316.method_9564());
        this.field_11863.method_8501(pos.method_10069(1, 2, 0), class_2246.field_10316.method_9564());
    }

    public void onParticleMoved(List<class_243> positions) {
        if (positions.size() <= 1) {
            return;
        }
        ArrayList<class_243> resultList = new ArrayList<class_243>();
        HashSet<class_243> positionSet = new HashSet<class_243>();
        for (class_243 position : positions) {
            if (positionSet.contains(position)) break;
            positionSet.add(position);
            resultList.add(position);
        }
        NetworkManager.sendBlockHandle(this, new ParticleRenderTrail(this.field_11867, resultList));
        NetworkManager.sendBlockHandle(this, new LastEventPacket(this.field_11867, ParticleEvent.ACCELERATING, this.particle.velocity, class_2338.method_49638((class_2374)this.particle.position), AcceleratorParticleLogic.getParticleBendDist(this.particle.lastBendDistance, this.particle.lastBendDistance2), this.activeItemParticle));
    }

    public AcceleratorParticleLogic.ActiveParticle getParticle() {
        if (this.particle == null && this.lastParticle != null) {
            return this.lastParticle;
        }
        return this.particle;
    }

    public float handleParticleEntityCollision(class_2338 checkPos, AcceleratorParticleLogic.ActiveParticle particle, float remainingMomentum, class_1309 mob) {
        float maxApplicableDamage = mob.method_6032();
        float inflictedDamage = Math.min(remainingMomentum, maxApplicableDamage);
        mob.method_5643(this.field_11863.method_48963().method_48831(), remainingMomentum);
        class_243 position = mob.method_5829().method_1005();
        position = new class_243(position.field_1352, particle.position.field_1351, position.field_1350);
        ParticleContent.BIG_HIT.spawn(this.field_11863, position);
        return inflictedDamage;
    }

    public float handleParticleBlockCollision(class_2338 checkPos, AcceleratorParticleLogic.ActiveParticle particle, float remainingMomentum, class_2680 hitState) {
        float blockHardness = hitState.method_26214((class_1922)this.field_11863, checkPos);
        if (remainingMomentum > (float)Oritech.CONFIG.blackHoleRequiredSpeed() && hitState.method_26204() instanceof class_9797) {
            this.createBlackHole(checkPos);
            return remainingMomentum;
        }
        if (blockHardness < 0.0f) {
            return remainingMomentum;
        }
        if (remainingMomentum > blockHardness) {
            this.field_11863.method_31595(checkPos, hitState);
            this.field_11863.method_8396(null, checkPos, hitState.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
            this.field_11863.method_22352(checkPos, true);
        }
        return blockHardness;
    }

    private void createBlackHole(class_2338 checkPos) {
        ParticleContent.MELTDOWN_IMMINENT.spawn(this.field_11863, checkPos.method_46558(), (Object)30);
        class_243 center = checkPos.method_46558();
        this.field_11863.method_8537(null, center.field_1352, center.field_1351, center.field_1350, 10.0f, false, class_1937.class_7867.field_40889);
        this.field_11863.method_8650(checkPos, false);
        this.field_11863.method_8501(checkPos, BlockContent.BLACK_HOLE_BLOCK.method_9564());
    }

    public void handleParticleMotorInteraction(class_2338 motorBlock) {
        class_2586 entity = this.field_11863.method_8321(motorBlock);
        if (!(entity instanceof AcceleratorMotorBlockEntity)) {
            return;
        }
        AcceleratorMotorBlockEntity motorEntity = (AcceleratorMotorBlockEntity)entity;
        EnergyApi.EnergyStorage storage = motorEntity.getEnergyStorage(null);
        long availableEnergy = storage.getAmount();
        float speed = this.particle.velocity;
        float cost = speed * (float)Oritech.CONFIG.accelerationRFCost();
        if ((float)availableEnergy < cost) {
            return;
        }
        storage.extract((long)cost, false);
        storage.update();
        this.particle.velocity += 1.0f;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    public void saveExtraData(class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new AcceleratorScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 7, 10), new ScreenProvider.GuiSlot(1, 7, 60, true));
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.ACCELERATOR_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    public static void receiveTrail(ParticleRenderTrail packet, class_1937 world, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = world.method_8321(packet.position);
        if (class_25862 instanceof AcceleratorControllerBlockEntity) {
            AcceleratorControllerBlockEntity acceleratorBlock = (AcceleratorControllerBlockEntity)class_25862;
            List<class_243> displayTrail = packet.particleTrail;
            acceleratorBlock.displayTrail = displayTrail;
            if (displayTrail.size() < 2) {
                return;
            }
            class_243 playerPos = class_310.method_1551().field_1724.method_19538();
            double minDist = Double.MAX_VALUE;
            class_243 soundPos = displayTrail.getFirst();
            for (class_243 candidate : displayTrail) {
                double dist = candidate.method_1022(playerPos);
                if (!(dist < minDist)) continue;
                minDist = dist;
                soundPos = candidate;
            }
            double pitch = Math.pow(acceleratorBlock.lastEvent.lastEventSpeed, 0.1);
            world.method_8486(soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, SoundContent.PARTICLE_MOVING, class_3419.field_15245, 2.0f, (float)pitch, true);
        }
    }

    public static void receiveEvent(LastEventPacket packet, class_1937 world, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = world.method_8321(packet.position);
        if (class_25862 instanceof AcceleratorControllerBlockEntity) {
            AcceleratorControllerBlockEntity acceleratorBlock = (AcceleratorControllerBlockEntity)class_25862;
            acceleratorBlock.lastEvent = packet;
            class_243 soundPos = packet.lastEventPosition.method_46558();
            if (packet.lastEvent.equals((Object)ParticleEvent.COLLIDED)) {
                world.method_8486(soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, class_3417.field_38830, class_3419.field_15245, 5.0f, 1.0f, true);
            } else if (packet.lastEvent.equals((Object)ParticleEvent.EXITED_FAST) || packet.lastEvent.equals((Object)ParticleEvent.EXITED_NO_GATE)) {
                world.method_8486(soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, (class_3414)class_3417.field_49044.comp_349(), class_3419.field_15245, 3.0f, 1.0f, true);
            }
        }
    }

    public record LastEventPacket(class_2338 position, ParticleEvent lastEvent, float lastEventSpeed, class_2338 lastEventPosition, float minBendDist, class_1799 activeParticle) implements class_8710
    {
        public static final class_8710.class_9154<LastEventPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("accel_event"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public static enum ParticleEvent {
        IDLE,
        ERROR,
        ACCELERATING,
        COLLIDED,
        EXITED_FAST,
        EXITED_NO_GATE;

    }

    public record ParticleRenderTrail(class_2338 position, List<class_243> particleTrail) implements class_8710
    {
        public static final class_8710.class_9154<ParticleRenderTrail> PACKET_ID = new class_8710.class_9154(Oritech.id("accel_render"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

