/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public abstract class ItemEnergyFrameInteractionBlockEntity
extends FrameInteractionBlockEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
ExtendedMenuProvider,
ScreenProvider,
MachineAddonController,
RedstoneAddonBlockEntity.RedstoneControllable {
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, this::method_5431);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(this.getInventorySize(), this::method_5431);
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> connectedAddons = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> openSlots = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;

    public ItemEnergyFrameInteractionBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public abstract int getMoveEnergyUsage();

    public abstract int getOperationEnergyUsage();

    @Override
    protected boolean canProgress() {
        return !this.disabledViaRedstone && (float)this.energyStorage.amount >= (float)this.getMoveEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed()) && (float)this.energyStorage.amount >= (float)this.getOperationEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed());
    }

    @Override
    protected void doProgress(boolean moving) {
        int usedCost = moving ? this.getMoveEnergyUsage() : this.getOperationEnergyUsage();
        this.energyStorage.amount -= (long)((float)usedCost * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed()));
    }

    @Override
    public void finishBlockWork(class_2338 processed) {
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.energyStorage.amount = nbt.method_10537("energy_stored");
        this.disabledViaRedstone = nbt.method_10577("oritech.redstone");
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
        nbt.method_10556("oritech.redstone", this.disabledViaRedstone);
        this.writeAddonToNbt(nbt);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public class_2338 getPosForAddon() {
        return this.method_11016();
    }

    @Override
    public class_1937 getWorldForAddon() {
        return this.method_10997();
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 50, 11));
    }

    public int getInventorySize() {
        return 1;
    }

    @Override
    public float getProgress() {
        float maxTime = this.isMoving() ? this.getMoveTime() : this.getWorkTime();
        return (float)this.getCurrentProgress() / maxTime;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return (float)this.getOperationEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed());
    }

    @Override
    public long getDefaultCapacity() {
        return 100000L;
    }

    @Override
    public long getDefaultInsertRate() {
        return 5000L;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public float getSpeedMultiplier() {
        return this.addonData.speed();
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public List<class_2338> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<class_2338> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public class_2350 getFacingForAddon() {
        return super.getFacing();
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.method_5431();
    }

    public boolean isActivelyWorking() {
        return this.field_11863.method_8510() - this.lastWorkedAt < 5L;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.heldStacks.size() <= slot) {
            return 0;
        }
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return 0;
        }
        return (int)((float)stack.method_7947() / (float)stack.method_7914() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        return 0;
    }

    @Override
    public int getComparatorActiveState() {
        return this.isActivelyWorking() ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }
}

