package rearth.oritech.item.tools;

import rearth.oritech.client.init.ParticleContent;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3481;

public class WeedKiller extends class_1792 {
    public WeedKiller(class_1793 settings) {
        super(settings);
    }
    
    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8045().method_8608())
            return super.method_7884(context);
        
        var startPos = context.method_8037();
        
        new Thread(() -> doWeedKilling(context.method_8045(), startPos)).start();
        
        context.method_8041().method_57008(1, context.method_8036());
        
        return class_1269.field_5812;
    }
    
    private void doWeedKilling(class_1937 world, class_2338 startPos) {
        
        var maxRange = 20;
        var spreadRange = 3;
        var visited = new HashSet<class_2338>();
        var open = new ArrayDeque<class_2338>();
        open.add(startPos);
        
        while (!open.isEmpty()) {
            var candidate = open.pop();
            
            for (int x = -spreadRange; x <= spreadRange; x++) {
                for (int y = -1; y <= 1; y++) {
                    for (int z = -spreadRange; z <= spreadRange; z++) {
                        
                        var target = new class_2338(candidate.method_10069(x,y,z));
                        
                        if (visited.contains(target)) continue;
                        var distance = target.method_19455(startPos);
                        
                        if (isWeedBlock(target, world) && distance < maxRange) {
                            open.add(target);
                            world.method_8501(target, class_2246.field_10124.method_9564());
                            
                            ParticleContent.WEED_KILLER.spawn(world, target.method_46558(), new ParticleContent.LineData(candidate.method_46558(), target.method_46558()));
                            
                            try {
                                Thread.sleep(50);
                            } catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            
                        }
                        
                        visited.add(target);
                        
                    }
                }
            }
            
        }
        
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add(class_2561.method_43471("tooltip.oritech.weed_killer").method_27692(class_124.field_1080));
    }
    
    private boolean isWeedBlock(class_2338 pos, class_1937 world) {
        var state = world.method_8320(pos);
        if (state.method_26215() || state.method_26227().method_15771()) return false;
        return state.method_45474() || state.method_26164(class_3481.field_20339);
    }
}
