package rearth.oritech.init.world.features.oil;

import com.mojang.serialization.Codec;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3756;
import net.minecraft.class_5821;
import net.minecraft.class_7923;
import rearth.oritech.Oritech;

public class OilSpringFeature extends class_3031<OilSpringFeatureConfig> {
    public OilSpringFeature(Codec<OilSpringFeatureConfig> configCodec) {
        super(configCodec);
    }
    
    @Override
    public boolean method_13151(class_5821<OilSpringFeatureConfig> context) {
        
        var world = context.method_33652();
        var origin = context.method_33655();
        
        if (world.method_8608()) return false;
        
        
        var testPos = new class_2338(origin);
        for (int y = 0; y < world.method_31605(); y++) {
            testPos = testPos.method_10084();
            
            if (world.method_8320(testPos).method_26164(class_3481.field_29822) || world.method_8320(testPos).method_26164(class_3481.field_15466)) {
                if (world.method_8320(testPos.method_10084()).method_27852(class_2246.field_10124)) {
                    placeStructure(testPos, context);
                    return true;
                }
            }
            
        }
        
        return false;
    }
    
    private void placeStructure(class_2338 surfacePos, class_5821<OilSpringFeatureConfig> context) {
        
        var random = context.method_33654();
        var config = context.method_33656();
        var state = class_7923.field_41175.method_10223(config.blockId()).method_9564();
        var world = context.method_33652();
        
        var variation = random.method_39332((int) (-config.number() * 0.5f), config.number());
        var height = Math.max(config.number() + variation, 13);
        var depth = height * 2;
        
        var bottomEnd = surfacePos.method_10087(depth);
        var center = bottomEnd.method_10069(random.method_39332(-2, 2), random.method_39332(-3, 3), random.method_39332(0, height / 2));

        var perlinSampler = new class_3756(random);
        
        // iterate through a cube, calculate distance from center to get a good circle
        for (int x = 0; x < depth + 2; x++) {
            for (int y = 0; y < depth + 2; y++) {
                for (int z = 0; z < depth + 2; z++) {
                    var point = new class_2338(x - height, y - height, z - height).method_10081(bottomEnd);
                    var distance = Math.sqrt(point.method_10262(center));
                    var noiseOffset = perlinSampler.method_33658(x, y, z);
                    if (distance <= height + noiseOffset - 2) {
                        world.method_8652(point, state, 0x10);
                    } else if (distance <= height + noiseOffset) {
                        world.method_8652(point, class_2246.field_10340.method_9564(), 0x10);
                    }
                }
            }
        }
        
        // fountain up
        if (Oritech.CONFIG.easyFindFeatures()) {
            for (int i = 0; i < height; i++) {
                world.method_8652(surfacePos.method_10086(i), state, 0x10);
            }
        }
        
        // down
        for (int i = 1; i < depth + 5; i++) {
            world.method_8652(surfacePos.method_10087(i), state, 0x10);
        }
        
    }
}
