package rearth.oritech.init.compat.rei.Screens;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.compat.rei.ReiUIAdapter;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.init.compat.rei.OritechDisplay;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.ScreenProvider.GuiSlot;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringJoiner;

import static rearth.oritech.client.ui.BasicMachineScreen.GUI_COMPONENTS;


public class OritechReiDisplay implements DisplayCategory<Display> {
    
    protected final OritechRecipeType recipeType;
    private final Boolean isGenerator;
    private final List<ScreenProvider.GuiSlot> slots;
    private final InventorySlotAssignment slotOffsets;
    protected final class_1935 icon;
    private final ScreenProvider.ArrowConfiguration indicatorConfig;
    
    public OritechReiDisplay(OritechRecipeType recipeType, Class<? extends MachineBlockEntity> screenProviderSource, class_1935 icon) {
        
        var blockState = class_2246.field_10340.method_9564();
        if (icon instanceof class_2248 blockItem)
            blockState = blockItem.method_9564();
        var finalBlockState = blockState;
        
        this.recipeType = recipeType;
        try {
            var screenProvider = screenProviderSource.getDeclaredConstructor(class_2338.class, class_2680.class).newInstance(new class_2338(0, 0, 0), finalBlockState);
            this.isGenerator = screenProvider instanceof UpgradableGeneratorBlockEntity;
            this.slots = screenProvider.getGuiSlots();
            this.slotOffsets = screenProvider.getSlotAssignments();
            this.indicatorConfig = screenProvider.getIndicatorConfiguration();
        } catch (InstantiationException | IllegalAccessException | InvocationTargetException |
                 NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.icon = icon;
    }
    
    public OritechReiDisplay(OritechRecipeType recipeType, class_1935 icon, boolean isGenerator, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment assignments) {
        
        this.recipeType = recipeType;
        this.icon = icon;
        this.isGenerator = isGenerator;
        this.slots = slots;
        this.slotOffsets = assignments;
        this.indicatorConfig = new ScreenProvider.ArrowConfiguration(
          Oritech.id("textures/gui/modular/arrow_empty.png"),
          Oritech.id("textures/gui/modular/arrow_full.png"),
          80, 35, 29, 16, true);
    }
    
    @Override
    public List<Widget> setupDisplay(Display display, Rectangle bounds) {
        var adapter = new ReiUIAdapter<>(bounds, Containers::verticalFlow);
        var root = adapter.rootComponent();
        
        root.horizontalAlignment(HorizontalAlignment.CENTER)
          .surface(Surface.PANEL)
          .padding(Insets.of(4));
        
        fillDisplay(root, (OritechDisplay) display, adapter);
        
        adapter.prepare();
        return List.of(adapter);
    }
    
    @Override
    public int getDisplayHeight() {
        return 74;
    }
    
    public void fillDisplay(FlowLayout root, OritechDisplay display, ReiUIAdapter<FlowLayout> adapter) {
        
        var offsetX = 23;
        var offsetY = 17;
        
        // inputs
        var inputEntries = display.getInputEntries();
        for (int i = 0; i < inputEntries.size(); i++) {
            var entry = inputEntries.get(i);
            if (entry.isEmpty()) continue;
            var pos = slots.get(slotOffsets.inputStart() + i);
            var usedY = Math.clamp(2, pos.y() - offsetY, getDisplayHeight() - 18 - 4);
            root.child(
              adapter.wrap(Widgets.createSlot(new Point(0, 0)).entries(entry).markInput())
                .positioning(Positioning.absolute(pos.x() - offsetX, usedY)));
        }
        
        // arrow
        if (isGenerator) {
            root.child(adapter.wrap(Widgets.createBurningFire(new Point(0, 0))).positioning(Positioning.absolute(indicatorConfig.x() - offsetX, indicatorConfig.y() -  offsetY)));
        } else {
            root.child(adapter.wrap(Widgets.createArrow(new Point(0, 0))).positioning(Positioning.absolute(indicatorConfig.x() - offsetX, indicatorConfig.y() -  offsetY)));
        }
        
        // outputs
        var outputEntries = display.getOutputEntries();
        for (int i = 0; i < outputEntries.size(); i++) {
            var entry = outputEntries.get(i);
            if (entry.isEmpty()) continue;
            var pos = slots.get(slotOffsets.outputStart() + i);
            root.child(
              adapter.wrap(Widgets.createSlot(new Point(0, 0)).entry(entry.get(0)).markOutput())
                .positioning(Positioning.absolute(pos.x() - offsetX, pos.y() - offsetY)));
        }
        
        // data
        var duration = String.format("%.0f", display.getEntry().comp_1933().getTime() / 20f);
        root.child(
          Components.label(class_2561.method_43469("rei.title.oritech.cookingtime", duration, display.getEntry().comp_1933().getTime())).lineHeight(7)
            .positioning(Positioning.relative(90, 100))
        );
        
        // fluids
        if (display.entry.comp_1933().getFluidInput() != null && display.entry.comp_1933().getFluidInput().amount() > 0) {
            var fluidInput = display.entry.comp_1933().getFluidInput();
            
            root.child(rearth.oritech.client.ui.BasicMachineScreen.createFluidRenderer(fluidInput.getFluidStacks().getFirst(), new ScreenProvider.BarConfiguration(4, 5, 16, 50)));
            
            
            var text = fluidInput.amount() > 0
                ? class_2561.method_43469("tooltip.oritech.fluid_content", fluidInput.amount(), fluidInput.name())
                : class_2561.method_43471("tooltip.oritech.fluid_empty");

            if (fluidInput.hasTag()) {
                var joiner = new StringJoiner(", ", "\n", "");
                joiner.setEmptyValue("");
                for (var fluidStack : fluidInput.getFluidStacks()) {
                    joiner.add(fluidStack.getName().getString());
                }
                var fluidsText = class_5250.method_43477(class_2561.method_30163(class_2561.method_30163(joiner.toString()).method_10858(40)).method_10851()).method_54663(BasicMachineScreen.GRAY_TEXT_COLOR);
                text.method_10852(fluidsText);
            }

            var foreGround = Components.texture(GUI_COMPONENTS, 48, 0, 14, 50, 98, 96);
            foreGround.sizing(Sizing.fixed(18), Sizing.fixed(52));
            foreGround.positioning(Positioning.absolute(3, 4));
            foreGround.tooltip(text);
            root.child(foreGround);
        }
        
        if (!display.entry.comp_1933().getFluidOutputs().isEmpty()) {
            var tankCount = 0;
            var tankStartX = display.entry.comp_1933().getFluidOutputs().size() > 1 ? 80 : 120;
            for (var fluidResult : display.entry.comp_1933().getFluidOutputs()) {
                if (fluidResult.isEmpty()) continue;
                
                var amount = fluidResult.getAmount();
                root.child(rearth.oritech.client.ui.BasicMachineScreen.createFluidRenderer(fluidResult, new ScreenProvider.BarConfiguration(tankStartX + tankCount * 20 + 1, 5, 16, 50)));
                
                var text = amount > 0
                             ? class_2561.method_43469("tooltip.oritech.fluid_content", amount, FluidStackHooks.getName(fluidResult).getString())
                             : class_2561.method_43471("tooltip.oritech.fluid_empty");
                var foreGround = Components.texture(GUI_COMPONENTS, 48, 0, 14, 50, 98, 96);
                foreGround.sizing(Sizing.fixed(18), Sizing.fixed(52));
                foreGround.positioning(Positioning.absolute(tankStartX + tankCount * 20, 4));
                foreGround.tooltip(text);
                root.child(foreGround);
                
                tankCount++;
            }
        }
        
    }
    
    @Override
    public CategoryIdentifier<? extends Display> getCategoryIdentifier() {
        return CategoryIdentifier.of(recipeType.getIdentifier());
    }
    
    @Override
    public class_2561 getTitle() {
        return class_2561.method_43471("rei.process." + recipeType.getIdentifier());
    }
    
    @Override
    public Renderer getIcon() {
        return EntryStacks.of(icon);
    }
    
}
