package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import rearth.oritech.block.blocks.reactor.ReactorAbsorberBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatPipeBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatVentBlock;
import rearth.oritech.block.blocks.reactor.ReactorRodBlock;
import rearth.oritech.block.entity.reactor.ReactorAbsorberPortEntity;
import rearth.oritech.block.entity.reactor.ReactorControllerBlockEntity;
import rearth.oritech.block.entity.reactor.ReactorControllerBlockEntity.ComponentStatistics;
import rearth.oritech.block.entity.reactor.ReactorFuelPortEntity;
import rearth.oritech.client.ui.components.ReactorBlockRenderComponent;
import rearth.oritech.client.ui.components.ReactorPreviewContainer;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.ScreenProvider.BarConfiguration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map.Entry;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import rearth.oritech.util.TooltipHelper;

import static rearth.oritech.client.ui.BasicMachineScreen.ORITECH_PANEL;


public class ReactorScreen extends BaseOwoHandledScreen<FlowLayout, ReactorScreenHandler> {
    
    private ArrayList<class_3545<Integer, ReactorBlockRenderComponent>> activeComponents;
    private HashSet<ReactorBlockRenderComponent> activeOverlays;
    private LabelComponent tooltipTitle;
    private FlowLayout tooltipContainer;
    private ReactorBlockRenderComponent selectedBlockOverlay;
    private TextureComponent energyIndicator;
    private LabelComponent productionLabel;
    private LabelComponent hottestLabel;
    private LabelComponent sumHeatLabel;
    private LabelComponent statusLabel;
    
    public ReactorScreen(ReactorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    protected @NotNull OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create(this, Containers::verticalFlow);
    }
    
    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent
          .surface(Surface.VANILLA_TRANSLUCENT)
          .horizontalAlignment(HorizontalAlignment.CENTER)
          .verticalAlignment(VerticalAlignment.CENTER);
        
        tooltipContainer = Containers.verticalFlow(Sizing.content(2), Sizing.content(2));
        tooltipContainer.surface(Surface.VANILLA_TRANSLUCENT);
        tooltipTitle = Components.label(class_2561.method_43470("My title!"));
        tooltipContainer.child(tooltipTitle.margins(Insets.of(6)));
        tooltipContainer.zIndex(3000);
        tooltipContainer.padding(Insets.of(3));
        tooltipTitle.zIndex(3001);
        
        var overlay = Containers.horizontalFlow(Sizing.fixed(340), Sizing.fixed(200));
        rootComponent.child(overlay.surface(ORITECH_PANEL));
        
        addReactorComponentPreview(overlay);
        addReactorStats(overlay);
        addEnergyBar(overlay);
        addReactorStatus(overlay);
        
        addTitle(overlay);
        rootComponent.child(tooltipContainer.positioning(Positioning.absolute(0, 0)));
    }
    
    private void addReactorStats(FlowLayout overlay) {
        var container = Containers.verticalFlow(Sizing.fixed(141), Sizing.content(0));
        
        productionLabel = Components.label(class_2561.method_43469("RF Production: %s RF/t", "50").method_27692(class_124.field_1068));
        sumHeatLabel = Components.label(class_2561.method_43469("Heat Production: %s RF/t", "50").method_27692(class_124.field_1068));
        hottestLabel = Components.label(class_2561.method_43469("Hottest Part: %s RF/t", "50").method_27692(class_124.field_1068));
        
        container.child(productionLabel.margins(Insets.of(4)));
        container.child(hottestLabel.margins(Insets.of(4)));
        container.child(sumHeatLabel.margins(Insets.of(4)));
        
        overlay.child(container.margins(Insets.of(8)).surface(Surface.PANEL_INSET).positioning(Positioning.absolute(183, 16)));
    }
    
    private void addReactorStatus(FlowLayout overlay) {
        
        var container = Containers.verticalFlow(Sizing.fixed(95), Sizing.content(1));
        
        statusLabel = Components.label(class_2561.method_43471("Stable").method_27695(class_124.field_1068, class_124.field_1067));
        
        container.child(statusLabel.horizontalTextAlignment(HorizontalAlignment.CENTER).horizontalSizing(Sizing.fill()).margins(Insets.of(4)));
        
        overlay.child(container.margins(Insets.of(4)).surface(Surface.PANEL_INSET).positioning(Positioning.absolute(187, 75)));
        
    }
    
    private class_2338 getPreviewMax() {
        return field_2797.reactorEntity.areaMax.method_33096(field_2797.reactorEntity.areaMin.method_10264() + 1);
    }
    
    private void addReactorComponentPreview(FlowLayout overlay) {
        
        var holoPreviewContainer = new ReactorPreviewContainer(Sizing.fixed(180), Sizing.fixed(164), FlowLayout.Algorithm.HORIZONTAL, this::onContainerMouseMove);
        holoPreviewContainer.surface(Surface.PANEL_INSET);
        holoPreviewContainer.margins(Insets.of(8));
        
        var totalSize = getPreviewMax().method_10059(field_2797.reactorEntity.areaMin);
        var leftCount = totalSize.method_10260();
        var rightCount = totalSize.method_10263();
        var totalWidth = leftCount + rightCount + 3;
        var middlePercentage = leftCount / (float) totalWidth;
        var xOffset = middlePercentage * 170 + 10;
        
        var size = (int) (170 / (float) totalWidth * 2.2f);
        
        activeComponents = new ArrayList<>();
        activeOverlays = new HashSet<>();
        
        class_2338.method_20437(field_2797.reactorEntity.areaMin, getPreviewMax()).forEach(pos -> {
            var state = field_2797.world.method_8320(pos);
            if (state.method_26215()) return;
            var offset = pos.method_10059(field_2797.reactorEntity.areaMin);
            var projectedPosX = offset.method_10263() * 0.43f - offset.method_10260() * 0.43f;
            var projectedPosY = offset.method_10263() * 0.224f + offset.method_10260() * 0.224f + offset.method_10264() * 0.5f;
            var zIndex = offset.method_10264() - offset.method_10263() - offset.method_10260();
            var preview = new ReactorBlockRenderComponent(null, field_2797.world.method_8321(pos), zIndex, pos.method_10062())
                            .sizing(Sizing.fixed(size))
                            .positioning(Positioning.absolute((int) (projectedPosX * size + xOffset), (int) (-projectedPosY * size) + 100));
            if (offset.method_10264() == 1) {
                activeComponents.add(new class_3545<>(-zIndex, (ReactorBlockRenderComponent) preview));
            }
            holoPreviewContainer.child(preview);
            
            if (state.method_26204() instanceof ReactorRodBlock || state.method_26204() instanceof ReactorHeatPipeBlock) {
                var heatOverlay = new ReactorBlockRenderComponent(class_2246.field_10124.method_9564(), null, zIndex + 0.5f, pos.method_10062())
                                    .sizing(Sizing.fixed(size))
                                    .positioning(Positioning.absolute((int) (projectedPosX * size + xOffset), (int) (-projectedPosY * size) + 100));
                
                holoPreviewContainer.child(heatOverlay);
                activeOverlays.add((ReactorBlockRenderComponent) heatOverlay);
            }
            
        });
        
        selectedBlockOverlay = (ReactorBlockRenderComponent) new ReactorBlockRenderComponent(class_2246.field_10124.method_9564(), null, 10 + 0.5f, class_2338.field_10980)
                                                               .sizing(Sizing.fixed(size))
                                                               .positioning(Positioning.absolute(0, 0));
        holoPreviewContainer.child(selectedBlockOverlay);
        
        activeComponents.sort(Comparator.comparingInt(class_3545::method_15442));
        
        overlay.child(holoPreviewContainer.positioning(Positioning.absolute(0, 16)));
        
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        
        if (field_2797.reactorEntity.componentStats.isEmpty()) return;
        
        for (var overlay : activeOverlays) {
            var data = getStatsAtPosition(overlay.pos);
            
            var isEmpty = data.storedHeat() <= 10;
            if (isEmpty) {
                overlay.state = class_2246.field_10124.method_9564();
                continue;
            }
            
            var res = BlockContent.REACTOR_COLD_INDICATOR_BLOCK.method_9564();
            
            if (data.storedHeat() > 1000) {
                res = BlockContent.REACTOR_HOT_INDICATOR_BLOCK.method_9564();
            } else if (data.storedHeat() > 200) {
                res = BlockContent.REACTOR_MEDIUM_INDICATOR_BLOCK.method_9564();
            }
            
            overlay.state = res;
        }
        
        var stackHeight = field_2797.reactorEntity.areaMax.method_10264() - field_2797.reactorEntity.areaMin.method_10264() - 1;
        
        // gather stats
        var sumProducedEnergy = field_2797.reactorEntity.componentStats.values().stream()
                                  .mapToInt(data -> data.receivedPulses() * ReactorControllerBlockEntity.RF_PER_PULSE * stackHeight).sum();
        
        
        var sumProducedHeat = field_2797.reactorEntity.componentStats.values().stream()
                                .filter(elem -> elem.receivedPulses() > 0)
                                .mapToInt(ReactorControllerBlockEntity.ComponentStatistics::heatChanged).sum();
        
        var hottestComponent = field_2797.reactorEntity.componentStats.values().stream()
                                 .mapToInt(ReactorControllerBlockEntity.ComponentStatistics::storedHeat)
                                 .max().orElse(0);
        
        productionLabel.text(class_2561.method_43469("text.oritech.reactor.rf_production", TooltipHelper.getEnergyText(sumProducedEnergy)));
        hottestLabel.text(class_2561.method_43469("text.oritech.reactor.hottest_part", hottestComponent));
        sumHeatLabel.text(class_2561.method_43469("text.oritech.reactor.heat_production", sumProducedHeat));
        
        // update status
        var isActive = sumProducedEnergy + sumProducedHeat > 0;
        var activeLabel = "idle";
        var color = class_124.field_1068;
        
        if (isActive) {
            if (hottestComponent < 100) {
                activeLabel = "stable";
            } else if (hottestComponent < 1200) {
                activeLabel = "heating_up";
                color = class_124.field_1054;
            } else if (hottestComponent < 1700) {
                activeLabel = "unstable";
                color = class_124.field_1061;
            } else {
                activeLabel = "explosion_imminent";
                color = class_124.field_1079;
            }
        }
        
        statusLabel.text(class_2561.method_43471("text.oritech.reactor." + activeLabel).method_27692(class_124.field_1067).method_27692(color));
        
        updateEnergyBar();
        
    }
    
    private void onContainerMouseMove(int mouseX, int mouseY) {
        
        var posX = mouseX;
        var posY = mouseY;
        
        // check if self is on top of activeComponents
        for (var component : activeComponents) {
            var hit = component.method_15441().isInBoundingBox(mouseX, mouseY);
            if (hit) {
                var pos = component.method_15441().pos;
                addStatsToTooltip(pos, field_2797.world.method_8320(pos), tooltipContainer);
                posX = component.method_15441().x();
                posY = component.method_15441().y();
                
                selectedBlockOverlay.state = BlockContent.ADDON_INDICATOR_BLOCK.method_9564();
                selectedBlockOverlay.pos = pos;
                selectedBlockOverlay.zIndex = component.method_15441().zIndex + 0.6f;
                selectedBlockOverlay.positioning(component.method_15441().positioning().get());
                
                break;
            }
        }
        
        if (posX == mouseX) {   // move out of visible area
            tooltipContainer.positioning(Positioning.absolute(-100, -500));
            selectedBlockOverlay.state = class_2246.field_10124.method_9564();
            return;
        }
        
        var containerHeight = tooltipContainer.height();
        
        tooltipContainer.positioning(Positioning.absolute(posX - 30, posY - 5 - containerHeight));
        
    }
    
    public void addStatsToTooltip(class_2338 pos, class_2680 state, FlowLayout container) {
        
        container.clearChildren();
        
        var blockname = state.method_26204().method_9518();
        container.child(Components.label(blockname.method_27695(class_124.field_1068, class_124.field_1067)).margins(Insets.of(0, 3, 0, 0)));
        
        var stats = getStatsAtPosition(pos);
        if (stats.storedHeat() == -1) return;
        
        var stackHeight = field_2797.reactorEntity.areaMax.method_10264() - field_2797.reactorEntity.areaMin.method_10264() - 1;
        var portPosition = pos.method_10069(0, stackHeight, 0);
        var portEntity = field_2797.world.method_8321(portPosition);
        if (portEntity != null && portEntity.method_11015()) return;
        
        
        if (state.method_26204() instanceof ReactorRodBlock rodBlock) {
            var rodCount = rodBlock.getRodCount();
            var totalPulses = stats.receivedPulses();
            var createdPulses = rodBlock.getInternalPulseCount();
            var externalPulses = totalPulses - createdPulses;
            var generatedEnergy = ReactorControllerBlockEntity.RF_PER_PULSE * totalPulses;
            var generatedHeat = stats.heatChanged();
            var heat = stats.storedHeat();
            
            if (totalPulses == 0) { // probably no fuel
                createdPulses = 0;
                externalPulses = 0;
            }
            
            if (!(portEntity instanceof ReactorFuelPortEntity fuelPortEntity)) return;
            var availableFuel = fuelPortEntity.availableFuel;
            var maxFuel = fuelPortEntity.currentFuelOriginalCapacity;
            
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.rod_count", rodCount).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.generated_pulses", createdPulses).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.received_pulses", externalPulses).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.generated_heat", generatedHeat).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.generated_energy", generatedEnergy).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.heat", heat).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.fuel", availableFuel, maxFuel).method_27692(class_124.field_1068)));
        } else if (state.method_26204() instanceof ReactorHeatPipeBlock pipeBlock) {
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.collected_heat", stats.heatChanged()).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.heat", stats.storedHeat()).method_27692(class_124.field_1068)));
        } else if (state.method_26204() instanceof ReactorHeatVentBlock pipeBlock) {
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.removed_heat", stats.heatChanged()).method_27692(class_124.field_1068)));
        } else if (state.method_26204() instanceof ReactorAbsorberBlock absorberBlock) {
            
            if (!(portEntity instanceof ReactorAbsorberPortEntity absorberPortEntity)) return;
            var availableFuel = absorberPortEntity.availableFuel;
            var maxFuel = absorberPortEntity.currentFuelOriginalCapacity;
            
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.absorbed_heat", stats.heatChanged()).method_27692(class_124.field_1068)));
            container.child(Components.label(class_2561.method_43469("text.oritech.reactor.absorbant", availableFuel, maxFuel).method_27692(class_124.field_1068)));
        }
        
    }
    
    public ReactorControllerBlockEntity.ComponentStatistics getStatsAtPosition(class_2338 pos) {
        
        if (field_2797.reactorEntity.componentStats.isEmpty())
            return ReactorControllerBlockEntity.ComponentStatistics.EMPTY;
        
        var reactorMin = field_2797.reactorEntity.areaMin;
        
        for (var entry : field_2797.reactorEntity.componentStats.entrySet()) {
            var localPos = entry.getKey();
            var worldPos = reactorMin.method_10069(localPos.x + 1, 1, localPos.y + 1);
            if (worldPos.equals(pos)) return entry.getValue();
        }
        
        return ReactorControllerBlockEntity.ComponentStatistics.EMPTY;
    }
    
    private void addTitle(FlowLayout overlay) {
        var blockTitle = field_2797.reactorEntity.method_11010().method_26204().method_9518();
        var label = Components.label(blockTitle);
        label.color(new Color(64 / 255f, 64 / 255f, 64 / 255f));
        label.sizing(Sizing.fixed(176), Sizing.content(2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child(label.positioning(Positioning.relative(50, 3)));
    }
    
    private void addEnergyBar(FlowLayout panel) {
        
        var config = new ScreenProvider.BarConfiguration(295, 80, 36, 108);
        var insetSize = 1;
        var tooltipText = class_2561.method_43469("tooltip.oritech.energy_indicator", 10, 50);
        
        var frame = Containers.horizontalFlow(Sizing.fixed(config.width() + insetSize * 2), Sizing.fixed(config.height() + insetSize * 2));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of(insetSize));
        frame.positioning(Positioning.absolute(config.x() - insetSize, config.y() - insetSize));
        panel.child(frame);
        
        var indicator_background = Components.texture(BasicMachineScreen.GUI_COMPONENTS, 24, 0, 24, 96, 98, 96);
        indicator_background.sizing(Sizing.fixed(config.width()), Sizing.fixed(config.height()));
        
        energyIndicator = Components.texture(BasicMachineScreen.GUI_COMPONENTS, 0, 0, 24, (96), 98, 96);
        energyIndicator.sizing(Sizing.fixed(config.width()), Sizing.fixed(config.height()));
        energyIndicator.positioning(Positioning.absolute(0, 0));
        energyIndicator.tooltip(tooltipText);
        
        frame
          .child(indicator_background)
          .child(energyIndicator);
    }
    
    protected void updateEnergyBar() {
        
        var capacity = field_2797.reactorEntity.energyStorage.getCapacity();
        var amount = field_2797.reactorEntity.energyStorage.getAmount();
        
        var fillAmount = (float) amount / capacity;
        var tooltipText = BasicMachineScreen.getEnergyTooltip(amount, capacity, 0, 0);
        
        energyIndicator.tooltip(tooltipText);
        energyIndicator.visibleArea(PositionedRectangle.of(0, 96 - ((int) (96 * (fillAmount))), 24, (int) (96 * fillAmount)));
    }
}
