package rearth.oritech.client.ui;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.addons.InventoryProxyAddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.util.ScreenProvider;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_9139;

public class InventoryProxyScreenHandler extends class_1703 {
    
    @NotNull
    protected final class_2338 blockPos;
    @NotNull
    protected final InventoryProxyAddonBlockEntity addonEntity;
    
    protected int selectedSlot = 0;

    @NotNull
    protected final ScreenProvider controllerScreen;
    
    public record InvProxyData(class_2338 ownPos, class_2338 controllerPos, int slot) {
        public static final Endec<InvProxyData> PACKET_ENDEC = StructEndecBuilder.of(MinecraftEndecs.BLOCK_POS.fieldOf("ownPos", InvProxyData::ownPos), MinecraftEndecs.BLOCK_POS.fieldOf("controllerPos", InvProxyData::controllerPos), Endec.INT.fieldOf("slot", InvProxyData::slot), InvProxyData::new);
        public static final class_9139<class_2540, InvProxyData> PACKET_CODEC = CodecUtils.toPacketCodec(PACKET_ENDEC);
    }
    
    public InventoryProxyScreenHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(syncId, inventory, InvProxyData.PACKET_CODEC.decode(buf));
    }
    
    public InventoryProxyScreenHandler(int syncId, class_1661 inventory, InvProxyData data) {
        this(syncId, inventory, Objects.requireNonNull(inventory.field_7546.method_37908().method_8321(data.ownPos())), (ScreenProvider) inventory.field_7546.method_37908().method_8321(data.controllerPos), data.slot);
    }

    // on server, also called from client constructor
    public InventoryProxyScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity, @NotNull ScreenProvider controllerScreen, int selectedSlot) {
        super(ModScreens.INVENTORY_PROXY_SCREEN, syncId);
        
        this.blockPos = blockEntity.method_11016();
        this.controllerScreen = controllerScreen;
        this.selectedSlot = selectedSlot;
        this.addonEntity = (InventoryProxyAddonBlockEntity) blockEntity;
    }

    public @NotNull class_2338 getBlockPos() {
        return blockPos;
    }
    
    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }
    
    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }
}
