package rearth.oritech.client.renderers;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.ui.core.Color;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.oritech.api.fluid.FluidApi.SingleSlotStorage;
import rearth.oritech.block.entity.processing.RefineryBlockEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class RefineryRenderer<T extends RefineryBlockEntity & GeoAnimatable> extends GeoBlockRenderer<T> {
    
    private final Map<Long, VisualTankHeights> tankHeights = new HashMap<>();
    
    public RefineryRenderer(String model) {
        super(new MachineModel<>(model));
    }
    
    // this overrides a method from IBlockEntityRendererExtension on NF. Since this extension mixin is not available in common, we just declare the methode without\
    // the override annotation
    public class_238 getRenderBoundingBox(T blockEntity) {
        return class_238.method_30048(blockEntity.method_11016().method_46558(), 6, 6, 6);
    }
    
    @Override
    public void postRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        
        var consumer = bufferSource.getBuffer(class_1921.method_23583());
        // consumer = buffer;
        
        var lastHeight = tankHeights.computeIfAbsent(animatable.method_11016().method_10063(), key -> new VisualTankHeights());
        
        var inputStack = animatable.ownStorage.getInStack();
        if (!inputStack.isEmpty()) {
            // render in stack
            renderFluidCube(new class_243(-24 / 16f, 3 / 16f, 11 / 16f), new Vector3f(12 / 16f, 25 / 16f, 28 / 16f), inputStack, animatable.ownStorage.getCapacity(), consumer, poseStack, packedLight, packedOverlay, -1, lastHeight);
        }
        
        var moduleCount = animatable.getModuleCount();
        for (int i = 0; i <= moduleCount; i++) {
            var outputStorage = animatable.getOutputStorage(i);
            var renderedStack = outputStorage.getStack();
            if (renderedStack.isEmpty()) continue;
            // render storage
            
            var tankPosition = getTankCoordinates(i);
            renderFluidCube(tankPosition.method_15442(), tankPosition.method_15441(), renderedStack, outputStorage.getCapacity(), consumer, poseStack, packedLight, packedOverlay, i, lastHeight);
        }
        
    }
    
    private static class_3545<class_243, Vector3f> getTankCoordinates(int i) {
        return switch (i) {
            case 0 -> new class_3545<>(new class_243(-22 / 16f, 9 / 16f, -5 / 16f), new Vector3f(7 / 16f, 15 / 16f, 10 / 16f));
            case 1 ->
              new class_3545<>(new class_243(-21 / 16f, 0 / 16f + 2, -5 / 16f), new Vector3f(26 / 16f, 14 / 16f, 26 / 16f));
            case 2 ->
              new class_3545<>(new class_243(-21 / 16f, 0 / 16f + 3, -5 / 16f), new Vector3f(26 / 16f, 14 / 16f, 26 / 16f));
            default -> throw new IllegalStateException("Tried to access invalid tank for renderer: " + i);
        };
    }
    
    private static void renderFluidCube(class_243 min, Vector3f size, FluidStack drawnStack, Long tankCapacity, class_4588 consumer, class_4587 matrices, int light, int overlay, int index, VisualTankHeights lastHeight) {
        var fluid = drawnStack.getFluid();
        var fill = drawnStack.getAmount() / (float) tankCapacity;
        
        var lastFill = index == -1 ? lastHeight.input : lastHeight.outputs[index];
        var newFill = class_3532.method_16439(0.003f, lastFill, fill);
        if (index == -1) {
            lastHeight.input = newFill;
        } else {
            lastHeight.outputs[index] = newFill;
        }
        
        var sprite = FluidStackHooks.getStillTexture(fluid);
        var spriteColor = FluidStackHooks.getColor(fluid);
        
        var parsedColor = Color.ofArgb(spriteColor);
        var opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1f);
        spriteColor = opaqueColor.argb();
        
        matrices.method_22903();
        matrices.method_22904(min.field_1352 + 0.01f, min.field_1351 + 0.01f, min.field_1350 + 0.01f);
        matrices.method_22905(size.x - 0.02f, size.y * newFill - 0.03f, size.z - 0.02f);
        
        var entry = matrices.method_23760();
        var modelMatrix = entry.method_23761();
        
        // Draw the cube using quads
        for (var direction : class_2350.values()) {
            if (direction.equals(class_2350.field_11033)) continue; // skip bottom, as it's never visible
            SmallTankRenderer.drawQuad(direction, consumer, modelMatrix, entry, sprite, spriteColor, light, overlay);
        }
        
        matrices.method_22909();
    }
    
    private static class VisualTankHeights {
        private float input = 0;
        private final float[] outputs = new float[3];
    }
}
