package rearth.oritech.client.renderers;

import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;

public class MachineRenderer<T extends class_2586 & GeoAnimatable> extends GeoBlockRenderer<T> {
    public MachineRenderer(String modelPath) {
        super(new MachineModel<>(modelPath));
    }
    
    public MachineRenderer(String modelPath, boolean glowing) {
        super(new MachineModel<>(modelPath));
        
        if (glowing) {
            addRenderLayer(new CustomGlowingGeoLayer<>(this));
        }
    }
    
    @Override
    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        
        if (facing.equals(class_2350.field_11036)) {
            poseStack.method_22904(0, 0.5, -0.5);
        } else if (facing.equals(class_2350.field_11033)) {
            poseStack.method_22904(0, 0.5, 0.5);
        }
        
        super.rotateBlock(facing, poseStack);
        
    }
    
    // this overrides a method from IBlockEntityRendererExtension on NF. Since this extension mixin is not available in common, we just declare the methode without\
    // the override annotation
    public class_238 getRenderBoundingBox(class_2586 blockEntity) {
        return class_238.method_30048(blockEntity.method_11016().method_46558(), 4, 4, 4);
    }
    
    public static class CustomGlowingGeoLayer<T extends class_2586 & GeoAnimatable> extends AutoGlowingGeoLayer<T> {
        
        public CustomGlowingGeoLayer(GeoRenderer<T> renderer) {
            super(renderer);
        }
        
        @Override
        protected @Nullable class_1921 getRenderType(T animatable, @Nullable class_4597 bufferSource) {
            
            if (this.renderer.getGeoModel() instanceof MachineModel<T> machineModel) {
                var basePath = machineModel.getBaseTexturePath(animatable);
                var path = GeoAbstractTexture.appendToPath(basePath, "_glowmask");
                return AutoGlowingTexture.getRenderType(path);
            }
            
            return AutoGlowingTexture.getRenderType(getTextureResource(animatable));
        }
    }
}


